//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const currentAlarm = {
  List: [
    {
      EventCode: '0x0200000B',
      Content: 'The disk Disk42 RAID array is invalid.',
      Subject: 'Disk',
      HandlingSuggestion:
        '1. If a member disk is removed, reinstall the disk.@#AB;2. If all member disks are installed, replace the faulty disks.',
      CreatedTime: '2022-02-22T12:06:42-12:00',
      Level: 'Major',
      ID: 0
    },
    {
      EventCode: '0x0200000B',
      Content: 'The disk Disk41 RAID array is invalid.',
      Subject: 'Disk',
      HandlingSuggestion:
        '1. If a member disk is removed, reinstall the disk.@#AB;2. If all member disks are installed, replace the faulty disks.',
      CreatedTime: '2022-02-22T12:06:41-12:00',
      Level: 'Major',
      ID: 2
    },
    {
      EventCode: '0x0200000B',
      Content: 'The disk Disk43 RAID array is invalid.',
      Subject: 'Disk',
      HandlingSuggestion:
        '1. If a member disk is removed, reinstall the disk.@#AB;2. If all member disks are installed, replace the faulty disks.',
      CreatedTime: '2022-02-22T12:06:43-12:00',
      Level: 'Major',
      ID: 3
    },
    {
      EventCode: '0x0200000B',
      Content: 'The disk Disk40 RAID array is invalid.',
      Subject: 'Disk',
      HandlingSuggestion:
        '1. If a member disk is removed, reinstall the disk.@#AB;2. If all member disks are installed, replace the faulty disks.',
      CreatedTime: '2022-02-22T12:06:41-12:00',
      Level: 'Major',
      ID: 4
    },
    {
      EventCode: '0x1A000045',
      Content: 'The CRL for Syslog root certificate is about to expire or has expired.',
      Subject: 'BMC',
      HandlingSuggestion: 'Import the new CRL.',
      CreatedTime: '2022-02-25T11:33:22-12:00',
      Level: 'Minor',
      ID: 5
    },
    {
      EventCode: '0x1A000023',
      Content: 'LDAPServer1 certificate is about to expire or has expired.',
      Subject: 'BMC',
      HandlingSuggestion: 'Import the new certificate.',
      CreatedTime: '2022-02-25T11:33:20-12:00',
      Level: 'Minor',
      ID: 6
    },
    {
      EventCode: '0x2C000073',
      Content: 'The total power consumption (222.000 W) of the system exceeds the alarm threshold (200.000 W).',
      Subject: 'System',
      HandlingSuggestion:
        '1. Check whether the alarm threshold for high power consumption is set too low.@#AB;2. Stop unnecessary services on the OS to release CPU and memory resources.',
      CreatedTime: '2022-02-22T12:04:55-12:00',
      Level: 'Minor',
      ID: 7
    }
  ],
  TotalCount: 7
};

export const systemEvent = {
  List: [
    {
      EventCode: '0x05000001',
      Content: 'Power supply to front disk backplane 5V failed.',
      Level: 'Major',
      ID: 1133,
      Status: 'Asserted',
      CreatedTime: '2022-03-01 12:38:23',
      HandlingSuggestion:
        '1. Remove and reinstall the cables of the disk backplane.@#AB;2. Replace the disk backplane.',
      Subject: 5
    },
    {
      EventCode: '0x2C00001B',
      Content: 'The OS cannot start without a boot device.',
      Level: 'Informational',
      ID: 1132,
      Status: 'Asserted',
      CreatedTime: '2022-02-24 23:38:04',
      HandlingSuggestion: 'N/A.',
      Subject: 44
    },
    {
      EventCode: '0x05000002',
      Content: 'Power supply to front disk backplane 5V failed.',
      Level: 'Major',
      ID: 1131,
      Status: 'Deasserted',
      CreatedTime: '2022-02-24 23:36:44',
      HandlingSuggestion:
        '1. Remove and reinstall the cables of the disk backplane.@#AB;2. Replace the disk backplane.',
      Subject: 5
    },
    {
      EventCode: '0x05000001',
      Content: 'Power supply to front disk backplane 5V failed.',
      Level: 'Major',
      ID: 1130,
      Status: 'Asserted',
      CreatedTime: '2022-02-24 23:36:36',
      HandlingSuggestion:
        '1. Remove and reinstall the cables of the disk backplane.@#AB;2. Replace the disk backplane.',
      Subject: 5
    },
    {
      EventCode: '0x2C000009',
      Content: 'ACPI is in the working state.',
      Level: 'Informational',
      ID: 1129,
      Status: 'Asserted',
      CreatedTime: '2022-02-24 23:36:31',
      HandlingSuggestion: 'N/A.',
      Subject: 44
    },
    {
      EventCode: '0x2C000011',
      Content: 'The host was restarted by command.',
      Level: 'Informational',
      ID: 1128,
      Status: 'Asserted',
      CreatedTime: '2022-02-24 23:36:31',
      HandlingSuggestion: 'N/A.',
      Subject: 44
    },
    {
      EventCode: '0x05000002',
      Content: 'Power supply to front disk backplane 5V failed.',
      Level: 'Major',
      ID: 1127,
      Status: 'Deasserted',
      CreatedTime: '2022-02-24 23:36:27',
      HandlingSuggestion:
        '1. Remove and reinstall the cables of the disk backplane.@#AB;2. Replace the disk backplane.',
      Subject: 5
    },
    {
      EventCode: '0x2C000030',
      Content: 'The server system crashes or is abnormally reset.',
      Level: 'Informational',
      ID: 1126,
      Status: 'Deasserted',
      CreatedTime: '2022-02-24 23:36:25',
      HandlingSuggestion: "1. Collect iBMC and OS logs.@#AB;2. Contact the device vendor' technical support engineer.",
      Subject: 44
    },
    {
      EventCode: '0x2C00000B',
      Content: 'ACPI is in the soft-off state.',
      Level: 'Informational',
      ID: 1125,
      Status: 'Asserted',
      CreatedTime: '2022-02-24 23:36:21',
      HandlingSuggestion: 'N/A.',
      Subject: 44
    },
    {
      EventCode: '0x2C00002F',
      Content: 'The server system crashes or is abnormally reset.',
      Level: 'Informational',
      ID: 1124,
      Status: 'Asserted',
      CreatedTime: '2022-02-24 22:32:47',
      HandlingSuggestion: "1. Collect iBMC and OS logs.@#AB;2. Contact the device vendor' technical support engineer.",
      Subject: 44
    }
  ],
  TotalCount: 10
};

export const eventObjectType = {
  List: [
    { Label: 'CPU', ID: 0 },
    { Label: 'Memory', ID: 1 },
    { Label: 'Disk', ID: 2 },
    { Label: 'PSU', ID: 3 },
    { Label: 'Fan', ID: 4 },
    { Label: 'Disk Backplane', ID: 5 },
    { Label: 'RAID Card', ID: 6 },
    { Label: 'NIC', ID: 13 },
    { Label: 'PCIe Riser', ID: 15 },
    { Label: 'Mainboard', ID: 16 },
    { Label: 'Chassis', ID: 18 },
    { Label: 'BMC', ID: 26 },
    { Label: 'PCIe Adapter', ID: 38 },
    { Label: 'PCH', ID: 39 },
    { Label: 'Cable', ID: 40 },
    { Label: 'Port', ID: 41 },
    { Label: 'PHY', ID: 43 },
    { Label: 'System', ID: 44 },
    { Label: 'Button', ID: 49 },
    { Label: 'PCIe Retimer', ID: 69 },
    { Label: 'BMA', ID: 73 }
  ],
  TotalCount: 21
};
