# openUBMC WebUI 前端开发说明文档

---

## 一、技术栈与界面规范概览

### 1. 前端技术栈

openUBMC 前端项目采用现代化前端技术架构，具有良好的可维护性与扩展性：

- **框架**：Vue 3
- **组件库**：
  - [Element Plus](https://element-plus.org/)：企业级 UI 组件库
  - OpenDesign V2：符合OpenDesign设计规范的视觉标准的定制化组件库
- **构建工具**：Vite
- **状态管理**：Pinia
- **代码规范**：
  - ESLint + Prettier 格式化规范
  - Typescript 类型检查
  - 按遵循OpenDesign设计规范进行交互界面设计

### 2. 浏览器兼容性

| 浏览器    | 支持版本范围   |
|-----------|----------------|
| Edge      | 79 - 97        |
| Firefox   | 78 - 96        |
| Chrome    | 64 - 97        |
| Safari    | 12 - 15.2      |

> 注：兼容性测试基于主流版本，实际支持可能超出表列范围。

### 3. 建议屏幕分辨率

为保证最佳用户体验，推荐使用以下分辨率访问：

- 1280 × 800  
- 1366 × 768  
- 1440 × 900  
- 1600 × 900  
- 1600 × 1200  
- 1680 × 1050  
- 1920 × 1080  
- 1920 × 1200  

---

## 二、前端代码目录结构

openUBMC WebUI 项目采用模块化结构，目录清晰、职责分明：

```text
├── mock/             # 前端模拟服务与数据
├── public/           # 公共静态资源
├── src/              # 所有业务模块（见下方说明）
├── types/            # 类型定义与配置
├── .env.*            # 环境变量配置（开发 / 生产）
├── .eslintrc.js      # ESLint 配置
├── .prettierrc.js    # Prettier 格式化配置
├── vite.config.ts    # Vite 构建 / 代理 / mock 配置
├── package.json      # 项目依赖与脚本
└── index.html        # HTML 模板入口
```

### src/ 子目录说明

| 目录名       | 功能描述                     |
|--------------|------------------------------|
| api/       | 封装的接口请求与路径配置     |
| apps/      | 项目子模块，功能组织单元     |
| assets/    | 样式、图像等静态资源         |
| components/| 公共组件库                   |
| data/      | 静态数据、常量               |
| directive/ | 自定义指令定义               |
| hooks/     | 通用组合式函数               |
| model/     | 接口模型与枚举               |
| pages/     | 页面视图与业务逻辑           |
| plugins/   | 插件注册，如 open-design     |
| services/  | 核心服务逻辑                 |
| static/    | 纯静态资源                   |
| stores/    | 状态管理（Pinia）            |
| utils/     | 通用工具函数                 |
| validators/| 表单校验规则                 |
| App.vue    | 应用根组件                   |
| main.ts    | 应用入口                     |
| env.d.ts   | 全局类型声明                 |

---

## 三、环境配置与项目启动

为了顺利开发和调试，请按以下步骤配置和启动项目：

### 步骤一：安装依赖

推荐使用 [Node.js LTS 版本](https://nodejs.org/en/)。

bash
npm install



### 步骤二：配置代理

编辑根目录下的 vite.config.ts 文件，配置开发代理用于 API 请求转发。

示例配置：

```ts
// vite.config.ts
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'

export default defineConfig({
  plugins: [vue()],
  server: {
    proxy: {
      '/api': {
        target: 'http://127.0.0.1:8080', // ← 替换为后端服务地址
        changeOrigin: true,
        rewrite: path => path.replace(/^\/api/, ''),
      },
    },
  },
})
```


### 步骤三：启动开发服务器

使用以下命令启动本地调试：

```bash
npm run dev
```


默认地址为：

http://localhost:5173/


### 步骤四：浏览器访问页面

打开浏览器，访问本地地址 http://localhost:5173/，即可预览前端页面。

### 步骤五：热更新与调试说明

- 修改 .vue、.ts、.scss 文件后，系统将自动热更新；
- 若更新未生效，请手动刷新浏览器查看修改效果。