-- Copyright (c) 2026 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local thermal_mgmt_app = require 'thermal_mgmt_app'

TestThermalMgmtApp = {}

function TestThermalMgmtApp:test_register_reboot_methods()
    local reboot_manage = require 'mc.mdb.micro_component.reboot'
    local on_prepare_callback, on_action_callback, on_cancel_callback = nil, nil, nil
    reboot_manage.on_prepare = function(cb)
        on_prepare_callback = cb
    end
    reboot_manage.on_action = function(cb)
        on_action_callback = cb
    end
    reboot_manage.on_cancel = function(cb)
        on_cancel_callback = cb
    end
    local thermal_mgmt_app_mock = {
        reboot_prepare = true,
        cooling_service = {
            on_prepare = function (...)
            end,
            on_action = function (...)
            end,
            on_cancel = function (...)
            end
        },
        on_reboot_prepare = function (...)
            error('test error')
        end,
        on_reboot_action = function (...)
        end,
        on_reboot_cancel = function (...)
        end
    }
    local ok = pcall(function()
        thermal_mgmt_app.register_reboot_methods(thermal_mgmt_app_mock)
    end)
    lu.assertEquals(ok, true)
    local rsp = on_prepare_callback()
    lu.assertEquals(rsp, -1)
    lu.assertEquals(thermal_mgmt_app_mock.reboot_prepare, false)
    thermal_mgmt_app_mock.reboot_prepare = true
    on_cancel_callback()
    lu.assertEquals(thermal_mgmt_app_mock.reboot_prepare, false)
end
