-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local HDD_BACKPLANE_INTERFACE <const> = "bmc.kepler.Systems.Board"

TestHddBackplane = {}

function TestHddBackplane:test_action_after_property_changed()
    local hdd_backplane_data_keeping = require 'basic_cooling.data_keeping.hddbackplane_data_keeping'
    local hdd_backplane1_name = 'hdd_backplane_name1'
    local hdd_backplane2_name = 'hdd_backplane_name2'
    local hdd_backplane_path = '/bmc/kepler/Systems/1/Boards/HddBackplane/HddBackplane_1_01'

    hdd_backplane_data_keeping.loaded_hdd_backplanes = {
        [hdd_backplane1_name] = 1
    }
    hdd_backplane_data_keeping.hdd_backplane_path_name_map = {
        [hdd_backplane_path] = hdd_backplane1_name
    }

    hdd_backplane_data_keeping:action_after_property_changed(hdd_backplane_path, HDD_BACKPLANE_INTERFACE,
        'Name', hdd_backplane2_name)
    lu.assertEquals(hdd_backplane_data_keeping.loaded_hdd_backplanes[hdd_backplane1_name], 0)
    lu.assertEquals(hdd_backplane_data_keeping.loaded_hdd_backplanes[hdd_backplane2_name], 1)
    lu.assertEquals(hdd_backplane_data_keeping.hdd_backplane_path_name_map[hdd_backplane_path], hdd_backplane2_name)
end