-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local file_sec = require 'utils.file'
local fan_service = require 'fan_service'
local c_fan_object = require 'fan_object'
local c_fan_type_object = require 'fan_type_object'
local client = require 'thermal_mgmt.client'

TestFanService = {}

function TestFanService:test_get_dump_pwm_by_fan_obj()
    local fan_obj1 = {
        HardwarePWM = 66,
        PowerGood = 1,
        standbyfan = false
    }
    local fan_obj2 = {
        HardwarePWM = 66,
        PowerGood = 0,
        standbyfan = true
    }
    local fan_obj3 = {
        HardwarePWM = 66,
        PowerGood = 0,
        standbyfan = false
    }

    local pwm = fan_service.get_dump_pwm_by_fan_obj(fan_obj1)
    lu.assertEquals(pwm, 66)
    pwm = fan_service.get_dump_pwm_by_fan_obj(fan_obj2)
    lu.assertEquals(pwm, 66)
    pwm = fan_service.get_dump_pwm_by_fan_obj(fan_obj3)
    lu.assertEquals(pwm, 0)
end

function TestFanService:test_dump_obj_infos()
    local path = "/tmp/test.txt"
    local fp_w = file_sec.open_s(path, 'w+')

    local fan_objs = {
        {['ObjectNmae'] = "Fan_1",
         ['FanId'] = 1,
         ['RearStatus'] =  0,
         ['FrontStatus'] =  0,
         get_all_prop_names = function(...) return {} end
        }
    }
    c_fan_object.collection.fold = function (_, func, acc)
        local exit_loop = false
        for _, fan_obj in pairs(fan_objs) do
            acc, exit_loop = func(acc, fan_obj)
            if exit_loop then
                break
            end
        end
        return acc
    end

    local fan_type_objs = {
        {['ObjectNmae'] = "Fan_type_1",
         get_all_prop_names = function(...) return {} end
        }
    }
    c_fan_type_object.collection.fold = function (_, func, acc)
        local exit_loop = false
        for _, fan_type_obj in pairs(fan_type_objs) do
            acc, exit_loop = func(acc, fan_type_obj)
            if exit_loop then
                break
            end
        end
        return acc
    end
    local ok = pcall(fan_service.dump_obj_infos, fan_service, fp_w)
    lu.assertTrue(ok)
end

function TestFanService:test_fan_board_listenning()
    local origin = client.OnUnitPropertiesChanged
    client.OnUnitPropertiesChanged = function(self, cb)
        cb('', '', '')
    end
    fan_service.listener = {}
    local ok = pcall(fan_service.fan_board_listenning, fan_service, '', '')
    lu.assertTrue(ok)
    client.OnUnitPropertiesChanged = origin
end