-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'
local cooling_enums = require 'basic_cooling.define.cooling_enums'
local props = require 'basic_cooling.define.cooling_properties'
local pumps_config = require 'basic_cooling.cooling_config.pumps_config'

TestCoolingRpc = {}

function TestCoolingRpc:test_set_ctrl_mode()
    local cooling_rpc = require 'basic_cooling.cooling_intf.cooling_rpc'
    local context = require 'mc.context'

    cooling_rpc.fans_config_instance = {
        get_obj = function ()
            return { ['MixedModeSupported'] = true,
                     ['FanCtrlEnable'] = 'Enabled'}
        end
    }
    cooling_rpc.mgmt_instance = {
        set_fan_ctrl_mode_persist_type = function (ctrl_mode_persist_type)
            return ctrl_mode_persist_type
        end,
        set_fan_ctrl_mode = function (mode, timeout)
            return mode, timeout
        end
    }

    --设置模式为混合模式
    local ok1 = pcall(function ()
        return cooling_rpc.SetCtrlMode(cooling_rpc, nil, context, cooling_enums.modes.Mixed, 30)
    end)
    lu.assertEquals(ok1,true)

    --设置模式为手动模式
    local ok2 = pcall(function ()
        return cooling_rpc.SetCtrlMode(cooling_rpc, nil, context, cooling_enums.modes.Manual, 30)
    end)
    lu.assertEquals(ok2,true)

    --设置模式为自动模式
    local ok3 = pcall(function ()
        return cooling_rpc.SetCtrlMode(cooling_rpc, nil, context, cooling_enums.modes.Auto, 30)
    end)
    lu.assertEquals(ok3,true)
    
    local obj = {CtrlMode = 'Manual'}
    local ok4 = pcall(function ()
        pumps_config:SetCtrlMode(obj, context, 'Mixed', 30)
    end)
    lu.assertEquals(ok3,true)

end

function TestCoolingRpc:test_set_ctrl_mode_presist()
    local cooling_rpc = require 'basic_cooling.cooling_intf.cooling_rpc'
    local context = require 'mc.context'

    cooling_rpc.fans_config_instance = {
        get_obj = function ()
            return { ['MixedModeSupported'] = true,
                     ['FanCtrlEnable'] = 'Enabled'}
        end
    }
    cooling_rpc.mgmt_instance = {
        set_fan_ctrl_mode_persist_type = function (ctrl_mode_persist_type)
            return ctrl_mode_persist_type
        end,
        set_fan_ctrl_mode_persist = function (mode, timeout, ctrl_mode_persist_type)
            return mode, timeout, ctrl_mode_persist_type
        end
    }
    cooling_rpc.air_config_instance = {object_from_sr = true}

    --设置模式为混合模式
    local ok1 = pcall(function ()
        return cooling_rpc.SetCtrlModePersist(cooling_rpc, nil, context, 
        cooling_enums.modes.Mixed, cooling_enums.persist_type.Memory, 30)
    end)
    lu.assertEquals(ok1,true)

    --设置模式为手动模式
    local ok2 = pcall(function ()
        return cooling_rpc.SetCtrlModePersist(cooling_rpc, nil, context, 
        cooling_enums.modes.Manual, cooling_enums.persist_type.Memory, 30)
    end)
    lu.assertEquals(ok2,true)

    --设置模式为自动模式
    local ok3 = pcall(function ()
        return cooling_rpc.SetCtrlModePersist(cooling_rpc, nil, context, 
        cooling_enums.modes.Auto, cooling_enums.persist_type.Memory, 30)
    end)
    lu.assertEquals(ok3,true)

end
