local lu = require 'luaunit'
local cooling_intf = require 'basic_cooling.cooling_pid_intf'
local exception_policy = require 'basic_cooling.exception_policy'
TestCoolingPidIntf = {}

function TestCoolingPidIntf:test_cooling_fan_speed_to_pid()
    local fan_devices = {
        {
            Id = 12,
            FrontSpeed = 378,
            RearSpeed = 388
        },
        {
            Id = 13,
            FrontSpeed = 379,
            RearSpeed = 389
        }
    }
    local service = {
        CustomSetFanSpeed  = function()
            return 1
        end
    }
    cooling_intf.cooling_fan_speed_to_pid(service, fan_devices)
end

function TestCoolingPidIntf:test_cooling_sensor_name_to_pid()
    local requirements = {
        {
            BaseId = 12,
            SensorName = "test",
        },
        {
            BaseId = 13,
            SensorName = "test2",
        }
    }
    local service = {
        CustomSetSensorName  = function()
            return 1
        end
    }
    cooling_intf.cooling_sensor_name_to_pid(service, requirements)
end

function TestCoolingPidIntf:test_get_fan_front_and_rear_speed()
    local fan = require "fan_object"
    local fan_device = {
        FanId = 1,
        FrontSpeed = 123,
        RearSpeed = 234
    }
    local fan_collection = fan.collection.fold
    fan.collection.fold = function(self, cb)
            cb(1, fan_device)
        end
    
    exception_policy.get_fan_front_and_rear_speed()
    fan.collection.fold = fan_collection
end
