-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_cooling_mgmt =  require "basic_cooling.cooling_mgmt"
local cooling_enum = require 'basic_cooling.define.cooling_enums'
local c_basic_cooling_config = require 'basic_cooling_config'

TestCoolingMgmt = {}

function  TestCoolingMgmt:test_update_maual_timeout()
    local obj = {CtrlMode = 'test'}
    local cur_sys_time = 10
    local pump_pck_t = {last_timeout = 5, expir_time = 10, real_timeout = 5}
    local ret = c_cooling_mgmt.update_manual_timeout(c_cooling_mgmt, true, 
        obj , cur_sys_time, pump_pck_t, 'pump')
    lu.assertEquals(obj.CtrlMode, cooling_enum.modes.Mixed)
    c_cooling_mgmt.air_config_instance = {
        set_ctrl_mode_persist = function()
            return
        end,
        get_ctrl_mode_persist_type = function()
            return cooling_enum.persist_type.Memory
        end
    }
    ret = c_cooling_mgmt.update_manual_timeout(c_cooling_mgmt, true, 
        obj , cur_sys_time, pump_pck_t, 'fan')
    lu.assertEquals(obj.CtrlMode, cooling_enum.modes.Mixed)
    ret = c_cooling_mgmt.update_manual_timeout(c_cooling_mgmt, false, 
        obj , cur_sys_time, pump_pck_t, 'fan')
    lu.assertEquals(obj.CtrlMode, cooling_enum.modes.Auto)    
end