-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local cooling_init_service = require 'basic_cooling.cooling_init_service'
local cooling_enums = require 'basic_cooling.define.cooling_enums'

TestCoolingInitService = {}

function TestCoolingInitService:test_init_fan_speed()
    local mock_data = {
        fans_config_instance = {
            get_obj = function()
                return true
            end,
            get_init_level_in_startup = function()
                return 100
            end
        },
        bmc_soc_data_keeping = {
            get_bmc_reset_type = function()
                return cooling_enums.bmc_reset_type.HARD_RESET
            end
        },
        fructl_data_keeping = {
            get_power_state = function()
                return "ON"
            end
        },
        set_fan_level = function(init_level)
            return
        end,
        data = {
            is_base_obj_added = true,
            cooling_init_service_is_end = false
        }
    }
    local ok = pcall(function()
        return cooling_init_service.init_fan_speed(mock_data)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(mock_data.data.cooling_init_service_is_end, true)
end