-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


loadfile(os.getenv('CONFIG_FILE'), 't', {package = package, os = os})()

local utils = require 'utils.core'
local logging = require 'mc.logging'
local current_file_dir = debug.getinfo(1).source:match('@?(.*)/')
utils.chdir(current_file_dir)
logging:setPrint(nil)
logging:setLevel(logging.INFO)

local lu = require('luaunit')

require 'test_fan_object'
require 'test_fan_type'
require 'test_fans'
require 'test_fan_group'
require 'test_pump_group'
require 'test_valve'
require 'test_zone_speed_adjust'
require 'test_pcie_card'
require 'test_hddbackplane'
require 'test_fan_service'
require 'test_cooling_rpc'
require 'test_threshold_sensor_data_keeping'
require 'test_cooling_mgmt'
require 'test_disk_temp'
require 'test_cooling_pid_intf'
require 'test_abnormal_fan'
require 'test_pump_object'
require 'test_fructl_data_keeping'
require 'test_cooling_init_service'
require 'test_thermal_subsystem'
require 'test_thermal_mgmt_app'

os.exit(lu.LuaUnit.run())
