-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local mdb = require 'mc.mdb'

local test_on_boot = {}

-- 获取必要的风扇代理对象
local function l_objs_init(bus)
    local ok
    local t_fan_1_obj, t_fan_2_obj, t_fan_3_obj, t_fan_4_obj
    local c_fan_1_obj, c_fan_2_obj, c_fan_3_obj, c_fan_4_obj
    local t_fan_1_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_1_0101'
    local t_fan_2_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_2_0101'
    local t_fan_3_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_3_0101'
    local t_fan_4_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_4_0101'
    local c_fan_1_path = '/bmc/kepler/Systems/1/CoolingFan/CoolingFan_1_1_0101'
    local c_fan_2_path = '/bmc/kepler/Systems/1/CoolingFan/CoolingFan_1_2_0101'
    local c_fan_3_path = '/bmc/kepler/Systems/1/CoolingFan/CoolingFan_1_3_0101'
    local c_fan_4_path = '/bmc/kepler/Systems/1/CoolingFan/CoolingFan_1_4_0101'

    ok, t_fan_1_obj = pcall(mdb.get_object, bus, t_fan_1_path, 'bmc.kepler.Systems.Fan')
    assert(ok)
    ok, t_fan_2_obj = pcall(mdb.get_object, bus, t_fan_2_path, 'bmc.kepler.Systems.Fan')
    assert(ok)
    ok, t_fan_3_obj = pcall(mdb.get_object, bus, t_fan_3_path, 'bmc.kepler.Systems.Fan')
    assert(ok)
    ok, t_fan_4_obj = pcall(mdb.get_object, bus, t_fan_4_path, 'bmc.kepler.Systems.Fan')
    assert(ok)

    ok, c_fan_1_obj = pcall(mdb.get_object, bus, c_fan_1_path, 'bmc.kepler.Systems.CoolingFan')
    assert(ok)
    ok, c_fan_2_obj = pcall(mdb.get_object, bus, c_fan_2_path, 'bmc.kepler.Systems.CoolingFan')
    assert(ok)
    ok, c_fan_3_obj = pcall(mdb.get_object, bus, c_fan_3_path, 'bmc.kepler.Systems.CoolingFan')
    assert(ok)
    ok, c_fan_4_obj = pcall(mdb.get_object, bus, c_fan_4_path, 'bmc.kepler.Systems.CoolingFan')
    assert(ok)

    return {
        ['t_fan_1'] = t_fan_1_obj,
        ['t_fan_2'] = t_fan_2_obj,
        ['t_fan_3'] = t_fan_3_obj,
        ['t_fan_4'] = t_fan_4_obj,
        ['c_fan_1'] = c_fan_1_obj,
        ['c_fan_2'] = c_fan_2_obj,
        ['c_fan_3'] = c_fan_3_obj,
        ['c_fan_4'] = c_fan_4_obj
    }
end

-- 平滑重启接口测试,覆盖非装备模式
local function test_on_reboot(bus, l_objs, ctx_new)
    local service = 'bmc.kepler.thermal_mgmt'
    local path = '/bmc/kepler/thermal_mgmt/MicroComponent'
    local intf = 'bmc.kepler.MicroComponent.Reboot'
    local full_fan_speed_percent = 100
    local full_fan_speed_pwm = 255
    local ok = bus:call(service, path, intf, 'Prepare', 'a{ss}', ctx_new)
    assert(ok, 0)
    ok = bus:call(service, path, intf, 'Action', 'a{ss}', ctx_new)
    assert(ok, 0)
    assert(l_objs.c_fan_1.Level == full_fan_speed_percent, 'c_fan_1 level: ' .. tostring(l_objs.c_fan_1.Level))
    assert(l_objs.c_fan_2.Level == full_fan_speed_percent, 'c_fan_2 level: ' .. tostring(l_objs.c_fan_2.Level))
    assert(l_objs.c_fan_3.Level == full_fan_speed_percent, 'c_fan_3 level: ' .. tostring(l_objs.c_fan_3.Level))
    assert(l_objs.c_fan_4.Level == full_fan_speed_percent, 'c_fan_4 level: ' .. tostring(l_objs.c_fan_4.Level))
    assert(l_objs.t_fan_1.ExpectedPWM == full_fan_speed_pwm, 'Actual: ' .. tostring(l_objs.t_fan_1.ExpectedPWM))
    assert(l_objs.t_fan_2.ExpectedPWM == full_fan_speed_pwm, 'Actual: ' .. tostring(l_objs.t_fan_2.ExpectedPWM))
    assert(l_objs.t_fan_3.ExpectedPWM == full_fan_speed_pwm, 'Actual: ' .. tostring(l_objs.t_fan_3.ExpectedPWM))
    assert(l_objs.t_fan_4.ExpectedPWM == full_fan_speed_pwm, 'Actual: ' .. tostring(l_objs.t_fan_4.ExpectedPWM))
end

function test_on_boot.main(bus, ctx_new)
    log:info('================ test on reboot start ================')
    local l_objs = l_objs_init(bus)
    test_on_reboot(bus, l_objs, ctx_new)
    log:info('================ test on reboot end ================')
end

return test_on_boot