-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local uart = {}

local PORT_CONNECTION_DEFAULT<const> = 0x76543210
local UART_CONNECTION_DEFAULT<const> = 0x76543210

function uart:new()
    return uart
end

function uart:close()
end

function uart:open_port(chan, baud)
end

function uart:read(chan, len)
    return string.rep('A', len)
end

function uart:select_read(chan, len)
    return string.rep('A', len)
end

function uart:write(chan, data)    
end

function uart:send_break(chan, duration)
end

function uart:uart_close(chan)
end

function uart:uart_connect_uart(src, dest)
end

function uart:uart_connect_port(src, dest)
end

function uart:port_connect_port(src, dest)
end

function uart:query_uart_connection()
    return UART_CONNECTION_DEFAULT
end

function uart:query_port_connection()
    return PORT_CONNECTION_DEFAULT
end

function uart:get_current_baud(index)
    return 115200
end

function uart:update_baud(uart_index, connect_uart)
end

function uart:update_baud_v2(chan, val)
end

function uart:update_oddeven(chan, even)
end

function uart:update_data_bits(chan, bits)    
end

function uart:update_stop_bits(chan, stop)    
end

return uart