-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'

local efuse = {}

local write_count = 0

local efuse_write_buffer = '\z
\x0F\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x01\z
\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x01\x00\z
\x00\x00\x02\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\z
\x00\x12\x00\x00\x00\x01\x00\x00\x00\x03\x00\x00\x00\z
\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x0C\z
\x00\x00\x00\x01\x00\x00\x00\x0F\x00\x00\x00\x07\x00\z
\x00\x00\x01\x00\x00\x00\x0F\x00\x00\x00\x1A\x00\x00\z
\x00\x01\x00\x00\x00\x01\x00\x00\x00\x0F\x00\x00\x00\z
\x01\x00\x00\x00\x0D\x00\x00\x00\x09\x00\x00\x00\x08\z
\x00\x00\x00\xF4\xEB\x9C\x4D\x2E\xAA\xD1\x69\x8C\x64\z
\x73\x9F\xF8\xDE\x4F\x4F\x25\x35\x83\x4B\xE9\x2A\xD7\z
\x29\x52\x30\xB0\x5F\x70\x4B\x6E\xAB\x0A\x00\x00\x00\z
\x01\x00\x00\x00\x1B\x00\x00\x00\x0D\x00\x00\x00\x01\z
\x00\x00\x00\x0D\x00\x00\x00\x06\x00\x00\x00\x01\x00\z
\x00\x00\x5A\x5A\x5A\x5A\x1C\x00\x00\x00\x01\x00\x00\z
\x00\x01\x00\x00\x00\x13\x00\x00\x00\x01\x00\x00\x00\z
\x01\x00\x00\x00'

local efuse_write_field_id = {0, 1, 2, 18, 4, 12, 7, 26, 15, 9, 10, 13, 6, 28, 19}

local efuse_write_data = {
    [0] = '\x01\x00\x00\x00',
    [1] = '\x01\x00\x00\x00',
    [2] = '\x01\x00\x00\x00',
    [18] = '\x03\x00\x00\x00',
    [4] = '\x01\x00\x00\x00',
    [12] = '\x0F\x00\x00\x00',
    [7] = '\x0F\x00\x00\x00',
    [26] = '\x01\x00\x00\x00',
    [15] = '\x0D\x00\x00\x00',
    [9] = '\xF4\xEB\x9C\x4D\x2E\xAA\xD1\x69\x8C\x64\x73\x9F\xF8\xDE' ..
        '\x4F\x4F\x25\x35\x83\x4B\xE9\x2A\xD7\x29\x52\x30\xB0\x5F\x70\x4B\x6E\xAB',
    [10] = '\x1B\x00\x00\x00',
    [13] = '\x0D\x00\x00\x00',
    [6] = '\x5A\x5A\x5A\x5A',
    [28] = '\x01\x00\x00\x00',
    [19] = '\x01\x00\x00\x00'
}

function efuse:new()
    return efuse
end

function efuse:close()
end

function efuse:get_domain_cnt()
    return 30
end

function efuse:write(field_id, data)
    write_count = write_count + 1
    lu.assertEquals(field_id, efuse_write_field_id[write_count])
    lu.assertEquals(data, efuse_write_data[field_id])
end

function efuse:wr_buf_validate(buffer, total_buf_len)
    lu.assertEquals(total_buf_len, 212)
    lu.assertEquals(buffer, efuse_write_buffer)
end

return efuse