-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local log = require 'mc.logging'
local initiator = require 'mc.initiator'
local client = require 'thermal_mgmt.client'

local thermal_mgmt_utils = class()

function thermal_mgmt_utils.operation_log(ctx, fmt, ...)
    local intf = (ctx and ctx.Interface) and ctx.Interface or 'N/A'
    local user_name = (ctx and ctx.UserName) and ctx.UserName or 'N/A'
    local client_addr = (ctx and ctx.ClientAddr)  and ctx.ClientAddr or '127.0.0.1'
    log:operation(initiator.new(intf, user_name, client_addr), 'thermal_mgmt', fmt, ...)
end

function thermal_mgmt_utils:get_chassis_type()
    local chassis_type = nil
    client:ForeachChassisObjects(function (obj)
        chassis_type = obj['ChassisType']
    end)
    return chassis_type
end

return thermal_mgmt_utils