-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local c_object = require 'mc.orm.object'
local log = require 'mc.logging'
local pump_group_object = c_object('PumpGroup')
local props = require 'basic_cooling.define.cooling_properties'
local pumps_config = require 'basic_cooling.cooling_config.pumps_config'
local custom_msg = require 'messages.custom'
local LEVEL_RANGE_LENGTH<const> = 2

function pump_group_object:property_before_change_callback(name, value, level_range, sender)
    if name == props.EXPECTED_SPEED_PERCENT then
        if not level_range or #level_range ~= LEVEL_RANGE_LENGTH then
            error(custom_msg.PropertyValueLengthOutOfRange(level_range, '%LevelPercentRange',
                LEVEL_RANGE_LENGTH, LEVEL_RANGE_LENGTH))
        end
        if value < level_range[1] or value > level_range[2] then
            error(custom_msg.PropertyValueOutOfRange(value, '%ExpectedSpeedPercent'))
        end
    end
    return true
end

function pump_group_object:init()
    self:connect_signal(self.on_add_object_complete, function()
        log:notice('on_add_object_complete group id: %d, pump_slot: %s', self.Id, table.concat(self.PumpSlots, ' '))
        local level_range = pumps_config.get_instance():get_level_range()
        self:get_mdb_object('bmc.kepler.Chassis.PumpGroup').property_before_change:on(function(name, value, sender)
            return self:property_before_change_callback(name, value, level_range, sender)
        end)
    end)
    pump_group_object.super.init(self)
end

return pump_group_object