-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local client = require 'thermal_mgmt.client'
local enums = require 'basic_cooling.define.cooling_enums'
local props = require 'basic_cooling.define.cooling_properties'
local base = require 'basic_cooling.data_keeping.base'
local singleton = require 'mc.singleton'
local thermal_mgmt_utils = require 'thermal_mgmt_utils'
local log = require 'mc.logging'
local fructl_data = class(base)

function fructl_data:ctor(bus)
    self.obj_name = 'FruCtrl'
    self.bus = bus
    self.paths_table = {
        '/bmc/kepler/Systems/:SystemId/FruCtrl/:Id'
    }
    self.interfaces_table = {
        ['bmc.kepler.Systems.FruCtrl'] = {
            [enums.data_keeping_config.FOREACH_FUNC] = client.ForeachFruCtrlObjects,
            [enums.data_keeping_config.PROPERTIES] = {
                [props.FRUCTL.POWER_STATE] = enums.data_keeping_log.LOG
            }
        }
    }
    self.power_state = "ON"
    self.chassis_type = nil
end

function fructl_data:init()
    self.super.init(self)
end

function fructl_data:get_power_state()
    if not self.chassis_type then
        self.chassis_type = thermal_mgmt_utils:get_chassis_type()
        log:notice('The obtained chassis type is %s', self.chassis_type)
    end
    if self.chassis_type == enums.chassis_type.RACK_MGMT then
        return "ON"
    end
    return self.power_state
end

function fructl_data:action_after_property_changed(path, interface, prop, value)
    log:notice('Power state changes from %s to %s', self.power_state, value)
    self.power_state = value
end

return singleton(fructl_data)