-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local singleton = require 'mc.singleton'
local class = require 'mc.class'

local fructl_data_keeping = require 'basic_cooling.data_keeping.fructl_data_keeping'
local disks_data_keeping = require 'basic_cooling.data_keeping.disks_data_keeping'
local cards_data_keeping = require 'basic_cooling.data_keeping.cards_data_keeping'
local hdd_backplane_data_keeping = require 'basic_cooling.data_keeping.hddbackplane_data_keeping'
local bmc_soc_data_keeping = require 'basic_cooling.data_keeping.bmc_soc_data_keeping'
local manufacture = require 'basic_cooling.data_keeping.manufacture'
local fan_board_data_keeping = require 'basic_cooling.data_keeping.fan_board_data_keeping'
local threshold_sensor_data_keeping = require 'basic_cooling.data_keeping.threshold_sensor_data_keeping'

local external_data_keeping = class()

function external_data_keeping:ctor(bus)
    self.bus = bus
    fructl_data_keeping.destroy()
    disks_data_keeping.destroy()
    cards_data_keeping.destroy()
    hdd_backplane_data_keeping.destroy()
    bmc_soc_data_keeping.destroy()
    manufacture.destroy()
    fan_board_data_keeping.destroy()
    threshold_sensor_data_keeping.destroy()
    self.data_keeping_objs = {}
    self.objs = {}
end

function external_data_keeping:init()
    self.data_keeping_objs.fructl_data_keeping = fructl_data_keeping.new(self.bus)
    self.data_keeping_objs.disks_data_keeping = disks_data_keeping.new(self.bus)
    self.data_keeping_objs.cards_data = cards_data_keeping.new(self.bus)
    self.data_keeping_objs.hdd_backplane_data = hdd_backplane_data_keeping.new(self.bus)
    self.data_keeping_objs.bmc_soc_data_keeping = bmc_soc_data_keeping.new(self.bus)
    self.data_keeping_objs.manufacture = manufacture.new(self.bus)
    self.data_keeping_objs.fan_board_data_keeping = fan_board_data_keeping.new(self.bus)
    self.data_keeping_objs.threshold_sensor_data_keeping = threshold_sensor_data_keeping.new(self.bus)
    skynet.fork_loop({ count = 0 }, function()
        self:start_refresh_objs_info()
    end)
end

function external_data_keeping:start_refresh_objs_info()
    while true do
        for _, data_keeping_obj in pairs(self.data_keeping_objs) do
            if data_keeping_obj.refresh_objs_info then
                pcall(data_keeping_obj.refresh_objs_info, data_keeping_obj)
            end
        end
        -- 每隔20分钟强制刷新一下属性
        skynet.sleep(120000)
    end
end

return singleton(external_data_keeping)
