-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ThresholdSensorDisplay = {}

ThresholdSensorDisplay.interface = mdb.register_interface('bmc.kepler.Systems.ThresholdSensorDisplay', {
    UpperNonrecoverableDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    UpperCriticalDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    UpperNoncriticalDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    LowerNonrecoverableDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    LowerNoncriticalDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    LowerCriticalDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    PositiveHysteresisDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    NegativeHysteresisDisplay = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ReadingDisplay = {'s', {['volatile'] = true, ['emitsChangedSignal'] = 'false'}, false, nil},
    UnitDisplay = {'s', {['emitsChangedSignal'] = 'const'}, true, nil},
    Status = {'s', {['emitsChangedSignal'] = 'true'}, true, nil},
    Health = {'s', nil, true, nil},
    AssertStatus = {'q', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {}, {})

return ThresholdSensorDisplay
