-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ThermalSubsystemPumps = {}

---@class ThermalSubsystemPumps.StandardPumpsResourceEnabled
---@field StandardPumpsResourceEnabled boolean
local TStandardPumpsResourceEnabled = {}
TStandardPumpsResourceEnabled.__index = TStandardPumpsResourceEnabled
TStandardPumpsResourceEnabled.group = {}

local function TStandardPumpsResourceEnabled_from_obj(obj)
    return setmetatable(obj, TStandardPumpsResourceEnabled)
end

function TStandardPumpsResourceEnabled.new(StandardPumpsResourceEnabled)
    return TStandardPumpsResourceEnabled_from_obj({
        StandardPumpsResourceEnabled = StandardPumpsResourceEnabled == nil and true or StandardPumpsResourceEnabled
    })
end
---@param obj ThermalSubsystemPumps.StandardPumpsResourceEnabled
function TStandardPumpsResourceEnabled:init_from_obj(obj)
    self.StandardPumpsResourceEnabled = obj.StandardPumpsResourceEnabled == nil and true or
                                            obj.StandardPumpsResourceEnabled
end

function TStandardPumpsResourceEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStandardPumpsResourceEnabled.group)
end

TStandardPumpsResourceEnabled.from_obj = TStandardPumpsResourceEnabled_from_obj

TStandardPumpsResourceEnabled.proto_property = {'StandardPumpsResourceEnabled'}

TStandardPumpsResourceEnabled.default = {false}

TStandardPumpsResourceEnabled.struct = {{name = 'StandardPumpsResourceEnabled', is_array = false, struct = nil}}

function TStandardPumpsResourceEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StandardPumpsResourceEnabled', self.StandardPumpsResourceEnabled, 'bool', true, errs,
        need_convert)

    TStandardPumpsResourceEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStandardPumpsResourceEnabled.proto_property, errs, need_convert)
    return self
end

function TStandardPumpsResourceEnabled:unpack(_)
    return self.StandardPumpsResourceEnabled
end

ThermalSubsystemPumps.StandardPumpsResourceEnabled = TStandardPumpsResourceEnabled

ThermalSubsystemPumps.interface = mdb.register_interface('bmc.kepler.Chassis.ThermalSubsystem.Pumps',
    {StandardPumpsResourceEnabled = {'b', {}, true, true}}, {}, {})

return ThermalSubsystemPumps
