-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SOC = {}

SOC.interface = mdb.register_interface('bmc.kepler.Managers.SOC', {
    BlackBoxEnabled = {'b', nil, false, nil},
    PCIeControllerEnabled = {'b', nil, false, nil},
    Temperature = {'q', nil, true, nil},
    TemperatureThreshold = {'q', nil, true, nil},
    Name = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Version = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Designator = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    DIEID = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ResetType = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    DDRSelfTestResult = {'y', nil, true, nil},
    DDRSingleBitECCStatistics = {'u', {['emitsChangedSignal'] = 'false'}, true, nil},
    DDRMultiBitECCStatistics = {'u', {['emitsChangedSignal'] = 'false'}, true, nil},
    StartupDuration = {'q', {['emitsChangedSignal'] = 'false'}, true, nil},
    LastResetTime = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    BootStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, nil}
}, {}, {})

return SOC
