-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PumpGroup = {}

---@class PumpGroup.ExpectedSpeedPercent
---@field ExpectedSpeedPercent number
local TExpectedSpeedPercent = {}
TExpectedSpeedPercent.__index = TExpectedSpeedPercent
TExpectedSpeedPercent.group = {}

local function TExpectedSpeedPercent_from_obj(obj)
    return setmetatable(obj, TExpectedSpeedPercent)
end

function TExpectedSpeedPercent.new(ExpectedSpeedPercent)
    return TExpectedSpeedPercent_from_obj({ExpectedSpeedPercent = ExpectedSpeedPercent})
end
---@param obj PumpGroup.ExpectedSpeedPercent
function TExpectedSpeedPercent:init_from_obj(obj)
    self.ExpectedSpeedPercent = obj.ExpectedSpeedPercent
end

function TExpectedSpeedPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpectedSpeedPercent.group)
end

TExpectedSpeedPercent.from_obj = TExpectedSpeedPercent_from_obj

TExpectedSpeedPercent.proto_property = {'ExpectedSpeedPercent'}

TExpectedSpeedPercent.default = {0}

TExpectedSpeedPercent.struct = {{name = 'ExpectedSpeedPercent', is_array = false, struct = nil}}

function TExpectedSpeedPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpectedSpeedPercent', self.ExpectedSpeedPercent, 'double', false, errs, need_convert)

    TExpectedSpeedPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpectedSpeedPercent.proto_property, errs, need_convert)
    return self
end

function TExpectedSpeedPercent:unpack(_)
    return self.ExpectedSpeedPercent
end

PumpGroup.ExpectedSpeedPercent = TExpectedSpeedPercent

---@class PumpGroup.SpeedPercent
---@field SpeedPercent number
local TSpeedPercent = {}
TSpeedPercent.__index = TSpeedPercent
TSpeedPercent.group = {}

local function TSpeedPercent_from_obj(obj)
    return setmetatable(obj, TSpeedPercent)
end

function TSpeedPercent.new(SpeedPercent)
    return TSpeedPercent_from_obj({SpeedPercent = SpeedPercent})
end
---@param obj PumpGroup.SpeedPercent
function TSpeedPercent:init_from_obj(obj)
    self.SpeedPercent = obj.SpeedPercent
end

function TSpeedPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedPercent.group)
end

TSpeedPercent.from_obj = TSpeedPercent_from_obj

TSpeedPercent.proto_property = {'SpeedPercent'}

TSpeedPercent.default = {0}

TSpeedPercent.struct = {{name = 'SpeedPercent', is_array = false, struct = nil}}

function TSpeedPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedPercent', self.SpeedPercent, 'double', true, errs, need_convert)

    TSpeedPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedPercent.proto_property, errs, need_convert)
    return self
end

function TSpeedPercent:unpack(_)
    return self.SpeedPercent
end

PumpGroup.SpeedPercent = TSpeedPercent

---@class PumpGroup.PumpSlots
---@field PumpSlots integer[]
local TPumpSlots = {}
TPumpSlots.__index = TPumpSlots
TPumpSlots.group = {}

local function TPumpSlots_from_obj(obj)
    return setmetatable(obj, TPumpSlots)
end

function TPumpSlots.new(PumpSlots)
    return TPumpSlots_from_obj({PumpSlots = PumpSlots})
end
---@param obj PumpGroup.PumpSlots
function TPumpSlots:init_from_obj(obj)
    self.PumpSlots = obj.PumpSlots
end

function TPumpSlots:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPumpSlots.group)
end

TPumpSlots.from_obj = TPumpSlots_from_obj

TPumpSlots.proto_property = {'PumpSlots'}

TPumpSlots.default = {{}}

TPumpSlots.struct = {{name = 'PumpSlots', is_array = true, struct = nil}}

function TPumpSlots:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PumpSlots', self.PumpSlots, 'uint8', true, errs, need_convert)

    TPumpSlots:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPumpSlots.proto_property, errs, need_convert)
    return self
end

function TPumpSlots:unpack(_)
    return self.PumpSlots
end

PumpGroup.PumpSlots = TPumpSlots

---@class PumpGroup.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj PumpGroup.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

PumpGroup.Id = TId

PumpGroup.interface = mdb.register_interface('bmc.kepler.Chassis.PumpGroup', {
    Id = {'y', {'CONST'}, true, nil},
    PumpSlots = {'ay', {}, true, nil},
    SpeedPercent = {'d', {}, true, nil},
    ExpectedSpeedPercent = {'d', {'EMIT_CHANGE'}, false, nil}
}, {}, {})

return PumpGroup
