-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Pump = {}

---@class Pump.PumpType
---@field PumpType string
local TPumpType = {}
TPumpType.__index = TPumpType
TPumpType.group = {}

local function TPumpType_from_obj(obj)
    return setmetatable(obj, TPumpType)
end

function TPumpType.new(PumpType)
    return TPumpType_from_obj({PumpType = PumpType})
end
---@param obj Pump.PumpType
function TPumpType:init_from_obj(obj)
    self.PumpType = obj.PumpType
end

function TPumpType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPumpType.group)
end

TPumpType.from_obj = TPumpType_from_obj

TPumpType.proto_property = {'PumpType'}

TPumpType.default = {''}

TPumpType.struct = {{name = 'PumpType', is_array = false, struct = nil}}

function TPumpType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PumpType', self.PumpType, 'string', true, errs, need_convert)

    if self.PumpType ~= nil then
        validate.Enum(prefix .. 'PumpType', self.PumpType, '', {'Compressor', 'Liquid', ''}, errs, need_convert)
    end

    TPumpType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPumpType.proto_property, errs, need_convert)
    return self
end

function TPumpType:unpack(_)
    return self.PumpType
end

Pump.PumpType = TPumpType

---@class Pump.LocationReference
---@field LocationReference string
local TLocationReference = {}
TLocationReference.__index = TLocationReference
TLocationReference.group = {}

local function TLocationReference_from_obj(obj)
    return setmetatable(obj, TLocationReference)
end

function TLocationReference.new(LocationReference)
    return TLocationReference_from_obj({LocationReference = LocationReference})
end
---@param obj Pump.LocationReference
function TLocationReference:init_from_obj(obj)
    self.LocationReference = obj.LocationReference
end

function TLocationReference:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationReference.group)
end

TLocationReference.from_obj = TLocationReference_from_obj

TLocationReference.proto_property = {'LocationReference'}

TLocationReference.default = {''}

TLocationReference.struct = {{name = 'LocationReference', is_array = false, struct = nil}}

function TLocationReference:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationReference', self.LocationReference, 'string', true, errs, need_convert)

    if self.LocationReference ~= nil then
        validate.Enum(prefix .. 'LocationReference', self.LocationReference, '',
            {'Bottom', 'Front', 'Left', 'Middle', 'Rear', 'Right', 'Top', ''}, errs, need_convert)
    end

    TLocationReference:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationReference.proto_property, errs, need_convert)
    return self
end

function TLocationReference:unpack(_)
    return self.LocationReference
end

Pump.LocationReference = TLocationReference

---@class Pump.ServiceLabel
---@field ServiceLabel string
local TServiceLabel = {}
TServiceLabel.__index = TServiceLabel
TServiceLabel.group = {}

local function TServiceLabel_from_obj(obj)
    return setmetatable(obj, TServiceLabel)
end

function TServiceLabel.new(ServiceLabel)
    return TServiceLabel_from_obj({ServiceLabel = ServiceLabel})
end
---@param obj Pump.ServiceLabel
function TServiceLabel:init_from_obj(obj)
    self.ServiceLabel = obj.ServiceLabel
end

function TServiceLabel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TServiceLabel.group)
end

TServiceLabel.from_obj = TServiceLabel_from_obj

TServiceLabel.proto_property = {'ServiceLabel'}

TServiceLabel.default = {''}

TServiceLabel.struct = {{name = 'ServiceLabel', is_array = false, struct = nil}}

function TServiceLabel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ServiceLabel', self.ServiceLabel, 'string', true, errs, need_convert)

    TServiceLabel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TServiceLabel.proto_property, errs, need_convert)
    return self
end

function TServiceLabel:unpack(_)
    return self.ServiceLabel
end

Pump.ServiceLabel = TServiceLabel

---@class Pump.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj Pump.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

Pump.SerialNumber = TSerialNumber

---@class Pump.ProductionDate
---@field ProductionDate string
local TProductionDate = {}
TProductionDate.__index = TProductionDate
TProductionDate.group = {}

local function TProductionDate_from_obj(obj)
    return setmetatable(obj, TProductionDate)
end

function TProductionDate.new(ProductionDate)
    return TProductionDate_from_obj({ProductionDate = ProductionDate})
end
---@param obj Pump.ProductionDate
function TProductionDate:init_from_obj(obj)
    self.ProductionDate = obj.ProductionDate
end

function TProductionDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductionDate.group)
end

TProductionDate.from_obj = TProductionDate_from_obj

TProductionDate.proto_property = {'ProductionDate'}

TProductionDate.default = {''}

TProductionDate.struct = {{name = 'ProductionDate', is_array = false, struct = nil}}

function TProductionDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductionDate', self.ProductionDate, 'string', true, errs, need_convert)

    TProductionDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductionDate.proto_property, errs, need_convert)
    return self
end

function TProductionDate:unpack(_)
    return self.ProductionDate
end

Pump.ProductionDate = TProductionDate

---@class Pump.PhysicalContext
---@field PhysicalContext string
local TPhysicalContext = {}
TPhysicalContext.__index = TPhysicalContext
TPhysicalContext.group = {}

local function TPhysicalContext_from_obj(obj)
    return setmetatable(obj, TPhysicalContext)
end

function TPhysicalContext.new(PhysicalContext)
    return TPhysicalContext_from_obj({PhysicalContext = PhysicalContext})
end
---@param obj Pump.PhysicalContext
function TPhysicalContext:init_from_obj(obj)
    self.PhysicalContext = obj.PhysicalContext
end

function TPhysicalContext:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalContext.group)
end

TPhysicalContext.from_obj = TPhysicalContext_from_obj

TPhysicalContext.proto_property = {'PhysicalContext'}

TPhysicalContext.default = {''}

TPhysicalContext.struct = {{name = 'PhysicalContext', is_array = false, struct = nil}}

function TPhysicalContext:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalContext', self.PhysicalContext, 'string', true, errs, need_convert)

    if self.PhysicalContext ~= nil then
        validate.Enum(prefix .. 'PhysicalContext', self.PhysicalContext, '',
            {'CPU', 'CPUSubsystem', 'Chassis', 'GPU', 'GPUSubsystem', ''}, errs, need_convert)
    end

    TPhysicalContext:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalContext.proto_property, errs, need_convert)
    return self
end

function TPhysicalContext:unpack(_)
    return self.PhysicalContext
end

Pump.PhysicalContext = TPhysicalContext

---@class Pump.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj Pump.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

Pump.Manufacturer = TManufacturer

---@class Pump.Status
---@field Status integer
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status})
end
---@param obj Pump.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {0}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

Pump.Status = TStatus

---@class Pump.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj Pump.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

Pump.Presence = TPresence

---@class Pump.MaxSpeedRPM
---@field MaxSpeedRPM integer
local TMaxSpeedRPM = {}
TMaxSpeedRPM.__index = TMaxSpeedRPM
TMaxSpeedRPM.group = {}

local function TMaxSpeedRPM_from_obj(obj)
    return setmetatable(obj, TMaxSpeedRPM)
end

function TMaxSpeedRPM.new(MaxSpeedRPM)
    return TMaxSpeedRPM_from_obj({MaxSpeedRPM = MaxSpeedRPM})
end
---@param obj Pump.MaxSpeedRPM
function TMaxSpeedRPM:init_from_obj(obj)
    self.MaxSpeedRPM = obj.MaxSpeedRPM
end

function TMaxSpeedRPM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxSpeedRPM.group)
end

TMaxSpeedRPM.from_obj = TMaxSpeedRPM_from_obj

TMaxSpeedRPM.proto_property = {'MaxSpeedRPM'}

TMaxSpeedRPM.default = {0}

TMaxSpeedRPM.struct = {{name = 'MaxSpeedRPM', is_array = false, struct = nil}}

function TMaxSpeedRPM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxSpeedRPM', self.MaxSpeedRPM, 'uint32', true, errs, need_convert)

    TMaxSpeedRPM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxSpeedRPM.proto_property, errs, need_convert)
    return self
end

function TMaxSpeedRPM:unpack(_)
    return self.MaxSpeedRPM
end

Pump.MaxSpeedRPM = TMaxSpeedRPM

---@class Pump.SpeedRPM
---@field SpeedRPM integer
local TSpeedRPM = {}
TSpeedRPM.__index = TSpeedRPM
TSpeedRPM.group = {}

local function TSpeedRPM_from_obj(obj)
    return setmetatable(obj, TSpeedRPM)
end

function TSpeedRPM.new(SpeedRPM)
    return TSpeedRPM_from_obj({SpeedRPM = SpeedRPM})
end
---@param obj Pump.SpeedRPM
function TSpeedRPM:init_from_obj(obj)
    self.SpeedRPM = obj.SpeedRPM
end

function TSpeedRPM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedRPM.group)
end

TSpeedRPM.from_obj = TSpeedRPM_from_obj

TSpeedRPM.proto_property = {'SpeedRPM'}

TSpeedRPM.default = {0}

TSpeedRPM.struct = {{name = 'SpeedRPM', is_array = false, struct = nil}}

function TSpeedRPM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedRPM', self.SpeedRPM, 'uint16', true, errs, need_convert)

    TSpeedRPM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedRPM.proto_property, errs, need_convert)
    return self
end

function TSpeedRPM:unpack(_)
    return self.SpeedRPM
end

Pump.SpeedRPM = TSpeedRPM

---@class Pump.MaxSupportedPWM
---@field MaxSupportedPWM integer
local TMaxSupportedPWM = {}
TMaxSupportedPWM.__index = TMaxSupportedPWM
TMaxSupportedPWM.group = {}

local function TMaxSupportedPWM_from_obj(obj)
    return setmetatable(obj, TMaxSupportedPWM)
end

function TMaxSupportedPWM.new(MaxSupportedPWM)
    return TMaxSupportedPWM_from_obj({MaxSupportedPWM = MaxSupportedPWM})
end
---@param obj Pump.MaxSupportedPWM
function TMaxSupportedPWM:init_from_obj(obj)
    self.MaxSupportedPWM = obj.MaxSupportedPWM
end

function TMaxSupportedPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxSupportedPWM.group)
end

TMaxSupportedPWM.from_obj = TMaxSupportedPWM_from_obj

TMaxSupportedPWM.proto_property = {'MaxSupportedPWM'}

TMaxSupportedPWM.default = {0}

TMaxSupportedPWM.struct = {{name = 'MaxSupportedPWM', is_array = false, struct = nil}}

function TMaxSupportedPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxSupportedPWM', self.MaxSupportedPWM, 'uint32', true, errs, need_convert)

    TMaxSupportedPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxSupportedPWM.proto_property, errs, need_convert)
    return self
end

function TMaxSupportedPWM:unpack(_)
    return self.MaxSupportedPWM
end

Pump.MaxSupportedPWM = TMaxSupportedPWM

---@class Pump.ActualPWM
---@field ActualPWM number
local TActualPWM = {}
TActualPWM.__index = TActualPWM
TActualPWM.group = {}

local function TActualPWM_from_obj(obj)
    return setmetatable(obj, TActualPWM)
end

function TActualPWM.new(ActualPWM)
    return TActualPWM_from_obj({ActualPWM = ActualPWM})
end
---@param obj Pump.ActualPWM
function TActualPWM:init_from_obj(obj)
    self.ActualPWM = obj.ActualPWM
end

function TActualPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActualPWM.group)
end

TActualPWM.from_obj = TActualPWM_from_obj

TActualPWM.proto_property = {'ActualPWM'}

TActualPWM.default = {0}

TActualPWM.struct = {{name = 'ActualPWM', is_array = false, struct = nil}}

function TActualPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActualPWM', self.ActualPWM, 'double', true, errs, need_convert)

    TActualPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActualPWM.proto_property, errs, need_convert)
    return self
end

function TActualPWM:unpack(_)
    return self.ActualPWM
end

Pump.ActualPWM = TActualPWM

---@class Pump.ExpectedPWM
---@field ExpectedPWM number
local TExpectedPWM = {}
TExpectedPWM.__index = TExpectedPWM
TExpectedPWM.group = {}

local function TExpectedPWM_from_obj(obj)
    return setmetatable(obj, TExpectedPWM)
end

function TExpectedPWM.new(ExpectedPWM)
    return TExpectedPWM_from_obj({ExpectedPWM = ExpectedPWM})
end
---@param obj Pump.ExpectedPWM
function TExpectedPWM:init_from_obj(obj)
    self.ExpectedPWM = obj.ExpectedPWM
end

function TExpectedPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpectedPWM.group)
end

TExpectedPWM.from_obj = TExpectedPWM_from_obj

TExpectedPWM.proto_property = {'ExpectedPWM'}

TExpectedPWM.default = {0}

TExpectedPWM.struct = {{name = 'ExpectedPWM', is_array = false, struct = nil}}

function TExpectedPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpectedPWM', self.ExpectedPWM, 'double', true, errs, need_convert)

    TExpectedPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpectedPWM.proto_property, errs, need_convert)
    return self
end

function TExpectedPWM:unpack(_)
    return self.ExpectedPWM
end

Pump.ExpectedPWM = TExpectedPWM

---@class Pump.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Pump.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

Pump.PartNumber = TPartNumber

---@class Pump.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj Pump.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

Pump.Model = TModel

---@class Pump.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj Pump.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', true, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

Pump.Slot = TSlot

---@class Pump.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Pump.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint16', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Pump.Id = TId

Pump.interface = mdb.register_interface('bmc.kepler.Systems.Pump', {
    Id = {'q', {'CONST'}, true, nil},
    Slot = {'y', {'CONST'}, true, nil},
    Model = {'s', {'CONST'}, true, nil},
    PartNumber = {'s', {}, true, nil},
    ExpectedPWM = {'d', {}, true, nil},
    ActualPWM = {'d', {}, true, nil},
    MaxSupportedPWM = {'u', {}, true, nil},
    SpeedRPM = {'q', {'VOLATILE'}, true, nil},
    MaxSpeedRPM = {'u', {}, true, nil},
    Presence = {'y', nil, true, nil},
    Status = {'y', nil, true, nil},
    Manufacturer = {'s', {}, true, nil},
    PhysicalContext = {'s', {}, true, nil},
    ProductionDate = {'s', {}, true, nil},
    SerialNumber = {'s', {}, true, nil},
    ServiceLabel = {'s', {}, true, nil},
    LocationReference = {'s', {}, true, nil},
    PumpType = {'s', {}, true, nil}
}, {}, {})

return Pump
