-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Metrics = {}

---@class Metrics.TotalRuntimeHeatingTimeSeconds
---@field TotalRuntimeHeatingTimeSeconds integer
local TTotalRuntimeHeatingTimeSeconds = {}
TTotalRuntimeHeatingTimeSeconds.__index = TTotalRuntimeHeatingTimeSeconds
TTotalRuntimeHeatingTimeSeconds.group = {}

local function TTotalRuntimeHeatingTimeSeconds_from_obj(obj)
    return setmetatable(obj, TTotalRuntimeHeatingTimeSeconds)
end

function TTotalRuntimeHeatingTimeSeconds.new(TotalRuntimeHeatingTimeSeconds)
    return TTotalRuntimeHeatingTimeSeconds_from_obj({TotalRuntimeHeatingTimeSeconds = TotalRuntimeHeatingTimeSeconds})
end
---@param obj Metrics.TotalRuntimeHeatingTimeSeconds
function TTotalRuntimeHeatingTimeSeconds:init_from_obj(obj)
    self.TotalRuntimeHeatingTimeSeconds = obj.TotalRuntimeHeatingTimeSeconds
end

function TTotalRuntimeHeatingTimeSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalRuntimeHeatingTimeSeconds.group)
end

TTotalRuntimeHeatingTimeSeconds.from_obj = TTotalRuntimeHeatingTimeSeconds_from_obj

TTotalRuntimeHeatingTimeSeconds.proto_property = {'TotalRuntimeHeatingTimeSeconds'}

TTotalRuntimeHeatingTimeSeconds.default = {0}

TTotalRuntimeHeatingTimeSeconds.struct = {{name = 'TotalRuntimeHeatingTimeSeconds', is_array = false, struct = nil}}

function TTotalRuntimeHeatingTimeSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalRuntimeHeatingTimeSeconds', self.TotalRuntimeHeatingTimeSeconds, 'uint32', false,
        errs, need_convert)

    TTotalRuntimeHeatingTimeSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalRuntimeHeatingTimeSeconds.proto_property, errs, need_convert)
    return self
end

function TTotalRuntimeHeatingTimeSeconds:unpack(_)
    return self.TotalRuntimeHeatingTimeSeconds
end

Metrics.TotalRuntimeHeatingTimeSeconds = TTotalRuntimeHeatingTimeSeconds

---@class Metrics.TotalPrePowerOnHeatingTimeSeconds
---@field TotalPrePowerOnHeatingTimeSeconds integer
local TTotalPrePowerOnHeatingTimeSeconds = {}
TTotalPrePowerOnHeatingTimeSeconds.__index = TTotalPrePowerOnHeatingTimeSeconds
TTotalPrePowerOnHeatingTimeSeconds.group = {}

local function TTotalPrePowerOnHeatingTimeSeconds_from_obj(obj)
    return setmetatable(obj, TTotalPrePowerOnHeatingTimeSeconds)
end

function TTotalPrePowerOnHeatingTimeSeconds.new(TotalPrePowerOnHeatingTimeSeconds)
    return TTotalPrePowerOnHeatingTimeSeconds_from_obj({
        TotalPrePowerOnHeatingTimeSeconds = TotalPrePowerOnHeatingTimeSeconds
    })
end
---@param obj Metrics.TotalPrePowerOnHeatingTimeSeconds
function TTotalPrePowerOnHeatingTimeSeconds:init_from_obj(obj)
    self.TotalPrePowerOnHeatingTimeSeconds = obj.TotalPrePowerOnHeatingTimeSeconds
end

function TTotalPrePowerOnHeatingTimeSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalPrePowerOnHeatingTimeSeconds.group)
end

TTotalPrePowerOnHeatingTimeSeconds.from_obj = TTotalPrePowerOnHeatingTimeSeconds_from_obj

TTotalPrePowerOnHeatingTimeSeconds.proto_property = {'TotalPrePowerOnHeatingTimeSeconds'}

TTotalPrePowerOnHeatingTimeSeconds.default = {0}

TTotalPrePowerOnHeatingTimeSeconds.struct = {
    {name = 'TotalPrePowerOnHeatingTimeSeconds', is_array = false, struct = nil}
}

function TTotalPrePowerOnHeatingTimeSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalPrePowerOnHeatingTimeSeconds', self.TotalPrePowerOnHeatingTimeSeconds, 'uint32',
        false, errs, need_convert)

    TTotalPrePowerOnHeatingTimeSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalPrePowerOnHeatingTimeSeconds.proto_property, errs, need_convert)
    return self
end

function TTotalPrePowerOnHeatingTimeSeconds:unpack(_)
    return self.TotalPrePowerOnHeatingTimeSeconds
end

Metrics.TotalPrePowerOnHeatingTimeSeconds = TTotalPrePowerOnHeatingTimeSeconds

---@class Metrics.ResetTime
---@field ResetTime integer
local TResetTime = {}
TResetTime.__index = TResetTime
TResetTime.group = {}

local function TResetTime_from_obj(obj)
    return setmetatable(obj, TResetTime)
end

function TResetTime.new(ResetTime)
    return TResetTime_from_obj({ResetTime = ResetTime})
end
---@param obj Metrics.ResetTime
function TResetTime:init_from_obj(obj)
    self.ResetTime = obj.ResetTime
end

function TResetTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetTime.group)
end

TResetTime.from_obj = TResetTime_from_obj

TResetTime.proto_property = {'ResetTime'}

TResetTime.default = {0}

TResetTime.struct = {{name = 'ResetTime', is_array = false, struct = nil}}

function TResetTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetTime', self.ResetTime, 'uint32', true, errs, need_convert)

    TResetTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetTime.proto_property, errs, need_convert)
    return self
end

function TResetTime:unpack(_)
    return self.ResetTime
end

Metrics.ResetTime = TResetTime

---@class Metrics.EnergyConsumptionkWh
---@field EnergyConsumptionkWh number
local TEnergyConsumptionkWh = {}
TEnergyConsumptionkWh.__index = TEnergyConsumptionkWh
TEnergyConsumptionkWh.group = {}

local function TEnergyConsumptionkWh_from_obj(obj)
    return setmetatable(obj, TEnergyConsumptionkWh)
end

function TEnergyConsumptionkWh.new(EnergyConsumptionkWh)
    return TEnergyConsumptionkWh_from_obj({EnergyConsumptionkWh = EnergyConsumptionkWh})
end
---@param obj Metrics.EnergyConsumptionkWh
function TEnergyConsumptionkWh:init_from_obj(obj)
    self.EnergyConsumptionkWh = obj.EnergyConsumptionkWh
end

function TEnergyConsumptionkWh:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnergyConsumptionkWh.group)
end

TEnergyConsumptionkWh.from_obj = TEnergyConsumptionkWh_from_obj

TEnergyConsumptionkWh.proto_property = {'EnergyConsumptionkWh'}

TEnergyConsumptionkWh.default = {0}

TEnergyConsumptionkWh.struct = {{name = 'EnergyConsumptionkWh', is_array = false, struct = nil}}

function TEnergyConsumptionkWh:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnergyConsumptionkWh', self.EnergyConsumptionkWh, 'double', false, errs, need_convert)

    TEnergyConsumptionkWh:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnergyConsumptionkWh.proto_property, errs, need_convert)
    return self
end

function TEnergyConsumptionkWh:unpack(_)
    return self.EnergyConsumptionkWh
end

Metrics.EnergyConsumptionkWh = TEnergyConsumptionkWh

---@class Metrics.TotalPowerWatts
---@field TotalPowerWatts integer
local TTotalPowerWatts = {}
TTotalPowerWatts.__index = TTotalPowerWatts
TTotalPowerWatts.group = {}

local function TTotalPowerWatts_from_obj(obj)
    return setmetatable(obj, TTotalPowerWatts)
end

function TTotalPowerWatts.new(TotalPowerWatts)
    return TTotalPowerWatts_from_obj({TotalPowerWatts = TotalPowerWatts})
end
---@param obj Metrics.TotalPowerWatts
function TTotalPowerWatts:init_from_obj(obj)
    self.TotalPowerWatts = obj.TotalPowerWatts
end

function TTotalPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalPowerWatts.group)
end

TTotalPowerWatts.from_obj = TTotalPowerWatts_from_obj

TTotalPowerWatts.proto_property = {'TotalPowerWatts'}

TTotalPowerWatts.default = {0}

TTotalPowerWatts.struct = {{name = 'TotalPowerWatts', is_array = false, struct = nil}}

function TTotalPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalPowerWatts', self.TotalPowerWatts, 'uint32', true, errs, need_convert)

    TTotalPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalPowerWatts.proto_property, errs, need_convert)
    return self
end

function TTotalPowerWatts:unpack(_)
    return self.TotalPowerWatts
end

Metrics.TotalPowerWatts = TTotalPowerWatts

---@class Metrics.ResetMetricsRsp
local TResetMetricsRsp = {}
TResetMetricsRsp.__index = TResetMetricsRsp
TResetMetricsRsp.group = {}

local function TResetMetricsRsp_from_obj(obj)
    return setmetatable(obj, TResetMetricsRsp)
end

function TResetMetricsRsp.new()
    return TResetMetricsRsp_from_obj({})
end
---@param obj Metrics.ResetMetricsRsp
function TResetMetricsRsp:init_from_obj(obj)

end

function TResetMetricsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetMetricsRsp.group)
end

TResetMetricsRsp.from_obj = TResetMetricsRsp_from_obj

TResetMetricsRsp.proto_property = {}

TResetMetricsRsp.default = {}

TResetMetricsRsp.struct = {}

function TResetMetricsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetMetricsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetMetricsRsp.proto_property, errs, need_convert)
    return self
end

function TResetMetricsRsp:unpack(_)
end

Metrics.ResetMetricsRsp = TResetMetricsRsp

---@class Metrics.ResetMetricsReq
local TResetMetricsReq = {}
TResetMetricsReq.__index = TResetMetricsReq
TResetMetricsReq.group = {}

local function TResetMetricsReq_from_obj(obj)
    return setmetatable(obj, TResetMetricsReq)
end

function TResetMetricsReq.new()
    return TResetMetricsReq_from_obj({})
end
---@param obj Metrics.ResetMetricsReq
function TResetMetricsReq:init_from_obj(obj)

end

function TResetMetricsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetMetricsReq.group)
end

TResetMetricsReq.from_obj = TResetMetricsReq_from_obj

TResetMetricsReq.proto_property = {}

TResetMetricsReq.default = {}

TResetMetricsReq.struct = {}

function TResetMetricsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetMetricsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetMetricsReq.proto_property, errs, need_convert)
    return self
end

function TResetMetricsReq:unpack(_)
end

Metrics.ResetMetricsReq = TResetMetricsReq

Metrics.interface = mdb.register_interface('bmc.kepler.Chassis.ThermalSubsystem.Metrics', {
    TotalPowerWatts = {'u', {'EMIT_CHANGE'}, true, nil},
    EnergyConsumptionkWh = {'d', {}, false, nil},
    ResetTime = {'u', {}, true, nil},
    TotalPrePowerOnHeatingTimeSeconds = {'u', {}, true, nil},
    TotalRuntimeHeatingTimeSeconds = {'u', {}, true, nil}
}, {ResetMetrics = {'a{ss}', '', TResetMetricsReq, TResetMetricsRsp}}, {})

return Metrics
