-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FanSnapshot = {}

---@class FanSnapshot.GetActivatedPolicyFactorsReq
local TGetActivatedPolicyFactorsReq = {}
TGetActivatedPolicyFactorsReq.__index = TGetActivatedPolicyFactorsReq
TGetActivatedPolicyFactorsReq.group = {}

local function TGetActivatedPolicyFactorsReq_from_obj(obj)
    return setmetatable(obj, TGetActivatedPolicyFactorsReq)
end

function TGetActivatedPolicyFactorsReq.new()
    return TGetActivatedPolicyFactorsReq_from_obj({})
end
---@param obj FanSnapshot.GetActivatedPolicyFactorsReq
function TGetActivatedPolicyFactorsReq:init_from_obj(obj)

end

function TGetActivatedPolicyFactorsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetActivatedPolicyFactorsReq.group)
end

TGetActivatedPolicyFactorsReq.from_obj = TGetActivatedPolicyFactorsReq_from_obj

TGetActivatedPolicyFactorsReq.proto_property = {}

TGetActivatedPolicyFactorsReq.default = {}

TGetActivatedPolicyFactorsReq.struct = {}

function TGetActivatedPolicyFactorsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetActivatedPolicyFactorsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetActivatedPolicyFactorsReq.proto_property, errs, need_convert)
    return self
end

function TGetActivatedPolicyFactorsReq:unpack(_)
end

FanSnapshot.GetActivatedPolicyFactorsReq = TGetActivatedPolicyFactorsReq

---@class FanSnapshot.FanSnapshot
---@field ValidFlag boolean
---@field ActivatedType integer
---@field PWM integer
---@field FactorName string
local TFanSnapshot = {}
TFanSnapshot.__index = TFanSnapshot
TFanSnapshot.group = {}

local function TFanSnapshot_from_obj(obj)
    return setmetatable(obj, TFanSnapshot)
end

function TFanSnapshot.new(ValidFlag, ActivatedType, PWM, FactorName)
    return TFanSnapshot_from_obj({
        ValidFlag = ValidFlag,
        ActivatedType = ActivatedType,
        PWM = PWM,
        FactorName = FactorName
    })
end
---@param obj FanSnapshot.FanSnapshot
function TFanSnapshot:init_from_obj(obj)
    self.ValidFlag = obj.ValidFlag
    self.ActivatedType = obj.ActivatedType
    self.PWM = obj.PWM
    self.FactorName = obj.FactorName
end

function TFanSnapshot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanSnapshot.group)
end

TFanSnapshot.from_obj = TFanSnapshot_from_obj

TFanSnapshot.proto_property = {'ValidFlag', 'ActivatedType', 'PWM', 'FactorName'}

TFanSnapshot.default = {false, 0, 0, ''}

TFanSnapshot.struct = {
    {name = 'ValidFlag', is_array = false, struct = nil}, {name = 'ActivatedType', is_array = false, struct = nil},
    {name = 'PWM', is_array = false, struct = nil}, {name = 'FactorName', is_array = false, struct = nil}
}

function TFanSnapshot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidFlag', self.ValidFlag, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'ActivatedType', self.ActivatedType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PWM', self.PWM, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FactorName', self.FactorName, 'string', false, errs, need_convert)

    TFanSnapshot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanSnapshot.proto_property, errs, need_convert)
    return self
end

function TFanSnapshot:unpack(_)
    return self.ValidFlag, self.ActivatedType, self.PWM, self.FactorName
end

FanSnapshot.FanSnapshot = TFanSnapshot

---@class FanSnapshot.GetActivatedPolicyFactorsRsp
---@field RetData FanSnapshot.FanSnapshot
local TGetActivatedPolicyFactorsRsp = {}
TGetActivatedPolicyFactorsRsp.__index = TGetActivatedPolicyFactorsRsp
TGetActivatedPolicyFactorsRsp.group = {}

local function TGetActivatedPolicyFactorsRsp_from_obj(obj)
    obj.RetData = utils.from_obj(FanSnapshot.FanSnapshot, obj.RetData)
    return setmetatable(obj, TGetActivatedPolicyFactorsRsp)
end

function TGetActivatedPolicyFactorsRsp.new(RetData)
    return TGetActivatedPolicyFactorsRsp_from_obj({RetData = RetData})
end
---@param obj FanSnapshot.GetActivatedPolicyFactorsRsp
function TGetActivatedPolicyFactorsRsp:init_from_obj(obj)
    self.RetData = obj.RetData
end

function TGetActivatedPolicyFactorsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetActivatedPolicyFactorsRsp.group)
end

TGetActivatedPolicyFactorsRsp.from_obj = TGetActivatedPolicyFactorsRsp_from_obj

TGetActivatedPolicyFactorsRsp.proto_property = {'RetData'}

TGetActivatedPolicyFactorsRsp.default = {FanSnapshot.FanSnapshot.default}

TGetActivatedPolicyFactorsRsp.struct = {{name = 'RetData', is_array = false, struct = FanSnapshot.FanSnapshot.struct}}

function TGetActivatedPolicyFactorsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    FanSnapshot.FanSnapshot.new(self.RetData.ValidFlag, self.RetData.ActivatedType, self.RetData.PWM,
        self.RetData.FactorName):validate(prefix, errs, need_convert)

    TGetActivatedPolicyFactorsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetActivatedPolicyFactorsRsp.proto_property, errs, need_convert)
    return self
end

function TGetActivatedPolicyFactorsRsp:unpack(raw)
    return utils.unpack(raw, self.RetData)
end

FanSnapshot.GetActivatedPolicyFactorsRsp = TGetActivatedPolicyFactorsRsp

FanSnapshot.interface = mdb.register_interface('bmc.kepler.Systems.FanSnapshot', {}, {
    GetActivatedPolicyFactors = {'a{ss}', '(byys)', TGetActivatedPolicyFactorsReq, TGetActivatedPolicyFactorsRsp}
}, {})

return FanSnapshot
