-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Drive = {}

---@class Drive.CryptoEraseRsp
local TCryptoEraseRsp = {}
TCryptoEraseRsp.__index = TCryptoEraseRsp
TCryptoEraseRsp.group = {}

local function TCryptoEraseRsp_from_obj(obj)
    return setmetatable(obj, TCryptoEraseRsp)
end

function TCryptoEraseRsp.new()
    return TCryptoEraseRsp_from_obj({})
end
---@param obj Drive.CryptoEraseRsp
function TCryptoEraseRsp:init_from_obj(obj)

end

function TCryptoEraseRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCryptoEraseRsp.group)
end

TCryptoEraseRsp.from_obj = TCryptoEraseRsp_from_obj

TCryptoEraseRsp.proto_property = {}

TCryptoEraseRsp.default = {}

TCryptoEraseRsp.struct = {}

function TCryptoEraseRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCryptoEraseRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCryptoEraseRsp.proto_property, errs, need_convert)
    return self
end

function TCryptoEraseRsp:unpack(_)
end

Drive.CryptoEraseRsp = TCryptoEraseRsp

---@class Drive.CryptoEraseReq
local TCryptoEraseReq = {}
TCryptoEraseReq.__index = TCryptoEraseReq
TCryptoEraseReq.group = {}

local function TCryptoEraseReq_from_obj(obj)
    return setmetatable(obj, TCryptoEraseReq)
end

function TCryptoEraseReq.new()
    return TCryptoEraseReq_from_obj({})
end
---@param obj Drive.CryptoEraseReq
function TCryptoEraseReq:init_from_obj(obj)

end

function TCryptoEraseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCryptoEraseReq.group)
end

TCryptoEraseReq.from_obj = TCryptoEraseReq_from_obj

TCryptoEraseReq.proto_property = {}

TCryptoEraseReq.default = {}

TCryptoEraseReq.struct = {}

function TCryptoEraseReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCryptoEraseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCryptoEraseReq.proto_property, errs, need_convert)
    return self
end

function TCryptoEraseReq:unpack(_)
end

Drive.CryptoEraseReq = TCryptoEraseReq

---@class Drive.SetPatrolStateRsp
local TSetPatrolStateRsp = {}
TSetPatrolStateRsp.__index = TSetPatrolStateRsp
TSetPatrolStateRsp.group = {}

local function TSetPatrolStateRsp_from_obj(obj)
    return setmetatable(obj, TSetPatrolStateRsp)
end

function TSetPatrolStateRsp.new()
    return TSetPatrolStateRsp_from_obj({})
end
---@param obj Drive.SetPatrolStateRsp
function TSetPatrolStateRsp:init_from_obj(obj)

end

function TSetPatrolStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPatrolStateRsp.group)
end

TSetPatrolStateRsp.from_obj = TSetPatrolStateRsp_from_obj

TSetPatrolStateRsp.proto_property = {}

TSetPatrolStateRsp.default = {}

TSetPatrolStateRsp.struct = {}

function TSetPatrolStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPatrolStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPatrolStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetPatrolStateRsp:unpack(_)
end

Drive.SetPatrolStateRsp = TSetPatrolStateRsp

---@class Drive.SetPatrolStateReq
---@field PatrolState integer
local TSetPatrolStateReq = {}
TSetPatrolStateReq.__index = TSetPatrolStateReq
TSetPatrolStateReq.group = {}

local function TSetPatrolStateReq_from_obj(obj)
    return setmetatable(obj, TSetPatrolStateReq)
end

function TSetPatrolStateReq.new(PatrolState)
    return TSetPatrolStateReq_from_obj({PatrolState = PatrolState})
end
---@param obj Drive.SetPatrolStateReq
function TSetPatrolStateReq:init_from_obj(obj)
    self.PatrolState = obj.PatrolState
end

function TSetPatrolStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPatrolStateReq.group)
end

TSetPatrolStateReq.from_obj = TSetPatrolStateReq_from_obj

TSetPatrolStateReq.proto_property = {'PatrolState'}

TSetPatrolStateReq.default = {0}

TSetPatrolStateReq.struct = {{name = 'PatrolState', is_array = false, struct = nil}}

function TSetPatrolStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PatrolState', self.PatrolState, 'uint8', false, errs, need_convert)

    TSetPatrolStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPatrolStateReq.proto_property, errs, need_convert)
    return self
end

function TSetPatrolStateReq:unpack(_)
    return self.PatrolState
end

Drive.SetPatrolStateReq = TSetPatrolStateReq

---@class Drive.SetBootPriorityRsp
local TSetBootPriorityRsp = {}
TSetBootPriorityRsp.__index = TSetBootPriorityRsp
TSetBootPriorityRsp.group = {}

local function TSetBootPriorityRsp_from_obj(obj)
    return setmetatable(obj, TSetBootPriorityRsp)
end

function TSetBootPriorityRsp.new()
    return TSetBootPriorityRsp_from_obj({})
end
---@param obj Drive.SetBootPriorityRsp
function TSetBootPriorityRsp:init_from_obj(obj)

end

function TSetBootPriorityRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootPriorityRsp.group)
end

TSetBootPriorityRsp.from_obj = TSetBootPriorityRsp_from_obj

TSetBootPriorityRsp.proto_property = {}

TSetBootPriorityRsp.default = {}

TSetBootPriorityRsp.struct = {}

function TSetBootPriorityRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBootPriorityRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootPriorityRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootPriorityRsp:unpack(_)
end

Drive.SetBootPriorityRsp = TSetBootPriorityRsp

---@class Drive.SetBootPriorityReq
---@field BootPriority integer
local TSetBootPriorityReq = {}
TSetBootPriorityReq.__index = TSetBootPriorityReq
TSetBootPriorityReq.group = {}

local function TSetBootPriorityReq_from_obj(obj)
    return setmetatable(obj, TSetBootPriorityReq)
end

function TSetBootPriorityReq.new(BootPriority)
    return TSetBootPriorityReq_from_obj({BootPriority = BootPriority})
end
---@param obj Drive.SetBootPriorityReq
function TSetBootPriorityReq:init_from_obj(obj)
    self.BootPriority = obj.BootPriority
end

function TSetBootPriorityReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootPriorityReq.group)
end

TSetBootPriorityReq.from_obj = TSetBootPriorityReq_from_obj

TSetBootPriorityReq.proto_property = {'BootPriority'}

TSetBootPriorityReq.default = {0}

TSetBootPriorityReq.struct = {{name = 'BootPriority', is_array = false, struct = nil}}

function TSetBootPriorityReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootPriority', self.BootPriority, 'uint8', false, errs, need_convert)

    TSetBootPriorityReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootPriorityReq.proto_property, errs, need_convert)
    return self
end

function TSetBootPriorityReq:unpack(_)
    return self.BootPriority
end

Drive.SetBootPriorityReq = TSetBootPriorityReq

---@class Drive.SetHotspareTypeRsp
local TSetHotspareTypeRsp = {}
TSetHotspareTypeRsp.__index = TSetHotspareTypeRsp
TSetHotspareTypeRsp.group = {}

local function TSetHotspareTypeRsp_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeRsp)
end

function TSetHotspareTypeRsp.new()
    return TSetHotspareTypeRsp_from_obj({})
end
---@param obj Drive.SetHotspareTypeRsp
function TSetHotspareTypeRsp:init_from_obj(obj)

end

function TSetHotspareTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeRsp.group)
end

TSetHotspareTypeRsp.from_obj = TSetHotspareTypeRsp_from_obj

TSetHotspareTypeRsp.proto_property = {}

TSetHotspareTypeRsp.default = {}

TSetHotspareTypeRsp.struct = {}

function TSetHotspareTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetHotspareTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeRsp.proto_property, errs, need_convert)
    return self
end

function TSetHotspareTypeRsp:unpack(_)
end

Drive.SetHotspareTypeRsp = TSetHotspareTypeRsp

---@class Drive.SetHotspareTypeReq
---@field HotspareType integer
---@field VolumeId integer
local TSetHotspareTypeReq = {}
TSetHotspareTypeReq.__index = TSetHotspareTypeReq
TSetHotspareTypeReq.group = {}

local function TSetHotspareTypeReq_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeReq)
end

function TSetHotspareTypeReq.new(HotspareType, VolumeId)
    return TSetHotspareTypeReq_from_obj({HotspareType = HotspareType, VolumeId = VolumeId})
end
---@param obj Drive.SetHotspareTypeReq
function TSetHotspareTypeReq:init_from_obj(obj)
    self.HotspareType = obj.HotspareType
    self.VolumeId = obj.VolumeId
end

function TSetHotspareTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeReq.group)
end

TSetHotspareTypeReq.from_obj = TSetHotspareTypeReq_from_obj

TSetHotspareTypeReq.proto_property = {'HotspareType', 'VolumeId'}

TSetHotspareTypeReq.default = {0, 0}

TSetHotspareTypeReq.struct = {
    {name = 'HotspareType', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil}
}

function TSetHotspareTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HotspareType', self.HotspareType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint16', false, errs, need_convert)

    TSetHotspareTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeReq.proto_property, errs, need_convert)
    return self
end

function TSetHotspareTypeReq:unpack(_)
    return self.HotspareType, self.VolumeId
end

Drive.SetHotspareTypeReq = TSetHotspareTypeReq

---@class Drive.SetFirmwareStatusRsp
local TSetFirmwareStatusRsp = {}
TSetFirmwareStatusRsp.__index = TSetFirmwareStatusRsp
TSetFirmwareStatusRsp.group = {}

local function TSetFirmwareStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusRsp)
end

function TSetFirmwareStatusRsp.new()
    return TSetFirmwareStatusRsp_from_obj({})
end
---@param obj Drive.SetFirmwareStatusRsp
function TSetFirmwareStatusRsp:init_from_obj(obj)

end

function TSetFirmwareStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusRsp.group)
end

TSetFirmwareStatusRsp.from_obj = TSetFirmwareStatusRsp_from_obj

TSetFirmwareStatusRsp.proto_property = {}

TSetFirmwareStatusRsp.default = {}

TSetFirmwareStatusRsp.struct = {}

function TSetFirmwareStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetFirmwareStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetFirmwareStatusRsp:unpack(_)
end

Drive.SetFirmwareStatusRsp = TSetFirmwareStatusRsp

---@class Drive.SetFirmwareStatusReq
---@field FirmwareStatus integer
local TSetFirmwareStatusReq = {}
TSetFirmwareStatusReq.__index = TSetFirmwareStatusReq
TSetFirmwareStatusReq.group = {}

local function TSetFirmwareStatusReq_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusReq)
end

function TSetFirmwareStatusReq.new(FirmwareStatus)
    return TSetFirmwareStatusReq_from_obj({FirmwareStatus = FirmwareStatus})
end
---@param obj Drive.SetFirmwareStatusReq
function TSetFirmwareStatusReq:init_from_obj(obj)
    self.FirmwareStatus = obj.FirmwareStatus
end

function TSetFirmwareStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusReq.group)
end

TSetFirmwareStatusReq.from_obj = TSetFirmwareStatusReq_from_obj

TSetFirmwareStatusReq.proto_property = {'FirmwareStatus'}

TSetFirmwareStatusReq.default = {0}

TSetFirmwareStatusReq.struct = {{name = 'FirmwareStatus', is_array = false, struct = nil}}

function TSetFirmwareStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareStatus', self.FirmwareStatus, 'uint8', false, errs, need_convert)

    TSetFirmwareStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetFirmwareStatusReq:unpack(_)
    return self.FirmwareStatus
end

Drive.SetFirmwareStatusReq = TSetFirmwareStatusReq

---@class Drive.SetFaultIndicatorStateRsp
local TSetFaultIndicatorStateRsp = {}
TSetFaultIndicatorStateRsp.__index = TSetFaultIndicatorStateRsp
TSetFaultIndicatorStateRsp.group = {}

local function TSetFaultIndicatorStateRsp_from_obj(obj)
    return setmetatable(obj, TSetFaultIndicatorStateRsp)
end

function TSetFaultIndicatorStateRsp.new()
    return TSetFaultIndicatorStateRsp_from_obj({})
end
---@param obj Drive.SetFaultIndicatorStateRsp
function TSetFaultIndicatorStateRsp:init_from_obj(obj)

end

function TSetFaultIndicatorStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultIndicatorStateRsp.group)
end

TSetFaultIndicatorStateRsp.from_obj = TSetFaultIndicatorStateRsp_from_obj

TSetFaultIndicatorStateRsp.proto_property = {}

TSetFaultIndicatorStateRsp.default = {}

TSetFaultIndicatorStateRsp.struct = {}

function TSetFaultIndicatorStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetFaultIndicatorStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultIndicatorStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetFaultIndicatorStateRsp:unpack(_)
end

Drive.SetFaultIndicatorStateRsp = TSetFaultIndicatorStateRsp

---@class Drive.SetFaultIndicatorStateReq
---@field FaultIndicatorState integer
local TSetFaultIndicatorStateReq = {}
TSetFaultIndicatorStateReq.__index = TSetFaultIndicatorStateReq
TSetFaultIndicatorStateReq.group = {}

local function TSetFaultIndicatorStateReq_from_obj(obj)
    return setmetatable(obj, TSetFaultIndicatorStateReq)
end

function TSetFaultIndicatorStateReq.new(FaultIndicatorState)
    return TSetFaultIndicatorStateReq_from_obj({FaultIndicatorState = FaultIndicatorState})
end
---@param obj Drive.SetFaultIndicatorStateReq
function TSetFaultIndicatorStateReq:init_from_obj(obj)
    self.FaultIndicatorState = obj.FaultIndicatorState
end

function TSetFaultIndicatorStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultIndicatorStateReq.group)
end

TSetFaultIndicatorStateReq.from_obj = TSetFaultIndicatorStateReq_from_obj

TSetFaultIndicatorStateReq.proto_property = {'FaultIndicatorState'}

TSetFaultIndicatorStateReq.default = {0}

TSetFaultIndicatorStateReq.struct = {{name = 'FaultIndicatorState', is_array = false, struct = nil}}

function TSetFaultIndicatorStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultIndicatorState', self.FaultIndicatorState, 'uint8', false, errs, need_convert)

    TSetFaultIndicatorStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultIndicatorStateReq.proto_property, errs, need_convert)
    return self
end

function TSetFaultIndicatorStateReq:unpack(_)
    return self.FaultIndicatorState
end

Drive.SetFaultIndicatorStateReq = TSetFaultIndicatorStateReq

---@class Drive.SetLocationIndicatorStateRsp
local TSetLocationIndicatorStateRsp = {}
TSetLocationIndicatorStateRsp.__index = TSetLocationIndicatorStateRsp
TSetLocationIndicatorStateRsp.group = {}

local function TSetLocationIndicatorStateRsp_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateRsp)
end

function TSetLocationIndicatorStateRsp.new()
    return TSetLocationIndicatorStateRsp_from_obj({})
end
---@param obj Drive.SetLocationIndicatorStateRsp
function TSetLocationIndicatorStateRsp:init_from_obj(obj)

end

function TSetLocationIndicatorStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateRsp.group)
end

TSetLocationIndicatorStateRsp.from_obj = TSetLocationIndicatorStateRsp_from_obj

TSetLocationIndicatorStateRsp.proto_property = {}

TSetLocationIndicatorStateRsp.default = {}

TSetLocationIndicatorStateRsp.struct = {}

function TSetLocationIndicatorStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetLocationIndicatorStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetLocationIndicatorStateRsp:unpack(_)
end

Drive.SetLocationIndicatorStateRsp = TSetLocationIndicatorStateRsp

---@class Drive.SetLocationIndicatorStateReq
---@field LocationIndicatorState integer
local TSetLocationIndicatorStateReq = {}
TSetLocationIndicatorStateReq.__index = TSetLocationIndicatorStateReq
TSetLocationIndicatorStateReq.group = {}

local function TSetLocationIndicatorStateReq_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateReq)
end

function TSetLocationIndicatorStateReq.new(LocationIndicatorState)
    return TSetLocationIndicatorStateReq_from_obj({LocationIndicatorState = LocationIndicatorState})
end
---@param obj Drive.SetLocationIndicatorStateReq
function TSetLocationIndicatorStateReq:init_from_obj(obj)
    self.LocationIndicatorState = obj.LocationIndicatorState
end

function TSetLocationIndicatorStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateReq.group)
end

TSetLocationIndicatorStateReq.from_obj = TSetLocationIndicatorStateReq_from_obj

TSetLocationIndicatorStateReq.proto_property = {'LocationIndicatorState'}

TSetLocationIndicatorStateReq.default = {0}

TSetLocationIndicatorStateReq.struct = {{name = 'LocationIndicatorState', is_array = false, struct = nil}}

function TSetLocationIndicatorStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationIndicatorState', self.LocationIndicatorState, 'uint8', false, errs,
        need_convert)

    TSetLocationIndicatorStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateReq.proto_property, errs, need_convert)
    return self
end

function TSetLocationIndicatorStateReq:unpack(_)
    return self.LocationIndicatorState
end

Drive.SetLocationIndicatorStateReq = TSetLocationIndicatorStateReq

Drive.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive', {
    NodeId = {'s', nil, true, nil},
    Id = {'y', nil, true, nil},
    SlotNumber = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    Presence = {'y', nil, true, nil},
    CapacityMiB = {'u', nil, true, nil},
    TemperatureCelsius = {'n', {['volatile'] = true, ['emitsChangedSignal'] = 'false'}, true, nil},
    Model = {'s', nil, true, nil},
    EnclosureId = {'q', nil, true, nil},
    LocationIndicatorState = {'y', nil, true, nil},
    LocateLed = {'y', nil, true, nil},
    FaultLed = {'y', nil, true, nil},
    Protocol = {'y', nil, true, nil},
    CapableSpeedGbs = {'y', nil, true, nil},
    NegotiatedSpeedGbs = {'y', nil, true, nil},
    MediaType = {'y', nil, true, nil},
    FirmwareStatus = {'y', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    PowerOnHours = {'d', {['volatile'] = true, ['emitsChangedSignal'] = 'false'}, true, nil},
    Revision = {'s', nil, true, nil},
    RotationSpeedRPM = {'q', nil, true, nil},
    BlockSizeBytes = {'q', nil, true, nil},
    SASAddress1 = {'s', nil, true, nil},
    SASAddress2 = {'s', nil, true, nil},
    PredictedMediaLifeLeftPercent = {'y', nil, true, nil},
    PredictedFailCount = {'u', nil, true, nil},
    MediaErrorCount = {'u', nil, true, nil},
    OtherErrorCount = {'u', nil, true, nil},
    PatrolState = {'y', nil, true, nil},
    PowerState = {'y', nil, true, nil},
    RebuildState = {'y', nil, true, nil},
    RebuildProgress = {'y', {['volatile'] = true, ['emitsChangedSignal'] = 'true'}, true, nil},
    BootPriority = {'y', nil, true, nil},
    FormFactor = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    HotspareType = {'y', nil, true, nil},
    RefControllerId = {'y', nil, true, nil},
    RefVolumeList = {'aq', nil, true, nil},
    RefDiskArrayId = {'q', nil, true, nil},
    ManufacturerId = {'u', nil, true, nil},
    PCIeLinkSpeed = {'d', nil, true, nil},
    Location = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    DeviceName = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ResourceId = {'y', nil, true, nil},
    ContainerPhysicalContext = {'s', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {
    SetLocationIndicatorState = {'a{ss}y', '', TSetLocationIndicatorStateReq, TSetLocationIndicatorStateRsp},
    SetFaultIndicatorState = {'a{ss}y', '', TSetFaultIndicatorStateReq, TSetFaultIndicatorStateRsp},
    SetFirmwareStatus = {'a{ss}y', '', TSetFirmwareStatusReq, TSetFirmwareStatusRsp},
    SetHotspareType = {'a{ss}yq', '', TSetHotspareTypeReq, TSetHotspareTypeRsp},
    SetBootPriority = {'a{ss}y', '', TSetBootPriorityReq, TSetBootPriorityRsp},
    SetPatrolState = {'a{ss}y', '', TSetPatrolStateReq, TSetPatrolStateRsp},
    CryptoErase = {'a{ss}', '', TCryptoEraseReq, TCryptoEraseRsp}
}, {})

return Drive
