-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CoolingRequirement = {}

---@class CoolingRequirement.SensorName
---@field SensorName string
local TSensorName = {}
TSensorName.__index = TSensorName
TSensorName.group = {}

local function TSensorName_from_obj(obj)
    return setmetatable(obj, TSensorName)
end

function TSensorName.new(SensorName)
    return TSensorName_from_obj({SensorName = SensorName})
end
---@param obj CoolingRequirement.SensorName
function TSensorName:init_from_obj(obj)
    self.SensorName = obj.SensorName
end

function TSensorName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorName.group)
end

TSensorName.from_obj = TSensorName_from_obj

TSensorName.proto_property = {'SensorName'}

TSensorName.default = {''}

TSensorName.struct = {{name = 'SensorName', is_array = false, struct = nil}}

function TSensorName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', true, errs, need_convert)

    TSensorName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorName.proto_property, errs, need_convert)
    return self
end

function TSensorName:unpack(_)
    return self.SensorName
end

CoolingRequirement.SensorName = TSensorName

---@class CoolingRequirement.SmartCoolingTargetTemperatureCelsius
---@field SmartCoolingTargetTemperatureCelsius integer[]
local TSmartCoolingTargetTemperatureCelsius = {}
TSmartCoolingTargetTemperatureCelsius.__index = TSmartCoolingTargetTemperatureCelsius
TSmartCoolingTargetTemperatureCelsius.group = {}

local function TSmartCoolingTargetTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TSmartCoolingTargetTemperatureCelsius)
end

function TSmartCoolingTargetTemperatureCelsius.new(SmartCoolingTargetTemperatureCelsius)
    return TSmartCoolingTargetTemperatureCelsius_from_obj({
        SmartCoolingTargetTemperatureCelsius = SmartCoolingTargetTemperatureCelsius
    })
end
---@param obj CoolingRequirement.SmartCoolingTargetTemperatureCelsius
function TSmartCoolingTargetTemperatureCelsius:init_from_obj(obj)
    self.SmartCoolingTargetTemperatureCelsius = obj.SmartCoolingTargetTemperatureCelsius
end

function TSmartCoolingTargetTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmartCoolingTargetTemperatureCelsius.group)
end

TSmartCoolingTargetTemperatureCelsius.from_obj = TSmartCoolingTargetTemperatureCelsius_from_obj

TSmartCoolingTargetTemperatureCelsius.proto_property = {'SmartCoolingTargetTemperatureCelsius'}

TSmartCoolingTargetTemperatureCelsius.default = {{}}

TSmartCoolingTargetTemperatureCelsius.struct = {
    {name = 'SmartCoolingTargetTemperatureCelsius', is_array = true, struct = nil}
}

function TSmartCoolingTargetTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SmartCoolingTargetTemperatureCelsius', self.SmartCoolingTargetTemperatureCelsius,
        'int16', false, errs, need_convert)

    TSmartCoolingTargetTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmartCoolingTargetTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TSmartCoolingTargetTemperatureCelsius:unpack(_)
    return self.SmartCoolingTargetTemperatureCelsius
end

CoolingRequirement.SmartCoolingTargetTemperatureCelsius = TSmartCoolingTargetTemperatureCelsius

---@class CoolingRequirement.AlarmSpeed
---@field AlarmSpeed integer[]
local TAlarmSpeed = {}
TAlarmSpeed.__index = TAlarmSpeed
TAlarmSpeed.group = {}

local function TAlarmSpeed_from_obj(obj)
    return setmetatable(obj, TAlarmSpeed)
end

function TAlarmSpeed.new(AlarmSpeed)
    return TAlarmSpeed_from_obj({AlarmSpeed = AlarmSpeed})
end
---@param obj CoolingRequirement.AlarmSpeed
function TAlarmSpeed:init_from_obj(obj)
    self.AlarmSpeed = obj.AlarmSpeed
end

function TAlarmSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlarmSpeed.group)
end

TAlarmSpeed.from_obj = TAlarmSpeed_from_obj

TAlarmSpeed.proto_property = {'AlarmSpeed'}

TAlarmSpeed.default = {{}}

TAlarmSpeed.struct = {{name = 'AlarmSpeed', is_array = true, struct = nil}}

function TAlarmSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'AlarmSpeed', self.AlarmSpeed, 'uint8', true, errs, need_convert)

    TAlarmSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlarmSpeed.proto_property, errs, need_convert)
    return self
end

function TAlarmSpeed:unpack(_)
    return self.AlarmSpeed
end

CoolingRequirement.AlarmSpeed = TAlarmSpeed

---@class CoolingRequirement.ThresholdValue
---@field ThresholdValue integer[]
local TThresholdValue = {}
TThresholdValue.__index = TThresholdValue
TThresholdValue.group = {}

local function TThresholdValue_from_obj(obj)
    return setmetatable(obj, TThresholdValue)
end

function TThresholdValue.new(ThresholdValue)
    return TThresholdValue_from_obj({ThresholdValue = ThresholdValue})
end
---@param obj CoolingRequirement.ThresholdValue
function TThresholdValue:init_from_obj(obj)
    self.ThresholdValue = obj.ThresholdValue
end

function TThresholdValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TThresholdValue.group)
end

TThresholdValue.from_obj = TThresholdValue_from_obj

TThresholdValue.proto_property = {'ThresholdValue'}

TThresholdValue.default = {{}}

TThresholdValue.struct = {{name = 'ThresholdValue', is_array = true, struct = nil}}

function TThresholdValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'ThresholdValue', self.ThresholdValue, 'uint8', true, errs, need_convert)

    TThresholdValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TThresholdValue.proto_property, errs, need_convert)
    return self
end

function TThresholdValue:unpack(_)
    return self.ThresholdValue
end

CoolingRequirement.ThresholdValue = TThresholdValue

---@class CoolingRequirement.FailedValue
---@field FailedValue integer
local TFailedValue = {}
TFailedValue.__index = TFailedValue
TFailedValue.group = {}

local function TFailedValue_from_obj(obj)
    return setmetatable(obj, TFailedValue)
end

function TFailedValue.new(FailedValue)
    return TFailedValue_from_obj({FailedValue = FailedValue})
end
---@param obj CoolingRequirement.FailedValue
function TFailedValue:init_from_obj(obj)
    self.FailedValue = obj.FailedValue
end

function TFailedValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFailedValue.group)
end

TFailedValue.from_obj = TFailedValue_from_obj

TFailedValue.proto_property = {'FailedValue'}

TFailedValue.default = {0}

TFailedValue.struct = {{name = 'FailedValue', is_array = false, struct = nil}}

function TFailedValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FailedValue', self.FailedValue, 'uint64', true, errs, need_convert)

    TFailedValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFailedValue.proto_property, errs, need_convert)
    return self
end

function TFailedValue:unpack(_)
    return self.FailedValue
end

CoolingRequirement.FailedValue = TFailedValue

---@class CoolingRequirement.MonitoringValue
---@field MonitoringValue number
local TMonitoringValue = {}
TMonitoringValue.__index = TMonitoringValue
TMonitoringValue.group = {}

local function TMonitoringValue_from_obj(obj)
    return setmetatable(obj, TMonitoringValue)
end

function TMonitoringValue.new(MonitoringValue)
    return TMonitoringValue_from_obj({MonitoringValue = MonitoringValue})
end
---@param obj CoolingRequirement.MonitoringValue
function TMonitoringValue:init_from_obj(obj)
    self.MonitoringValue = obj.MonitoringValue
end

function TMonitoringValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMonitoringValue.group)
end

TMonitoringValue.from_obj = TMonitoringValue_from_obj

TMonitoringValue.proto_property = {'MonitoringValue'}

TMonitoringValue.default = {0}

TMonitoringValue.struct = {{name = 'MonitoringValue', is_array = false, struct = nil}}

function TMonitoringValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MonitoringValue', self.MonitoringValue, 'double', true, errs, need_convert)

    TMonitoringValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMonitoringValue.proto_property, errs, need_convert)
    return self
end

function TMonitoringValue:unpack(_)
    return self.MonitoringValue
end

CoolingRequirement.MonitoringValue = TMonitoringValue

---@class CoolingRequirement.MonitoringStatus
---@field MonitoringStatus integer
local TMonitoringStatus = {}
TMonitoringStatus.__index = TMonitoringStatus
TMonitoringStatus.group = {}

local function TMonitoringStatus_from_obj(obj)
    return setmetatable(obj, TMonitoringStatus)
end

function TMonitoringStatus.new(MonitoringStatus)
    return TMonitoringStatus_from_obj({MonitoringStatus = MonitoringStatus})
end
---@param obj CoolingRequirement.MonitoringStatus
function TMonitoringStatus:init_from_obj(obj)
    self.MonitoringStatus = obj.MonitoringStatus
end

function TMonitoringStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMonitoringStatus.group)
end

TMonitoringStatus.from_obj = TMonitoringStatus_from_obj

TMonitoringStatus.proto_property = {'MonitoringStatus'}

TMonitoringStatus.default = {0}

TMonitoringStatus.struct = {{name = 'MonitoringStatus', is_array = false, struct = nil}}

function TMonitoringStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MonitoringStatus', self.MonitoringStatus, 'uint8', true, errs, need_convert)

    TMonitoringStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMonitoringStatus.proto_property, errs, need_convert)
    return self
end

function TMonitoringStatus:unpack(_)
    return self.MonitoringStatus
end

CoolingRequirement.MonitoringStatus = TMonitoringStatus

---@class CoolingRequirement.TargetTemperatureRangeCelsius
---@field TargetTemperatureRangeCelsius integer[]
local TTargetTemperatureRangeCelsius = {}
TTargetTemperatureRangeCelsius.__index = TTargetTemperatureRangeCelsius
TTargetTemperatureRangeCelsius.group = {}

local function TTargetTemperatureRangeCelsius_from_obj(obj)
    return setmetatable(obj, TTargetTemperatureRangeCelsius)
end

function TTargetTemperatureRangeCelsius.new(TargetTemperatureRangeCelsius)
    return TTargetTemperatureRangeCelsius_from_obj({TargetTemperatureRangeCelsius = TargetTemperatureRangeCelsius})
end
---@param obj CoolingRequirement.TargetTemperatureRangeCelsius
function TTargetTemperatureRangeCelsius:init_from_obj(obj)
    self.TargetTemperatureRangeCelsius = obj.TargetTemperatureRangeCelsius
end

function TTargetTemperatureRangeCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTargetTemperatureRangeCelsius.group)
end

TTargetTemperatureRangeCelsius.from_obj = TTargetTemperatureRangeCelsius_from_obj

TTargetTemperatureRangeCelsius.proto_property = {'TargetTemperatureRangeCelsius'}

TTargetTemperatureRangeCelsius.default = {{}}

TTargetTemperatureRangeCelsius.struct = {{name = 'TargetTemperatureRangeCelsius', is_array = true, struct = nil}}

function TTargetTemperatureRangeCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TargetTemperatureRangeCelsius', self.TargetTemperatureRangeCelsius, 'uint8', true,
        errs, need_convert)

    TTargetTemperatureRangeCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTargetTemperatureRangeCelsius.proto_property, errs, need_convert)
    return self
end

function TTargetTemperatureRangeCelsius:unpack(_)
    return self.TargetTemperatureRangeCelsius
end

CoolingRequirement.TargetTemperatureRangeCelsius = TTargetTemperatureRangeCelsius

---@class CoolingRequirement.CustomTargetTemperatureCelsius
---@field CustomTargetTemperatureCelsius integer
local TCustomTargetTemperatureCelsius = {}
TCustomTargetTemperatureCelsius.__index = TCustomTargetTemperatureCelsius
TCustomTargetTemperatureCelsius.group = {}

local function TCustomTargetTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TCustomTargetTemperatureCelsius)
end

function TCustomTargetTemperatureCelsius.new(CustomTargetTemperatureCelsius)
    return TCustomTargetTemperatureCelsius_from_obj({
        CustomTargetTemperatureCelsius = CustomTargetTemperatureCelsius or 255
    })
end
---@param obj CoolingRequirement.CustomTargetTemperatureCelsius
function TCustomTargetTemperatureCelsius:init_from_obj(obj)
    self.CustomTargetTemperatureCelsius = obj.CustomTargetTemperatureCelsius or 255
end

function TCustomTargetTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomTargetTemperatureCelsius.group)
end

TCustomTargetTemperatureCelsius.from_obj = TCustomTargetTemperatureCelsius_from_obj

TCustomTargetTemperatureCelsius.proto_property = {'CustomTargetTemperatureCelsius'}

TCustomTargetTemperatureCelsius.default = {0}

TCustomTargetTemperatureCelsius.struct = {{name = 'CustomTargetTemperatureCelsius', is_array = false, struct = nil}}

function TCustomTargetTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CustomTargetTemperatureCelsius', self.CustomTargetTemperatureCelsius, 'uint8', true,
        errs, need_convert)

    TCustomTargetTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomTargetTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TCustomTargetTemperatureCelsius:unpack(_)
    return self.CustomTargetTemperatureCelsius
end

CoolingRequirement.CustomTargetTemperatureCelsius = TCustomTargetTemperatureCelsius

---@class CoolingRequirement.CustomSupported
---@field CustomSupported boolean
local TCustomSupported = {}
TCustomSupported.__index = TCustomSupported
TCustomSupported.group = {}

local function TCustomSupported_from_obj(obj)
    return setmetatable(obj, TCustomSupported)
end

function TCustomSupported.new(CustomSupported)
    return TCustomSupported_from_obj({CustomSupported = CustomSupported})
end
---@param obj CoolingRequirement.CustomSupported
function TCustomSupported:init_from_obj(obj)
    self.CustomSupported = obj.CustomSupported
end

function TCustomSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSupported.group)
end

TCustomSupported.from_obj = TCustomSupported_from_obj

TCustomSupported.proto_property = {'CustomSupported'}

TCustomSupported.default = {false}

TCustomSupported.struct = {{name = 'CustomSupported', is_array = false, struct = nil}}

function TCustomSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CustomSupported', self.CustomSupported, 'bool', true, errs, need_convert)

    TCustomSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSupported.proto_property, errs, need_convert)
    return self
end

function TCustomSupported:unpack(_)
    return self.CustomSupported
end

CoolingRequirement.CustomSupported = TCustomSupported

---@class CoolingRequirement.MaxAllowedTemperatureCelsius
---@field MaxAllowedTemperatureCelsius integer
local TMaxAllowedTemperatureCelsius = {}
TMaxAllowedTemperatureCelsius.__index = TMaxAllowedTemperatureCelsius
TMaxAllowedTemperatureCelsius.group = {}

local function TMaxAllowedTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TMaxAllowedTemperatureCelsius)
end

function TMaxAllowedTemperatureCelsius.new(MaxAllowedTemperatureCelsius)
    return TMaxAllowedTemperatureCelsius_from_obj({MaxAllowedTemperatureCelsius = MaxAllowedTemperatureCelsius})
end
---@param obj CoolingRequirement.MaxAllowedTemperatureCelsius
function TMaxAllowedTemperatureCelsius:init_from_obj(obj)
    self.MaxAllowedTemperatureCelsius = obj.MaxAllowedTemperatureCelsius
end

function TMaxAllowedTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxAllowedTemperatureCelsius.group)
end

TMaxAllowedTemperatureCelsius.from_obj = TMaxAllowedTemperatureCelsius_from_obj

TMaxAllowedTemperatureCelsius.proto_property = {'MaxAllowedTemperatureCelsius'}

TMaxAllowedTemperatureCelsius.default = {0}

TMaxAllowedTemperatureCelsius.struct = {{name = 'MaxAllowedTemperatureCelsius', is_array = false, struct = nil}}

function TMaxAllowedTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxAllowedTemperatureCelsius', self.MaxAllowedTemperatureCelsius, 'uint8', true, errs,
        need_convert)

    TMaxAllowedTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxAllowedTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TMaxAllowedTemperatureCelsius:unpack(_)
    return self.MaxAllowedTemperatureCelsius
end

CoolingRequirement.MaxAllowedTemperatureCelsius = TMaxAllowedTemperatureCelsius

---@class CoolingRequirement.TargetTemperatureCelsius
---@field TargetTemperatureCelsius integer
local TTargetTemperatureCelsius = {}
TTargetTemperatureCelsius.__index = TTargetTemperatureCelsius
TTargetTemperatureCelsius.group = {}

local function TTargetTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTargetTemperatureCelsius)
end

function TTargetTemperatureCelsius.new(TargetTemperatureCelsius)
    return TTargetTemperatureCelsius_from_obj({TargetTemperatureCelsius = TargetTemperatureCelsius or 127})
end
---@param obj CoolingRequirement.TargetTemperatureCelsius
function TTargetTemperatureCelsius:init_from_obj(obj)
    self.TargetTemperatureCelsius = obj.TargetTemperatureCelsius or 127
end

function TTargetTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTargetTemperatureCelsius.group)
end

TTargetTemperatureCelsius.from_obj = TTargetTemperatureCelsius_from_obj

TTargetTemperatureCelsius.proto_property = {'TargetTemperatureCelsius'}

TTargetTemperatureCelsius.default = {0}

TTargetTemperatureCelsius.struct = {{name = 'TargetTemperatureCelsius', is_array = false, struct = nil}}

function TTargetTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TargetTemperatureCelsius', self.TargetTemperatureCelsius, 'uint8', true, errs,
        need_convert)

    TTargetTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTargetTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTargetTemperatureCelsius:unpack(_)
    return self.TargetTemperatureCelsius
end

CoolingRequirement.TargetTemperatureCelsius = TTargetTemperatureCelsius

---@class CoolingRequirement.ActiveInStandby
---@field ActiveInStandby boolean
local TActiveInStandby = {}
TActiveInStandby.__index = TActiveInStandby
TActiveInStandby.group = {}

local function TActiveInStandby_from_obj(obj)
    return setmetatable(obj, TActiveInStandby)
end

function TActiveInStandby.new(ActiveInStandby)
    return TActiveInStandby_from_obj({ActiveInStandby = ActiveInStandby or false})
end
---@param obj CoolingRequirement.ActiveInStandby
function TActiveInStandby:init_from_obj(obj)
    self.ActiveInStandby = obj.ActiveInStandby or false
end

function TActiveInStandby:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveInStandby.group)
end

TActiveInStandby.from_obj = TActiveInStandby_from_obj

TActiveInStandby.proto_property = {'ActiveInStandby'}

TActiveInStandby.default = {false}

TActiveInStandby.struct = {{name = 'ActiveInStandby', is_array = false, struct = nil}}

function TActiveInStandby:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveInStandby', self.ActiveInStandby, 'bool', true, errs, need_convert)

    TActiveInStandby:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveInStandby.proto_property, errs, need_convert)
    return self
end

function TActiveInStandby:unpack(_)
    return self.ActiveInStandby
end

CoolingRequirement.ActiveInStandby = TActiveInStandby

---@class CoolingRequirement.TemperatureType
---@field TemperatureType integer
local TTemperatureType = {}
TTemperatureType.__index = TTemperatureType
TTemperatureType.group = {}

local function TTemperatureType_from_obj(obj)
    return setmetatable(obj, TTemperatureType)
end

function TTemperatureType.new(TemperatureType)
    return TTemperatureType_from_obj({TemperatureType = TemperatureType or 4294967295})
end
---@param obj CoolingRequirement.TemperatureType
function TTemperatureType:init_from_obj(obj)
    self.TemperatureType = obj.TemperatureType or 4294967295
end

function TTemperatureType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureType.group)
end

TTemperatureType.from_obj = TTemperatureType_from_obj

TTemperatureType.proto_property = {'TemperatureType'}

TTemperatureType.default = {0}

TTemperatureType.struct = {{name = 'TemperatureType', is_array = false, struct = nil}}

function TTemperatureType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureType', self.TemperatureType, 'uint32', true, errs, need_convert)

    TTemperatureType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureType.proto_property, errs, need_convert)
    return self
end

function TTemperatureType:unpack(_)
    return self.TemperatureType
end

CoolingRequirement.TemperatureType = TTemperatureType

---@class CoolingRequirement.RequirementId
---@field RequirementId integer
local TRequirementId = {}
TRequirementId.__index = TRequirementId
TRequirementId.group = {}

local function TRequirementId_from_obj(obj)
    return setmetatable(obj, TRequirementId)
end

function TRequirementId.new(RequirementId)
    return TRequirementId_from_obj({RequirementId = RequirementId})
end
---@param obj CoolingRequirement.RequirementId
function TRequirementId:init_from_obj(obj)
    self.RequirementId = obj.RequirementId
end

function TRequirementId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRequirementId.group)
end

TRequirementId.from_obj = TRequirementId_from_obj

TRequirementId.proto_property = {'RequirementId'}

TRequirementId.default = {0}

TRequirementId.struct = {{name = 'RequirementId', is_array = false, struct = nil}}

function TRequirementId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'RequirementId', self.RequirementId, 'uint64', true, errs, need_convert)

    TRequirementId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRequirementId.proto_property, errs, need_convert)
    return self
end

function TRequirementId:unpack(_)
    return self.RequirementId
end

CoolingRequirement.RequirementId = TRequirementId

---@class CoolingRequirement.SetBackupTemperatureStatusRsp
local TSetBackupTemperatureStatusRsp = {}
TSetBackupTemperatureStatusRsp.__index = TSetBackupTemperatureStatusRsp
TSetBackupTemperatureStatusRsp.group = {}

local function TSetBackupTemperatureStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetBackupTemperatureStatusRsp)
end

function TSetBackupTemperatureStatusRsp.new()
    return TSetBackupTemperatureStatusRsp_from_obj({})
end
---@param obj CoolingRequirement.SetBackupTemperatureStatusRsp
function TSetBackupTemperatureStatusRsp:init_from_obj(obj)

end

function TSetBackupTemperatureStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBackupTemperatureStatusRsp.group)
end

TSetBackupTemperatureStatusRsp.from_obj = TSetBackupTemperatureStatusRsp_from_obj

TSetBackupTemperatureStatusRsp.proto_property = {}

TSetBackupTemperatureStatusRsp.default = {}

TSetBackupTemperatureStatusRsp.struct = {}

function TSetBackupTemperatureStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBackupTemperatureStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBackupTemperatureStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetBackupTemperatureStatusRsp:unpack(_)
end

CoolingRequirement.SetBackupTemperatureStatusRsp = TSetBackupTemperatureStatusRsp

---@class CoolingRequirement.SetBackupTemperatureStatusReq
---@field Status integer
local TSetBackupTemperatureStatusReq = {}
TSetBackupTemperatureStatusReq.__index = TSetBackupTemperatureStatusReq
TSetBackupTemperatureStatusReq.group = {}

local function TSetBackupTemperatureStatusReq_from_obj(obj)
    return setmetatable(obj, TSetBackupTemperatureStatusReq)
end

function TSetBackupTemperatureStatusReq.new(Status)
    return TSetBackupTemperatureStatusReq_from_obj({Status = Status})
end
---@param obj CoolingRequirement.SetBackupTemperatureStatusReq
function TSetBackupTemperatureStatusReq:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetBackupTemperatureStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBackupTemperatureStatusReq.group)
end

TSetBackupTemperatureStatusReq.from_obj = TSetBackupTemperatureStatusReq_from_obj

TSetBackupTemperatureStatusReq.proto_property = {'Status'}

TSetBackupTemperatureStatusReq.default = {0}

TSetBackupTemperatureStatusReq.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetBackupTemperatureStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetBackupTemperatureStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBackupTemperatureStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetBackupTemperatureStatusReq:unpack(_)
    return self.Status
end

CoolingRequirement.SetBackupTemperatureStatusReq = TSetBackupTemperatureStatusReq

---@class CoolingRequirement.SetBackupTemperatureCelsiusRsp
local TSetBackupTemperatureCelsiusRsp = {}
TSetBackupTemperatureCelsiusRsp.__index = TSetBackupTemperatureCelsiusRsp
TSetBackupTemperatureCelsiusRsp.group = {}

local function TSetBackupTemperatureCelsiusRsp_from_obj(obj)
    return setmetatable(obj, TSetBackupTemperatureCelsiusRsp)
end

function TSetBackupTemperatureCelsiusRsp.new()
    return TSetBackupTemperatureCelsiusRsp_from_obj({})
end
---@param obj CoolingRequirement.SetBackupTemperatureCelsiusRsp
function TSetBackupTemperatureCelsiusRsp:init_from_obj(obj)

end

function TSetBackupTemperatureCelsiusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBackupTemperatureCelsiusRsp.group)
end

TSetBackupTemperatureCelsiusRsp.from_obj = TSetBackupTemperatureCelsiusRsp_from_obj

TSetBackupTemperatureCelsiusRsp.proto_property = {}

TSetBackupTemperatureCelsiusRsp.default = {}

TSetBackupTemperatureCelsiusRsp.struct = {}

function TSetBackupTemperatureCelsiusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBackupTemperatureCelsiusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBackupTemperatureCelsiusRsp.proto_property, errs, need_convert)
    return self
end

function TSetBackupTemperatureCelsiusRsp:unpack(_)
end

CoolingRequirement.SetBackupTemperatureCelsiusRsp = TSetBackupTemperatureCelsiusRsp

---@class CoolingRequirement.SetBackupTemperatureCelsiusReq
---@field TemperatureCelsius number
local TSetBackupTemperatureCelsiusReq = {}
TSetBackupTemperatureCelsiusReq.__index = TSetBackupTemperatureCelsiusReq
TSetBackupTemperatureCelsiusReq.group = {}

local function TSetBackupTemperatureCelsiusReq_from_obj(obj)
    return setmetatable(obj, TSetBackupTemperatureCelsiusReq)
end

function TSetBackupTemperatureCelsiusReq.new(TemperatureCelsius)
    return TSetBackupTemperatureCelsiusReq_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj CoolingRequirement.SetBackupTemperatureCelsiusReq
function TSetBackupTemperatureCelsiusReq:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TSetBackupTemperatureCelsiusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBackupTemperatureCelsiusReq.group)
end

TSetBackupTemperatureCelsiusReq.from_obj = TSetBackupTemperatureCelsiusReq_from_obj

TSetBackupTemperatureCelsiusReq.proto_property = {'TemperatureCelsius'}

TSetBackupTemperatureCelsiusReq.default = {0}

TSetBackupTemperatureCelsiusReq.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TSetBackupTemperatureCelsiusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'double', false, errs, need_convert)

    TSetBackupTemperatureCelsiusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBackupTemperatureCelsiusReq.proto_property, errs, need_convert)
    return self
end

function TSetBackupTemperatureCelsiusReq:unpack(_)
    return self.TemperatureCelsius
end

CoolingRequirement.SetBackupTemperatureCelsiusReq = TSetBackupTemperatureCelsiusReq

---@class CoolingRequirement.SetFailedValueRsp
local TSetFailedValueRsp = {}
TSetFailedValueRsp.__index = TSetFailedValueRsp
TSetFailedValueRsp.group = {}

local function TSetFailedValueRsp_from_obj(obj)
    return setmetatable(obj, TSetFailedValueRsp)
end

function TSetFailedValueRsp.new()
    return TSetFailedValueRsp_from_obj({})
end
---@param obj CoolingRequirement.SetFailedValueRsp
function TSetFailedValueRsp:init_from_obj(obj)

end

function TSetFailedValueRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFailedValueRsp.group)
end

TSetFailedValueRsp.from_obj = TSetFailedValueRsp_from_obj

TSetFailedValueRsp.proto_property = {}

TSetFailedValueRsp.default = {}

TSetFailedValueRsp.struct = {}

function TSetFailedValueRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetFailedValueRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFailedValueRsp.proto_property, errs, need_convert)
    return self
end

function TSetFailedValueRsp:unpack(_)
end

CoolingRequirement.SetFailedValueRsp = TSetFailedValueRsp

---@class CoolingRequirement.SetFailedValueReq
---@field FailedValue integer
local TSetFailedValueReq = {}
TSetFailedValueReq.__index = TSetFailedValueReq
TSetFailedValueReq.group = {}

local function TSetFailedValueReq_from_obj(obj)
    return setmetatable(obj, TSetFailedValueReq)
end

function TSetFailedValueReq.new(FailedValue)
    return TSetFailedValueReq_from_obj({FailedValue = FailedValue})
end
---@param obj CoolingRequirement.SetFailedValueReq
function TSetFailedValueReq:init_from_obj(obj)
    self.FailedValue = obj.FailedValue
end

function TSetFailedValueReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFailedValueReq.group)
end

TSetFailedValueReq.from_obj = TSetFailedValueReq_from_obj

TSetFailedValueReq.proto_property = {'FailedValue'}

TSetFailedValueReq.default = {0}

TSetFailedValueReq.struct = {{name = 'FailedValue', is_array = false, struct = nil}}

function TSetFailedValueReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FailedValue', self.FailedValue, 'uint64', false, errs, need_convert)

    TSetFailedValueReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFailedValueReq.proto_property, errs, need_convert)
    return self
end

function TSetFailedValueReq:unpack(_)
    return self.FailedValue
end

CoolingRequirement.SetFailedValueReq = TSetFailedValueReq

---@class CoolingRequirement.SetMaxAllowedTemperatureRsp
local TSetMaxAllowedTemperatureRsp = {}
TSetMaxAllowedTemperatureRsp.__index = TSetMaxAllowedTemperatureRsp
TSetMaxAllowedTemperatureRsp.group = {}

local function TSetMaxAllowedTemperatureRsp_from_obj(obj)
    return setmetatable(obj, TSetMaxAllowedTemperatureRsp)
end

function TSetMaxAllowedTemperatureRsp.new()
    return TSetMaxAllowedTemperatureRsp_from_obj({})
end
---@param obj CoolingRequirement.SetMaxAllowedTemperatureRsp
function TSetMaxAllowedTemperatureRsp:init_from_obj(obj)

end

function TSetMaxAllowedTemperatureRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMaxAllowedTemperatureRsp.group)
end

TSetMaxAllowedTemperatureRsp.from_obj = TSetMaxAllowedTemperatureRsp_from_obj

TSetMaxAllowedTemperatureRsp.proto_property = {}

TSetMaxAllowedTemperatureRsp.default = {}

TSetMaxAllowedTemperatureRsp.struct = {}

function TSetMaxAllowedTemperatureRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetMaxAllowedTemperatureRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMaxAllowedTemperatureRsp.proto_property, errs, need_convert)
    return self
end

function TSetMaxAllowedTemperatureRsp:unpack(_)
end

CoolingRequirement.SetMaxAllowedTemperatureRsp = TSetMaxAllowedTemperatureRsp

---@class CoolingRequirement.SetMaxAllowedTemperatureReq
---@field MaxAllowedTemperature integer
local TSetMaxAllowedTemperatureReq = {}
TSetMaxAllowedTemperatureReq.__index = TSetMaxAllowedTemperatureReq
TSetMaxAllowedTemperatureReq.group = {}

local function TSetMaxAllowedTemperatureReq_from_obj(obj)
    return setmetatable(obj, TSetMaxAllowedTemperatureReq)
end

function TSetMaxAllowedTemperatureReq.new(MaxAllowedTemperature)
    return TSetMaxAllowedTemperatureReq_from_obj({MaxAllowedTemperature = MaxAllowedTemperature})
end
---@param obj CoolingRequirement.SetMaxAllowedTemperatureReq
function TSetMaxAllowedTemperatureReq:init_from_obj(obj)
    self.MaxAllowedTemperature = obj.MaxAllowedTemperature
end

function TSetMaxAllowedTemperatureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMaxAllowedTemperatureReq.group)
end

TSetMaxAllowedTemperatureReq.from_obj = TSetMaxAllowedTemperatureReq_from_obj

TSetMaxAllowedTemperatureReq.proto_property = {'MaxAllowedTemperature'}

TSetMaxAllowedTemperatureReq.default = {0}

TSetMaxAllowedTemperatureReq.struct = {{name = 'MaxAllowedTemperature', is_array = false, struct = nil}}

function TSetMaxAllowedTemperatureReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxAllowedTemperature', self.MaxAllowedTemperature, 'uint8', false, errs, need_convert)

    TSetMaxAllowedTemperatureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMaxAllowedTemperatureReq.proto_property, errs, need_convert)
    return self
end

function TSetMaxAllowedTemperatureReq:unpack(_)
    return self.MaxAllowedTemperature
end

CoolingRequirement.SetMaxAllowedTemperatureReq = TSetMaxAllowedTemperatureReq

---@class CoolingRequirement.SetBasicCoolingTargetTemperatureRsp
local TSetBasicCoolingTargetTemperatureRsp = {}
TSetBasicCoolingTargetTemperatureRsp.__index = TSetBasicCoolingTargetTemperatureRsp
TSetBasicCoolingTargetTemperatureRsp.group = {}

local function TSetBasicCoolingTargetTemperatureRsp_from_obj(obj)
    return setmetatable(obj, TSetBasicCoolingTargetTemperatureRsp)
end

function TSetBasicCoolingTargetTemperatureRsp.new()
    return TSetBasicCoolingTargetTemperatureRsp_from_obj({})
end
---@param obj CoolingRequirement.SetBasicCoolingTargetTemperatureRsp
function TSetBasicCoolingTargetTemperatureRsp:init_from_obj(obj)

end

function TSetBasicCoolingTargetTemperatureRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBasicCoolingTargetTemperatureRsp.group)
end

TSetBasicCoolingTargetTemperatureRsp.from_obj = TSetBasicCoolingTargetTemperatureRsp_from_obj

TSetBasicCoolingTargetTemperatureRsp.proto_property = {}

TSetBasicCoolingTargetTemperatureRsp.default = {}

TSetBasicCoolingTargetTemperatureRsp.struct = {}

function TSetBasicCoolingTargetTemperatureRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBasicCoolingTargetTemperatureRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBasicCoolingTargetTemperatureRsp.proto_property, errs, need_convert)
    return self
end

function TSetBasicCoolingTargetTemperatureRsp:unpack(_)
end

CoolingRequirement.SetBasicCoolingTargetTemperatureRsp = TSetBasicCoolingTargetTemperatureRsp

---@class CoolingRequirement.SetBasicCoolingTargetTemperatureReq
---@field BasicCoolingTargetTemperature integer
local TSetBasicCoolingTargetTemperatureReq = {}
TSetBasicCoolingTargetTemperatureReq.__index = TSetBasicCoolingTargetTemperatureReq
TSetBasicCoolingTargetTemperatureReq.group = {}

local function TSetBasicCoolingTargetTemperatureReq_from_obj(obj)
    return setmetatable(obj, TSetBasicCoolingTargetTemperatureReq)
end

function TSetBasicCoolingTargetTemperatureReq.new(BasicCoolingTargetTemperature)
    return
        TSetBasicCoolingTargetTemperatureReq_from_obj({BasicCoolingTargetTemperature = BasicCoolingTargetTemperature})
end
---@param obj CoolingRequirement.SetBasicCoolingTargetTemperatureReq
function TSetBasicCoolingTargetTemperatureReq:init_from_obj(obj)
    self.BasicCoolingTargetTemperature = obj.BasicCoolingTargetTemperature
end

function TSetBasicCoolingTargetTemperatureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBasicCoolingTargetTemperatureReq.group)
end

TSetBasicCoolingTargetTemperatureReq.from_obj = TSetBasicCoolingTargetTemperatureReq_from_obj

TSetBasicCoolingTargetTemperatureReq.proto_property = {'BasicCoolingTargetTemperature'}

TSetBasicCoolingTargetTemperatureReq.default = {0}

TSetBasicCoolingTargetTemperatureReq.struct = {{name = 'BasicCoolingTargetTemperature', is_array = false, struct = nil}}

function TSetBasicCoolingTargetTemperatureReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BasicCoolingTargetTemperature', self.BasicCoolingTargetTemperature, 'uint8', false,
        errs, need_convert)

    TSetBasicCoolingTargetTemperatureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBasicCoolingTargetTemperatureReq.proto_property, errs, need_convert)
    return self
end

function TSetBasicCoolingTargetTemperatureReq:unpack(_)
    return self.BasicCoolingTargetTemperature
end

CoolingRequirement.SetBasicCoolingTargetTemperatureReq = TSetBasicCoolingTargetTemperatureReq

---@class CoolingRequirement.SetSmartCoolingTargetTemperatureRsp
local TSetSmartCoolingTargetTemperatureRsp = {}
TSetSmartCoolingTargetTemperatureRsp.__index = TSetSmartCoolingTargetTemperatureRsp
TSetSmartCoolingTargetTemperatureRsp.group = {}

local function TSetSmartCoolingTargetTemperatureRsp_from_obj(obj)
    return setmetatable(obj, TSetSmartCoolingTargetTemperatureRsp)
end

function TSetSmartCoolingTargetTemperatureRsp.new()
    return TSetSmartCoolingTargetTemperatureRsp_from_obj({})
end
---@param obj CoolingRequirement.SetSmartCoolingTargetTemperatureRsp
function TSetSmartCoolingTargetTemperatureRsp:init_from_obj(obj)

end

function TSetSmartCoolingTargetTemperatureRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmartCoolingTargetTemperatureRsp.group)
end

TSetSmartCoolingTargetTemperatureRsp.from_obj = TSetSmartCoolingTargetTemperatureRsp_from_obj

TSetSmartCoolingTargetTemperatureRsp.proto_property = {}

TSetSmartCoolingTargetTemperatureRsp.default = {}

TSetSmartCoolingTargetTemperatureRsp.struct = {}

function TSetSmartCoolingTargetTemperatureRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSmartCoolingTargetTemperatureRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmartCoolingTargetTemperatureRsp.proto_property, errs, need_convert)
    return self
end

function TSetSmartCoolingTargetTemperatureRsp:unpack(_)
end

CoolingRequirement.SetSmartCoolingTargetTemperatureRsp = TSetSmartCoolingTargetTemperatureRsp

---@class CoolingRequirement.SetSmartCoolingTargetTemperatureReq
---@field SmartCoolingTargetTemperature integer[]
local TSetSmartCoolingTargetTemperatureReq = {}
TSetSmartCoolingTargetTemperatureReq.__index = TSetSmartCoolingTargetTemperatureReq
TSetSmartCoolingTargetTemperatureReq.group = {}

local function TSetSmartCoolingTargetTemperatureReq_from_obj(obj)
    return setmetatable(obj, TSetSmartCoolingTargetTemperatureReq)
end

function TSetSmartCoolingTargetTemperatureReq.new(SmartCoolingTargetTemperature)
    return
        TSetSmartCoolingTargetTemperatureReq_from_obj({SmartCoolingTargetTemperature = SmartCoolingTargetTemperature})
end
---@param obj CoolingRequirement.SetSmartCoolingTargetTemperatureReq
function TSetSmartCoolingTargetTemperatureReq:init_from_obj(obj)
    self.SmartCoolingTargetTemperature = obj.SmartCoolingTargetTemperature
end

function TSetSmartCoolingTargetTemperatureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmartCoolingTargetTemperatureReq.group)
end

TSetSmartCoolingTargetTemperatureReq.from_obj = TSetSmartCoolingTargetTemperatureReq_from_obj

TSetSmartCoolingTargetTemperatureReq.proto_property = {'SmartCoolingTargetTemperature'}

TSetSmartCoolingTargetTemperatureReq.default = {{}}

TSetSmartCoolingTargetTemperatureReq.struct = {{name = 'SmartCoolingTargetTemperature', is_array = true, struct = nil}}

function TSetSmartCoolingTargetTemperatureReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SmartCoolingTargetTemperature', self.SmartCoolingTargetTemperature, 'int16',
        false, errs, need_convert)

    TSetSmartCoolingTargetTemperatureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmartCoolingTargetTemperatureReq.proto_property, errs, need_convert)
    return self
end

function TSetSmartCoolingTargetTemperatureReq:unpack(_)
    return self.SmartCoolingTargetTemperature
end

CoolingRequirement.SetSmartCoolingTargetTemperatureReq = TSetSmartCoolingTargetTemperatureReq

---@class CoolingRequirement.SetTargetTemperatureRsp
local TSetTargetTemperatureRsp = {}
TSetTargetTemperatureRsp.__index = TSetTargetTemperatureRsp
TSetTargetTemperatureRsp.group = {}

local function TSetTargetTemperatureRsp_from_obj(obj)
    return setmetatable(obj, TSetTargetTemperatureRsp)
end

function TSetTargetTemperatureRsp.new()
    return TSetTargetTemperatureRsp_from_obj({})
end
---@param obj CoolingRequirement.SetTargetTemperatureRsp
function TSetTargetTemperatureRsp:init_from_obj(obj)

end

function TSetTargetTemperatureRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTargetTemperatureRsp.group)
end

TSetTargetTemperatureRsp.from_obj = TSetTargetTemperatureRsp_from_obj

TSetTargetTemperatureRsp.proto_property = {}

TSetTargetTemperatureRsp.default = {}

TSetTargetTemperatureRsp.struct = {}

function TSetTargetTemperatureRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetTargetTemperatureRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTargetTemperatureRsp.proto_property, errs, need_convert)
    return self
end

function TSetTargetTemperatureRsp:unpack(_)
end

CoolingRequirement.SetTargetTemperatureRsp = TSetTargetTemperatureRsp

---@class CoolingRequirement.SetTargetTemperatureReq
---@field TemperatureCelsius integer
local TSetTargetTemperatureReq = {}
TSetTargetTemperatureReq.__index = TSetTargetTemperatureReq
TSetTargetTemperatureReq.group = {}

local function TSetTargetTemperatureReq_from_obj(obj)
    return setmetatable(obj, TSetTargetTemperatureReq)
end

function TSetTargetTemperatureReq.new(TemperatureCelsius)
    return TSetTargetTemperatureReq_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj CoolingRequirement.SetTargetTemperatureReq
function TSetTargetTemperatureReq:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TSetTargetTemperatureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTargetTemperatureReq.group)
end

TSetTargetTemperatureReq.from_obj = TSetTargetTemperatureReq_from_obj

TSetTargetTemperatureReq.proto_property = {'TemperatureCelsius'}

TSetTargetTemperatureReq.default = {0}

TSetTargetTemperatureReq.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TSetTargetTemperatureReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'uint8', false, errs, need_convert)

    TSetTargetTemperatureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTargetTemperatureReq.proto_property, errs, need_convert)
    return self
end

function TSetTargetTemperatureReq:unpack(_)
    return self.TemperatureCelsius
end

CoolingRequirement.SetTargetTemperatureReq = TSetTargetTemperatureReq

CoolingRequirement.interface = mdb.register_interface('bmc.kepler.Systems.CoolingRequirement', {
    RequirementId = {'t', {'CONST'}, true, nil},
    TemperatureType = {'u', {'CONST'}, true, 4294967295},
    ActiveInStandby = {'b', {'CONST'}, true, false},
    TargetTemperatureCelsius = {'y', {}, true, 127},
    MaxAllowedTemperatureCelsius = {'y', {'CONST'}, true, nil},
    CustomSupported = {'b', {}, true, nil},
    CustomTargetTemperatureCelsius = {'y', {}, true, 255},
    TargetTemperatureRangeCelsius = {'ay', {'CONST'}, true, nil},
    MonitoringStatus = {'y', nil, true, nil},
    MonitoringValue = {'d', {'VOLATILE'}, true, nil},
    FailedValue = {'t', {}, true, nil},
    ThresholdValue = {'ay', {'CONST'}, true, nil},
    AlarmSpeed = {'ay', {'CONST'}, true, nil},
    SmartCoolingTargetTemperatureCelsius = {'an', {'EMIT_CHANGE'}, false, nil},
    SensorName = {'s', {}, true, nil}
}, {
    SetTargetTemperature = {'a{ss}y', '', TSetTargetTemperatureReq, TSetTargetTemperatureRsp},
    SetSmartCoolingTargetTemperature = {
        'a{ss}an', '', TSetSmartCoolingTargetTemperatureReq, TSetSmartCoolingTargetTemperatureRsp
    },
    SetBasicCoolingTargetTemperature = {
        'a{ss}y', '', TSetBasicCoolingTargetTemperatureReq, TSetBasicCoolingTargetTemperatureRsp
    },
    SetMaxAllowedTemperature = {'a{ss}y', '', TSetMaxAllowedTemperatureReq, TSetMaxAllowedTemperatureRsp},
    SetFailedValue = {'a{ss}t', '', TSetFailedValueReq, TSetFailedValueRsp},
    SetBackupTemperatureCelsius = {'a{ss}d', '', TSetBackupTemperatureCelsiusReq, TSetBackupTemperatureCelsiusRsp},
    SetBackupTemperatureStatus = {'a{ss}y', '', TSetBackupTemperatureStatusReq, TSetBackupTemperatureStatusRsp}
}, {})

return CoolingRequirement
