-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CoolingPump = {}

---@class CoolingPump.Level
---@field Level integer
local TLevel = {}
TLevel.__index = TLevel
TLevel.group = {}

local function TLevel_from_obj(obj)
    return setmetatable(obj, TLevel)
end

function TLevel.new(Level)
    return TLevel_from_obj({Level = Level})
end
---@param obj CoolingPump.Level
function TLevel:init_from_obj(obj)
    self.Level = obj.Level
end

function TLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLevel.group)
end

TLevel.from_obj = TLevel_from_obj

TLevel.proto_property = {'Level'}

TLevel.default = {0}

TLevel.struct = {{name = 'Level', is_array = false, struct = nil}}

function TLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Level', self.Level, 'uint8', true, errs, need_convert)

    TLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLevel.proto_property, errs, need_convert)
    return self
end

function TLevel:unpack(_)
    return self.Level
end

CoolingPump.Level = TLevel

---@class CoolingPump.Status
---@field Status integer
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status or 0})
end
---@param obj CoolingPump.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status or 0
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {0}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

CoolingPump.Status = TStatus

---@class CoolingPump.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence or 1})
end
---@param obj CoolingPump.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence or 1
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

CoolingPump.Presence = TPresence

---@class CoolingPump.Speed
---@field Speed integer
local TSpeed = {}
TSpeed.__index = TSpeed
TSpeed.group = {}

local function TSpeed_from_obj(obj)
    return setmetatable(obj, TSpeed)
end

function TSpeed.new(Speed)
    return TSpeed_from_obj({Speed = Speed})
end
---@param obj CoolingPump.Speed
function TSpeed:init_from_obj(obj)
    self.Speed = obj.Speed
end

function TSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeed.group)
end

TSpeed.from_obj = TSpeed_from_obj

TSpeed.proto_property = {'Speed'}

TSpeed.default = {0}

TSpeed.struct = {{name = 'Speed', is_array = false, struct = nil}}

function TSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Speed', self.Speed, 'uint16', true, errs, need_convert)

    TSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeed.proto_property, errs, need_convert)
    return self
end

function TSpeed:unpack(_)
    return self.Speed
end

CoolingPump.Speed = TSpeed

---@class CoolingPump.ActualPWM
---@field ActualPWM number
local TActualPWM = {}
TActualPWM.__index = TActualPWM
TActualPWM.group = {}

local function TActualPWM_from_obj(obj)
    return setmetatable(obj, TActualPWM)
end

function TActualPWM.new(ActualPWM)
    return TActualPWM_from_obj({ActualPWM = ActualPWM})
end
---@param obj CoolingPump.ActualPWM
function TActualPWM:init_from_obj(obj)
    self.ActualPWM = obj.ActualPWM
end

function TActualPWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActualPWM.group)
end

TActualPWM.from_obj = TActualPWM_from_obj

TActualPWM.proto_property = {'ActualPWM'}

TActualPWM.default = {0}

TActualPWM.struct = {{name = 'ActualPWM', is_array = false, struct = nil}}

function TActualPWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActualPWM', self.ActualPWM, 'double', true, errs, need_convert)

    TActualPWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActualPWM.proto_property, errs, need_convert)
    return self
end

function TActualPWM:unpack(_)
    return self.ActualPWM
end

CoolingPump.ActualPWM = TActualPWM

---@class CoolingPump.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj CoolingPump.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', true, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

CoolingPump.Slot = TSlot

---@class CoolingPump.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj CoolingPump.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint16', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

CoolingPump.Id = TId

CoolingPump.interface = mdb.register_interface('bmc.kepler.Systems.CoolingPump', {
    Id = {'q', {'CONST'}, true, nil},
    Slot = {'y', {'CONST'}, true, nil},
    ActualPWM = {'d', {}, true, nil},
    Speed = {'q', {'VOLATILE'}, true, nil},
    Presence = {'y', {}, true, 1},
    Status = {'y', {}, true, 0},
    Level = {'y', {}, true, nil}
}, {}, {})

return CoolingPump
