-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CoolingConfig = {}

---@class CoolingConfig.MixedModeSupported
---@field MixedModeSupported boolean
local TMixedModeSupported = {}
TMixedModeSupported.__index = TMixedModeSupported
TMixedModeSupported.group = {}

local function TMixedModeSupported_from_obj(obj)
    return setmetatable(obj, TMixedModeSupported)
end

function TMixedModeSupported.new(MixedModeSupported)
    return TMixedModeSupported_from_obj({MixedModeSupported = MixedModeSupported or false})
end
---@param obj CoolingConfig.MixedModeSupported
function TMixedModeSupported:init_from_obj(obj)
    self.MixedModeSupported = obj.MixedModeSupported or false
end

function TMixedModeSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMixedModeSupported.group)
end

TMixedModeSupported.from_obj = TMixedModeSupported_from_obj

TMixedModeSupported.proto_property = {'MixedModeSupported'}

TMixedModeSupported.default = {false}

TMixedModeSupported.struct = {{name = 'MixedModeSupported', is_array = false, struct = nil}}

function TMixedModeSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MixedModeSupported', self.MixedModeSupported, 'bool', true, errs, need_convert)

    TMixedModeSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMixedModeSupported.proto_property, errs, need_convert)
    return self
end

function TMixedModeSupported:unpack(_)
    return self.MixedModeSupported
end

CoolingConfig.MixedModeSupported = TMixedModeSupported

---@class CoolingConfig.MinAllowedFanSpeedEnabled
---@field MinAllowedFanSpeedEnabled boolean
local TMinAllowedFanSpeedEnabled = {}
TMinAllowedFanSpeedEnabled.__index = TMinAllowedFanSpeedEnabled
TMinAllowedFanSpeedEnabled.group = {}

local function TMinAllowedFanSpeedEnabled_from_obj(obj)
    return setmetatable(obj, TMinAllowedFanSpeedEnabled)
end

function TMinAllowedFanSpeedEnabled.new(MinAllowedFanSpeedEnabled)
    return TMinAllowedFanSpeedEnabled_from_obj({MinAllowedFanSpeedEnabled = MinAllowedFanSpeedEnabled or false})
end
---@param obj CoolingConfig.MinAllowedFanSpeedEnabled
function TMinAllowedFanSpeedEnabled:init_from_obj(obj)
    self.MinAllowedFanSpeedEnabled = obj.MinAllowedFanSpeedEnabled or false
end

function TMinAllowedFanSpeedEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinAllowedFanSpeedEnabled.group)
end

TMinAllowedFanSpeedEnabled.from_obj = TMinAllowedFanSpeedEnabled_from_obj

TMinAllowedFanSpeedEnabled.proto_property = {'MinAllowedFanSpeedEnabled'}

TMinAllowedFanSpeedEnabled.default = {false}

TMinAllowedFanSpeedEnabled.struct = {{name = 'MinAllowedFanSpeedEnabled', is_array = false, struct = nil}}

function TMinAllowedFanSpeedEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinAllowedFanSpeedEnabled', self.MinAllowedFanSpeedEnabled, 'bool', true, errs,
        need_convert)

    TMinAllowedFanSpeedEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinAllowedFanSpeedEnabled.proto_property, errs, need_convert)
    return self
end

function TMinAllowedFanSpeedEnabled:unpack(_)
    return self.MinAllowedFanSpeedEnabled
end

CoolingConfig.MinAllowedFanSpeedEnabled = TMinAllowedFanSpeedEnabled

---@class CoolingConfig.MinAllowedFanSpeedPercent
---@field MinAllowedFanSpeedPercent integer
local TMinAllowedFanSpeedPercent = {}
TMinAllowedFanSpeedPercent.__index = TMinAllowedFanSpeedPercent
TMinAllowedFanSpeedPercent.group = {}

local function TMinAllowedFanSpeedPercent_from_obj(obj)
    return setmetatable(obj, TMinAllowedFanSpeedPercent)
end

function TMinAllowedFanSpeedPercent.new(MinAllowedFanSpeedPercent)
    return TMinAllowedFanSpeedPercent_from_obj({MinAllowedFanSpeedPercent = MinAllowedFanSpeedPercent or 255})
end
---@param obj CoolingConfig.MinAllowedFanSpeedPercent
function TMinAllowedFanSpeedPercent:init_from_obj(obj)
    self.MinAllowedFanSpeedPercent = obj.MinAllowedFanSpeedPercent or 255
end

function TMinAllowedFanSpeedPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinAllowedFanSpeedPercent.group)
end

TMinAllowedFanSpeedPercent.from_obj = TMinAllowedFanSpeedPercent_from_obj

TMinAllowedFanSpeedPercent.proto_property = {'MinAllowedFanSpeedPercent'}

TMinAllowedFanSpeedPercent.default = {0}

TMinAllowedFanSpeedPercent.struct = {{name = 'MinAllowedFanSpeedPercent', is_array = false, struct = nil}}

function TMinAllowedFanSpeedPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinAllowedFanSpeedPercent', self.MinAllowedFanSpeedPercent, 'uint8', false, errs,
        need_convert)

    TMinAllowedFanSpeedPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinAllowedFanSpeedPercent.proto_property, errs, need_convert)
    return self
end

function TMinAllowedFanSpeedPercent:unpack(_)
    return self.MinAllowedFanSpeedPercent
end

CoolingConfig.MinAllowedFanSpeedPercent = TMinAllowedFanSpeedPercent

---@class CoolingConfig.SensorLocationSupported
---@field SensorLocationSupported boolean
local TSensorLocationSupported = {}
TSensorLocationSupported.__index = TSensorLocationSupported
TSensorLocationSupported.group = {}

local function TSensorLocationSupported_from_obj(obj)
    return setmetatable(obj, TSensorLocationSupported)
end

function TSensorLocationSupported.new(SensorLocationSupported)
    return TSensorLocationSupported_from_obj({SensorLocationSupported = SensorLocationSupported or false})
end
---@param obj CoolingConfig.SensorLocationSupported
function TSensorLocationSupported:init_from_obj(obj)
    self.SensorLocationSupported = obj.SensorLocationSupported or false
end

function TSensorLocationSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorLocationSupported.group)
end

TSensorLocationSupported.from_obj = TSensorLocationSupported_from_obj

TSensorLocationSupported.proto_property = {'SensorLocationSupported'}

TSensorLocationSupported.default = {false}

TSensorLocationSupported.struct = {{name = 'SensorLocationSupported', is_array = false, struct = nil}}

function TSensorLocationSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorLocationSupported', self.SensorLocationSupported, 'bool', true, errs,
        need_convert)

    TSensorLocationSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorLocationSupported.proto_property, errs, need_convert)
    return self
end

function TSensorLocationSupported:unpack(_)
    return self.SensorLocationSupported
end

CoolingConfig.SensorLocationSupported = TSensorLocationSupported

---@class CoolingConfig.LevelPercentRange
---@field LevelPercentRange integer[]
local TLevelPercentRange = {}
TLevelPercentRange.__index = TLevelPercentRange
TLevelPercentRange.group = {}

local function TLevelPercentRange_from_obj(obj)
    return setmetatable(obj, TLevelPercentRange)
end

function TLevelPercentRange.new(LevelPercentRange)
    return TLevelPercentRange_from_obj({LevelPercentRange = LevelPercentRange})
end
---@param obj CoolingConfig.LevelPercentRange
function TLevelPercentRange:init_from_obj(obj)
    self.LevelPercentRange = obj.LevelPercentRange
end

function TLevelPercentRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLevelPercentRange.group)
end

TLevelPercentRange.from_obj = TLevelPercentRange_from_obj

TLevelPercentRange.proto_property = {'LevelPercentRange'}

TLevelPercentRange.default = {{}}

TLevelPercentRange.struct = {{name = 'LevelPercentRange', is_array = true, struct = nil}}

function TLevelPercentRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LevelPercentRange', self.LevelPercentRange, 'uint8', true, errs, need_convert)

    TLevelPercentRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLevelPercentRange.proto_property, errs, need_convert)
    return self
end

function TLevelPercentRange:unpack(_)
    return self.LevelPercentRange
end

CoolingConfig.LevelPercentRange = TLevelPercentRange

---@class CoolingConfig.ManualLevel
---@field ManualLevel integer
local TManualLevel = {}
TManualLevel.__index = TManualLevel
TManualLevel.group = {}

local function TManualLevel_from_obj(obj)
    return setmetatable(obj, TManualLevel)
end

function TManualLevel.new(ManualLevel)
    return TManualLevel_from_obj({ManualLevel = ManualLevel or 10})
end
---@param obj CoolingConfig.ManualLevel
function TManualLevel:init_from_obj(obj)
    self.ManualLevel = obj.ManualLevel or 10
end

function TManualLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManualLevel.group)
end

TManualLevel.from_obj = TManualLevel_from_obj

TManualLevel.proto_property = {'ManualLevel'}

TManualLevel.default = {0}

TManualLevel.struct = {{name = 'ManualLevel', is_array = false, struct = nil}}

function TManualLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManualLevel', self.ManualLevel, 'uint8', true, errs, need_convert)

    TManualLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManualLevel.proto_property, errs, need_convert)
    return self
end

function TManualLevel:unpack(_)
    return self.ManualLevel
end

CoolingConfig.ManualLevel = TManualLevel

---@class CoolingConfig.TimeOut
---@field TimeOut integer
local TTimeOut = {}
TTimeOut.__index = TTimeOut
TTimeOut.group = {}

local function TTimeOut_from_obj(obj)
    return setmetatable(obj, TTimeOut)
end

function TTimeOut.new(TimeOut)
    return TTimeOut_from_obj({TimeOut = TimeOut or 30})
end
---@param obj CoolingConfig.TimeOut
function TTimeOut:init_from_obj(obj)
    self.TimeOut = obj.TimeOut or 30
end

function TTimeOut:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeOut.group)
end

TTimeOut.from_obj = TTimeOut_from_obj

TTimeOut.proto_property = {'TimeOut'}

TTimeOut.default = {0}

TTimeOut.struct = {{name = 'TimeOut', is_array = false, struct = nil}}

function TTimeOut:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeOut', self.TimeOut, 'uint32', true, errs, need_convert)

    TTimeOut:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeOut.proto_property, errs, need_convert)
    return self
end

function TTimeOut:unpack(_)
    return self.TimeOut
end

CoolingConfig.TimeOut = TTimeOut

---@class CoolingConfig.CtrlMode
---@field CtrlMode string
local TCtrlMode = {}
TCtrlMode.__index = TCtrlMode
TCtrlMode.group = {}

local function TCtrlMode_from_obj(obj)
    return setmetatable(obj, TCtrlMode)
end

function TCtrlMode.new(CtrlMode)
    return TCtrlMode_from_obj({CtrlMode = CtrlMode or [=[Auto]=]})
end
---@param obj CoolingConfig.CtrlMode
function TCtrlMode:init_from_obj(obj)
    self.CtrlMode = obj.CtrlMode or [=[Auto]=]
end

function TCtrlMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlMode.group)
end

TCtrlMode.from_obj = TCtrlMode_from_obj

TCtrlMode.proto_property = {'CtrlMode'}

TCtrlMode.default = {''}

TCtrlMode.struct = {{name = 'CtrlMode', is_array = false, struct = nil}}

function TCtrlMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlMode', self.CtrlMode, 'string', true, errs, need_convert)

    if self.CtrlMode ~= nil then
        validate.Enum(prefix .. 'CtrlMode', self.CtrlMode, '', {'Auto', 'Manual', 'Mixed'}, errs, need_convert)
    end

    TCtrlMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlMode.proto_property, errs, need_convert)
    return self
end

function TCtrlMode:unpack(_)
    return self.CtrlMode
end

CoolingConfig.CtrlMode = TCtrlMode

---@class CoolingConfig.Medium
---@field Medium string
local TMedium = {}
TMedium.__index = TMedium
TMedium.group = {}

local function TMedium_from_obj(obj)
    return setmetatable(obj, TMedium)
end

function TMedium.new(Medium)
    return TMedium_from_obj({Medium = Medium or [=[Air]=]})
end
---@param obj CoolingConfig.Medium
function TMedium:init_from_obj(obj)
    self.Medium = obj.Medium or [=[Air]=]
end

function TMedium:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMedium.group)
end

TMedium.from_obj = TMedium_from_obj

TMedium.proto_property = {'Medium'}

TMedium.default = {''}

TMedium.struct = {{name = 'Medium', is_array = false, struct = nil}}

function TMedium:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Medium', self.Medium, 'string', true, errs, need_convert)

    if self.Medium ~= nil then
        validate.Enum(prefix .. 'Medium', self.Medium, '', {'Air', 'Liquid', 'Air/Liquid'}, errs, need_convert)
    end

    TMedium:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMedium.proto_property, errs, need_convert)
    return self
end

function TMedium:unpack(_)
    return self.Medium
end

CoolingConfig.Medium = TMedium

---@class CoolingConfig.SmartCoolingMode
---@field SmartCoolingMode string
local TSmartCoolingMode = {}
TSmartCoolingMode.__index = TSmartCoolingMode
TSmartCoolingMode.group = {}

local function TSmartCoolingMode_from_obj(obj)
    return setmetatable(obj, TSmartCoolingMode)
end

function TSmartCoolingMode.new(SmartCoolingMode)
    return TSmartCoolingMode_from_obj({SmartCoolingMode = SmartCoolingMode or [=[EnergySaving]=]})
end
---@param obj CoolingConfig.SmartCoolingMode
function TSmartCoolingMode:init_from_obj(obj)
    self.SmartCoolingMode = obj.SmartCoolingMode or [=[EnergySaving]=]
end

function TSmartCoolingMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmartCoolingMode.group)
end

TSmartCoolingMode.from_obj = TSmartCoolingMode_from_obj

TSmartCoolingMode.proto_property = {'SmartCoolingMode'}

TSmartCoolingMode.default = {''}

TSmartCoolingMode.struct = {{name = 'SmartCoolingMode', is_array = false, struct = nil}}

function TSmartCoolingMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SmartCoolingMode', self.SmartCoolingMode, 'string', true, errs, need_convert)

    TSmartCoolingMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmartCoolingMode.proto_property, errs, need_convert)
    return self
end

function TSmartCoolingMode:unpack(_)
    return self.SmartCoolingMode
end

CoolingConfig.SmartCoolingMode = TSmartCoolingMode

---@class CoolingConfig.SmartCoolingState
---@field SmartCoolingState string
local TSmartCoolingState = {}
TSmartCoolingState.__index = TSmartCoolingState
TSmartCoolingState.group = {}

local function TSmartCoolingState_from_obj(obj)
    return setmetatable(obj, TSmartCoolingState)
end

function TSmartCoolingState.new(SmartCoolingState)
    return TSmartCoolingState_from_obj({SmartCoolingState = SmartCoolingState or [=[Enabled]=]})
end
---@param obj CoolingConfig.SmartCoolingState
function TSmartCoolingState:init_from_obj(obj)
    self.SmartCoolingState = obj.SmartCoolingState or [=[Enabled]=]
end

function TSmartCoolingState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmartCoolingState.group)
end

TSmartCoolingState.from_obj = TSmartCoolingState_from_obj

TSmartCoolingState.proto_property = {'SmartCoolingState'}

TSmartCoolingState.default = {''}

TSmartCoolingState.struct = {{name = 'SmartCoolingState', is_array = false, struct = nil}}

function TSmartCoolingState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SmartCoolingState', self.SmartCoolingState, 'string', true, errs, need_convert)

    if self.SmartCoolingState ~= nil then
        validate.Enum(prefix .. 'SmartCoolingState', self.SmartCoolingState, '', {'Enabled', 'Disabled'}, errs,
            need_convert)
    end

    TSmartCoolingState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmartCoolingState.proto_property, errs, need_convert)
    return self
end

function TSmartCoolingState:unpack(_)
    return self.SmartCoolingState
end

CoolingConfig.SmartCoolingState = TSmartCoolingState

---@class CoolingConfig.SetMinAllowedFanSpeedEnabledRsp
local TSetMinAllowedFanSpeedEnabledRsp = {}
TSetMinAllowedFanSpeedEnabledRsp.__index = TSetMinAllowedFanSpeedEnabledRsp
TSetMinAllowedFanSpeedEnabledRsp.group = {}

local function TSetMinAllowedFanSpeedEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetMinAllowedFanSpeedEnabledRsp)
end

function TSetMinAllowedFanSpeedEnabledRsp.new()
    return TSetMinAllowedFanSpeedEnabledRsp_from_obj({})
end
---@param obj CoolingConfig.SetMinAllowedFanSpeedEnabledRsp
function TSetMinAllowedFanSpeedEnabledRsp:init_from_obj(obj)

end

function TSetMinAllowedFanSpeedEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMinAllowedFanSpeedEnabledRsp.group)
end

TSetMinAllowedFanSpeedEnabledRsp.from_obj = TSetMinAllowedFanSpeedEnabledRsp_from_obj

TSetMinAllowedFanSpeedEnabledRsp.proto_property = {}

TSetMinAllowedFanSpeedEnabledRsp.default = {}

TSetMinAllowedFanSpeedEnabledRsp.struct = {}

function TSetMinAllowedFanSpeedEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetMinAllowedFanSpeedEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMinAllowedFanSpeedEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TSetMinAllowedFanSpeedEnabledRsp:unpack(_)
end

CoolingConfig.SetMinAllowedFanSpeedEnabledRsp = TSetMinAllowedFanSpeedEnabledRsp

---@class CoolingConfig.SetMinAllowedFanSpeedEnabledReq
---@field MinAllowedFanSpeedEnabled boolean
local TSetMinAllowedFanSpeedEnabledReq = {}
TSetMinAllowedFanSpeedEnabledReq.__index = TSetMinAllowedFanSpeedEnabledReq
TSetMinAllowedFanSpeedEnabledReq.group = {}

local function TSetMinAllowedFanSpeedEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetMinAllowedFanSpeedEnabledReq)
end

function TSetMinAllowedFanSpeedEnabledReq.new(MinAllowedFanSpeedEnabled)
    return TSetMinAllowedFanSpeedEnabledReq_from_obj({MinAllowedFanSpeedEnabled = MinAllowedFanSpeedEnabled})
end
---@param obj CoolingConfig.SetMinAllowedFanSpeedEnabledReq
function TSetMinAllowedFanSpeedEnabledReq:init_from_obj(obj)
    self.MinAllowedFanSpeedEnabled = obj.MinAllowedFanSpeedEnabled
end

function TSetMinAllowedFanSpeedEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMinAllowedFanSpeedEnabledReq.group)
end

TSetMinAllowedFanSpeedEnabledReq.from_obj = TSetMinAllowedFanSpeedEnabledReq_from_obj

TSetMinAllowedFanSpeedEnabledReq.proto_property = {'MinAllowedFanSpeedEnabled'}

TSetMinAllowedFanSpeedEnabledReq.default = {false}

TSetMinAllowedFanSpeedEnabledReq.struct = {{name = 'MinAllowedFanSpeedEnabled', is_array = false, struct = nil}}

function TSetMinAllowedFanSpeedEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinAllowedFanSpeedEnabled', self.MinAllowedFanSpeedEnabled, 'bool', false, errs,
        need_convert)

    TSetMinAllowedFanSpeedEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMinAllowedFanSpeedEnabledReq.proto_property, errs, need_convert)
    return self
end

function TSetMinAllowedFanSpeedEnabledReq:unpack(_)
    return self.MinAllowedFanSpeedEnabled
end

CoolingConfig.SetMinAllowedFanSpeedEnabledReq = TSetMinAllowedFanSpeedEnabledReq

---@class CoolingConfig.GetCustomTargetTemperaturesReq
local TGetCustomTargetTemperaturesReq = {}
TGetCustomTargetTemperaturesReq.__index = TGetCustomTargetTemperaturesReq
TGetCustomTargetTemperaturesReq.group = {}

local function TGetCustomTargetTemperaturesReq_from_obj(obj)
    return setmetatable(obj, TGetCustomTargetTemperaturesReq)
end

function TGetCustomTargetTemperaturesReq.new()
    return TGetCustomTargetTemperaturesReq_from_obj({})
end
---@param obj CoolingConfig.GetCustomTargetTemperaturesReq
function TGetCustomTargetTemperaturesReq:init_from_obj(obj)

end

function TGetCustomTargetTemperaturesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCustomTargetTemperaturesReq.group)
end

TGetCustomTargetTemperaturesReq.from_obj = TGetCustomTargetTemperaturesReq_from_obj

TGetCustomTargetTemperaturesReq.proto_property = {}

TGetCustomTargetTemperaturesReq.default = {}

TGetCustomTargetTemperaturesReq.struct = {}

function TGetCustomTargetTemperaturesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetCustomTargetTemperaturesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCustomTargetTemperaturesReq.proto_property, errs, need_convert)
    return self
end

function TGetCustomTargetTemperaturesReq:unpack(_)
end

CoolingConfig.GetCustomTargetTemperaturesReq = TGetCustomTargetTemperaturesReq

---@class CoolingConfig.GetComponentThermalZoneReq
---@field ComponentType string
local TGetComponentThermalZoneReq = {}
TGetComponentThermalZoneReq.__index = TGetComponentThermalZoneReq
TGetComponentThermalZoneReq.group = {}

local function TGetComponentThermalZoneReq_from_obj(obj)
    return setmetatable(obj, TGetComponentThermalZoneReq)
end

function TGetComponentThermalZoneReq.new(ComponentType)
    return TGetComponentThermalZoneReq_from_obj({ComponentType = ComponentType})
end
---@param obj CoolingConfig.GetComponentThermalZoneReq
function TGetComponentThermalZoneReq:init_from_obj(obj)
    self.ComponentType = obj.ComponentType
end

function TGetComponentThermalZoneReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentThermalZoneReq.group)
end

TGetComponentThermalZoneReq.from_obj = TGetComponentThermalZoneReq_from_obj

TGetComponentThermalZoneReq.proto_property = {'ComponentType'}

TGetComponentThermalZoneReq.default = {''}

TGetComponentThermalZoneReq.struct = {{name = 'ComponentType', is_array = false, struct = nil}}

function TGetComponentThermalZoneReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentType', self.ComponentType, 'string', false, errs, need_convert)

    TGetComponentThermalZoneReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentThermalZoneReq.proto_property, errs, need_convert)
    return self
end

function TGetComponentThermalZoneReq:unpack(_)
    return self.ComponentType
end

CoolingConfig.GetComponentThermalZoneReq = TGetComponentThermalZoneReq

---@class CoolingConfig.SetMinPWMRsp
local TSetMinPWMRsp = {}
TSetMinPWMRsp.__index = TSetMinPWMRsp
TSetMinPWMRsp.group = {}

local function TSetMinPWMRsp_from_obj(obj)
    return setmetatable(obj, TSetMinPWMRsp)
end

function TSetMinPWMRsp.new()
    return TSetMinPWMRsp_from_obj({})
end
---@param obj CoolingConfig.SetMinPWMRsp
function TSetMinPWMRsp:init_from_obj(obj)

end

function TSetMinPWMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMinPWMRsp.group)
end

TSetMinPWMRsp.from_obj = TSetMinPWMRsp_from_obj

TSetMinPWMRsp.proto_property = {}

TSetMinPWMRsp.default = {}

TSetMinPWMRsp.struct = {}

function TSetMinPWMRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetMinPWMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMinPWMRsp.proto_property, errs, need_convert)
    return self
end

function TSetMinPWMRsp:unpack(_)
end

CoolingConfig.SetMinPWMRsp = TSetMinPWMRsp

---@class CoolingConfig.SetMinPWMReq
---@field DeviceType string
---@field DeviceIds integer[]
---@field DeviceSpeeds integer[]
local TSetMinPWMReq = {}
TSetMinPWMReq.__index = TSetMinPWMReq
TSetMinPWMReq.group = {}

local function TSetMinPWMReq_from_obj(obj)
    return setmetatable(obj, TSetMinPWMReq)
end

function TSetMinPWMReq.new(DeviceType, DeviceIds, DeviceSpeeds)
    return TSetMinPWMReq_from_obj({DeviceType = DeviceType, DeviceIds = DeviceIds, DeviceSpeeds = DeviceSpeeds})
end
---@param obj CoolingConfig.SetMinPWMReq
function TSetMinPWMReq:init_from_obj(obj)
    self.DeviceType = obj.DeviceType
    self.DeviceIds = obj.DeviceIds
    self.DeviceSpeeds = obj.DeviceSpeeds
end

function TSetMinPWMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMinPWMReq.group)
end

TSetMinPWMReq.from_obj = TSetMinPWMReq_from_obj

TSetMinPWMReq.proto_property = {'DeviceType', 'DeviceIds', 'DeviceSpeeds'}

TSetMinPWMReq.default = {'', {}, {}}

TSetMinPWMReq.struct = {
    {name = 'DeviceType', is_array = false, struct = nil}, {name = 'DeviceIds', is_array = true, struct = nil},
    {name = 'DeviceSpeeds', is_array = true, struct = nil}
}

function TSetMinPWMReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'DeviceIds', self.DeviceIds, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'DeviceSpeeds', self.DeviceSpeeds, 'uint8', false, errs, need_convert)

    if self.DeviceType ~= nil then
        validate.Enum(prefix .. 'DeviceType', self.DeviceType, '', {'Fan', 'Pump'}, errs, need_convert)
        validate.regex(prefix .. 'DeviceType', self.DeviceType, [=[^(Fan|Pump)$]=], errs, need_convert)
    end

    TSetMinPWMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMinPWMReq.proto_property, errs, need_convert)
    return self
end

function TSetMinPWMReq:unpack(_)
    return self.DeviceType, self.DeviceIds, self.DeviceSpeeds
end

CoolingConfig.SetMinPWMReq = TSetMinPWMReq

---@class CoolingConfig.GetAbnormalPolicyEffectiveStatusRsp
---@field EffectiveStatus boolean
local TGetAbnormalPolicyEffectiveStatusRsp = {}
TGetAbnormalPolicyEffectiveStatusRsp.__index = TGetAbnormalPolicyEffectiveStatusRsp
TGetAbnormalPolicyEffectiveStatusRsp.group = {}

local function TGetAbnormalPolicyEffectiveStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetAbnormalPolicyEffectiveStatusRsp)
end

function TGetAbnormalPolicyEffectiveStatusRsp.new(EffectiveStatus)
    return TGetAbnormalPolicyEffectiveStatusRsp_from_obj({EffectiveStatus = EffectiveStatus})
end
---@param obj CoolingConfig.GetAbnormalPolicyEffectiveStatusRsp
function TGetAbnormalPolicyEffectiveStatusRsp:init_from_obj(obj)
    self.EffectiveStatus = obj.EffectiveStatus
end

function TGetAbnormalPolicyEffectiveStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAbnormalPolicyEffectiveStatusRsp.group)
end

TGetAbnormalPolicyEffectiveStatusRsp.from_obj = TGetAbnormalPolicyEffectiveStatusRsp_from_obj

TGetAbnormalPolicyEffectiveStatusRsp.proto_property = {'EffectiveStatus'}

TGetAbnormalPolicyEffectiveStatusRsp.default = {false}

TGetAbnormalPolicyEffectiveStatusRsp.struct = {{name = 'EffectiveStatus', is_array = false, struct = nil}}

function TGetAbnormalPolicyEffectiveStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EffectiveStatus', self.EffectiveStatus, 'bool', false, errs, need_convert)

    TGetAbnormalPolicyEffectiveStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAbnormalPolicyEffectiveStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetAbnormalPolicyEffectiveStatusRsp:unpack(_)
    return self.EffectiveStatus
end

CoolingConfig.GetAbnormalPolicyEffectiveStatusRsp = TGetAbnormalPolicyEffectiveStatusRsp

---@class CoolingConfig.GetAbnormalPolicyEffectiveStatusReq
---@field PolicyType string
local TGetAbnormalPolicyEffectiveStatusReq = {}
TGetAbnormalPolicyEffectiveStatusReq.__index = TGetAbnormalPolicyEffectiveStatusReq
TGetAbnormalPolicyEffectiveStatusReq.group = {}

local function TGetAbnormalPolicyEffectiveStatusReq_from_obj(obj)
    return setmetatable(obj, TGetAbnormalPolicyEffectiveStatusReq)
end

function TGetAbnormalPolicyEffectiveStatusReq.new(PolicyType)
    return TGetAbnormalPolicyEffectiveStatusReq_from_obj({PolicyType = PolicyType})
end
---@param obj CoolingConfig.GetAbnormalPolicyEffectiveStatusReq
function TGetAbnormalPolicyEffectiveStatusReq:init_from_obj(obj)
    self.PolicyType = obj.PolicyType
end

function TGetAbnormalPolicyEffectiveStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAbnormalPolicyEffectiveStatusReq.group)
end

TGetAbnormalPolicyEffectiveStatusReq.from_obj = TGetAbnormalPolicyEffectiveStatusReq_from_obj

TGetAbnormalPolicyEffectiveStatusReq.proto_property = {'PolicyType'}

TGetAbnormalPolicyEffectiveStatusReq.default = {''}

TGetAbnormalPolicyEffectiveStatusReq.struct = {{name = 'PolicyType', is_array = false, struct = nil}}

function TGetAbnormalPolicyEffectiveStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PolicyType', self.PolicyType, 'string', false, errs, need_convert)

    if self.PolicyType ~= nil then
        validate.Enum(prefix .. 'PolicyType', self.PolicyType, '', {'Fan', 'Pump', 'Temperature', 'All'}, errs,
            need_convert)
    end

    TGetAbnormalPolicyEffectiveStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAbnormalPolicyEffectiveStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetAbnormalPolicyEffectiveStatusReq:unpack(_)
    return self.PolicyType
end

CoolingConfig.GetAbnormalPolicyEffectiveStatusReq = TGetAbnormalPolicyEffectiveStatusReq

---@class CoolingConfig.SetSmartCoolingModeRsp
local TSetSmartCoolingModeRsp = {}
TSetSmartCoolingModeRsp.__index = TSetSmartCoolingModeRsp
TSetSmartCoolingModeRsp.group = {}

local function TSetSmartCoolingModeRsp_from_obj(obj)
    return setmetatable(obj, TSetSmartCoolingModeRsp)
end

function TSetSmartCoolingModeRsp.new()
    return TSetSmartCoolingModeRsp_from_obj({})
end
---@param obj CoolingConfig.SetSmartCoolingModeRsp
function TSetSmartCoolingModeRsp:init_from_obj(obj)

end

function TSetSmartCoolingModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmartCoolingModeRsp.group)
end

TSetSmartCoolingModeRsp.from_obj = TSetSmartCoolingModeRsp_from_obj

TSetSmartCoolingModeRsp.proto_property = {}

TSetSmartCoolingModeRsp.default = {}

TSetSmartCoolingModeRsp.struct = {}

function TSetSmartCoolingModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSmartCoolingModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmartCoolingModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetSmartCoolingModeRsp:unpack(_)
end

CoolingConfig.SetSmartCoolingModeRsp = TSetSmartCoolingModeRsp

---@class CoolingConfig.SetSmartCoolingModeReq
---@field Mode string
local TSetSmartCoolingModeReq = {}
TSetSmartCoolingModeReq.__index = TSetSmartCoolingModeReq
TSetSmartCoolingModeReq.group = {}

local function TSetSmartCoolingModeReq_from_obj(obj)
    return setmetatable(obj, TSetSmartCoolingModeReq)
end

function TSetSmartCoolingModeReq.new(Mode)
    return TSetSmartCoolingModeReq_from_obj({Mode = Mode})
end
---@param obj CoolingConfig.SetSmartCoolingModeReq
function TSetSmartCoolingModeReq:init_from_obj(obj)
    self.Mode = obj.Mode
end

function TSetSmartCoolingModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmartCoolingModeReq.group)
end

TSetSmartCoolingModeReq.from_obj = TSetSmartCoolingModeReq_from_obj

TSetSmartCoolingModeReq.proto_property = {'Mode'}

TSetSmartCoolingModeReq.default = {''}

TSetSmartCoolingModeReq.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TSetSmartCoolingModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'string', false, errs, need_convert)

    TSetSmartCoolingModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmartCoolingModeReq.proto_property, errs, need_convert)
    return self
end

function TSetSmartCoolingModeReq:unpack(_)
    return self.Mode
end

CoolingConfig.SetSmartCoolingModeReq = TSetSmartCoolingModeReq

---@class CoolingConfig.SetMediumRsp
local TSetMediumRsp = {}
TSetMediumRsp.__index = TSetMediumRsp
TSetMediumRsp.group = {}

local function TSetMediumRsp_from_obj(obj)
    return setmetatable(obj, TSetMediumRsp)
end

function TSetMediumRsp.new()
    return TSetMediumRsp_from_obj({})
end
---@param obj CoolingConfig.SetMediumRsp
function TSetMediumRsp:init_from_obj(obj)

end

function TSetMediumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMediumRsp.group)
end

TSetMediumRsp.from_obj = TSetMediumRsp_from_obj

TSetMediumRsp.proto_property = {}

TSetMediumRsp.default = {}

TSetMediumRsp.struct = {}

function TSetMediumRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetMediumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMediumRsp.proto_property, errs, need_convert)
    return self
end

function TSetMediumRsp:unpack(_)
end

CoolingConfig.SetMediumRsp = TSetMediumRsp

---@class CoolingConfig.SetMediumReq
---@field Medium string
local TSetMediumReq = {}
TSetMediumReq.__index = TSetMediumReq
TSetMediumReq.group = {}

local function TSetMediumReq_from_obj(obj)
    return setmetatable(obj, TSetMediumReq)
end

function TSetMediumReq.new(Medium)
    return TSetMediumReq_from_obj({Medium = Medium})
end
---@param obj CoolingConfig.SetMediumReq
function TSetMediumReq:init_from_obj(obj)
    self.Medium = obj.Medium
end

function TSetMediumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMediumReq.group)
end

TSetMediumReq.from_obj = TSetMediumReq_from_obj

TSetMediumReq.proto_property = {'Medium'}

TSetMediumReq.default = {''}

TSetMediumReq.struct = {{name = 'Medium', is_array = false, struct = nil}}

function TSetMediumReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Medium', self.Medium, 'string', false, errs, need_convert)

    if self.Medium ~= nil then
        validate.regex(prefix .. 'Medium', self.Medium, [=[^(Air|Liquid)$]=], errs, need_convert)
    end

    TSetMediumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMediumReq.proto_property, errs, need_convert)
    return self
end

function TSetMediumReq:unpack(_)
    return self.Medium
end

CoolingConfig.SetMediumReq = TSetMediumReq

---@class CoolingConfig.SetManualLevelRsp
local TSetManualLevelRsp = {}
TSetManualLevelRsp.__index = TSetManualLevelRsp
TSetManualLevelRsp.group = {}

local function TSetManualLevelRsp_from_obj(obj)
    return setmetatable(obj, TSetManualLevelRsp)
end

function TSetManualLevelRsp.new()
    return TSetManualLevelRsp_from_obj({})
end
---@param obj CoolingConfig.SetManualLevelRsp
function TSetManualLevelRsp:init_from_obj(obj)

end

function TSetManualLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetManualLevelRsp.group)
end

TSetManualLevelRsp.from_obj = TSetManualLevelRsp_from_obj

TSetManualLevelRsp.proto_property = {}

TSetManualLevelRsp.default = {}

TSetManualLevelRsp.struct = {}

function TSetManualLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetManualLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetManualLevelRsp.proto_property, errs, need_convert)
    return self
end

function TSetManualLevelRsp:unpack(_)
end

CoolingConfig.SetManualLevelRsp = TSetManualLevelRsp

---@class CoolingConfig.SetManualLevelReq
---@field UnitId integer
---@field Level integer
local TSetManualLevelReq = {}
TSetManualLevelReq.__index = TSetManualLevelReq
TSetManualLevelReq.group = {}

local function TSetManualLevelReq_from_obj(obj)
    return setmetatable(obj, TSetManualLevelReq)
end

function TSetManualLevelReq.new(UnitId, Level)
    return TSetManualLevelReq_from_obj({UnitId = UnitId, Level = Level})
end
---@param obj CoolingConfig.SetManualLevelReq
function TSetManualLevelReq:init_from_obj(obj)
    self.UnitId = obj.UnitId
    self.Level = obj.Level
end

function TSetManualLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetManualLevelReq.group)
end

TSetManualLevelReq.from_obj = TSetManualLevelReq_from_obj

TSetManualLevelReq.proto_property = {'UnitId', 'Level'}

TSetManualLevelReq.default = {0, 0}

TSetManualLevelReq.struct = {
    {name = 'UnitId', is_array = false, struct = nil}, {name = 'Level', is_array = false, struct = nil}
}

function TSetManualLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnitId', self.UnitId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Level', self.Level, 'uint8', false, errs, need_convert)

    TSetManualLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetManualLevelReq.proto_property, errs, need_convert)
    return self
end

function TSetManualLevelReq:unpack(_)
    return self.UnitId, self.Level
end

CoolingConfig.SetManualLevelReq = TSetManualLevelReq

---@class CoolingConfig.SetCtrlModeRsp
local TSetCtrlModeRsp = {}
TSetCtrlModeRsp.__index = TSetCtrlModeRsp
TSetCtrlModeRsp.group = {}

local function TSetCtrlModeRsp_from_obj(obj)
    return setmetatable(obj, TSetCtrlModeRsp)
end

function TSetCtrlModeRsp.new()
    return TSetCtrlModeRsp_from_obj({})
end
---@param obj CoolingConfig.SetCtrlModeRsp
function TSetCtrlModeRsp:init_from_obj(obj)

end

function TSetCtrlModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCtrlModeRsp.group)
end

TSetCtrlModeRsp.from_obj = TSetCtrlModeRsp_from_obj

TSetCtrlModeRsp.proto_property = {}

TSetCtrlModeRsp.default = {}

TSetCtrlModeRsp.struct = {}

function TSetCtrlModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCtrlModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCtrlModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetCtrlModeRsp:unpack(_)
end

CoolingConfig.SetCtrlModeRsp = TSetCtrlModeRsp

---@class CoolingConfig.SetCtrlModeReq
---@field CtrlMode string
---@field Timeout integer
local TSetCtrlModeReq = {}
TSetCtrlModeReq.__index = TSetCtrlModeReq
TSetCtrlModeReq.group = {}

local function TSetCtrlModeReq_from_obj(obj)
    return setmetatable(obj, TSetCtrlModeReq)
end

function TSetCtrlModeReq.new(CtrlMode, Timeout)
    return TSetCtrlModeReq_from_obj({CtrlMode = CtrlMode, Timeout = Timeout})
end
---@param obj CoolingConfig.SetCtrlModeReq
function TSetCtrlModeReq:init_from_obj(obj)
    self.CtrlMode = obj.CtrlMode
    self.Timeout = obj.Timeout
end

function TSetCtrlModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCtrlModeReq.group)
end

TSetCtrlModeReq.from_obj = TSetCtrlModeReq_from_obj

TSetCtrlModeReq.proto_property = {'CtrlMode', 'Timeout'}

TSetCtrlModeReq.default = {'', 0}

TSetCtrlModeReq.struct = {
    {name = 'CtrlMode', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil}
}

function TSetCtrlModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlMode', self.CtrlMode, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint32', false, errs, need_convert)

    TSetCtrlModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCtrlModeReq.proto_property, errs, need_convert)
    return self
end

function TSetCtrlModeReq:unpack(_)
    return self.CtrlMode, self.Timeout
end

CoolingConfig.SetCtrlModeReq = TSetCtrlModeReq

---@class CoolingConfig.ComponentThermalZone
---@field Slot integer
---@field FanIds integer[]
---@field PumpIds integer[]
local TComponentThermalZone = {}
TComponentThermalZone.__index = TComponentThermalZone
TComponentThermalZone.group = {}

local function TComponentThermalZone_from_obj(obj)
    return setmetatable(obj, TComponentThermalZone)
end

function TComponentThermalZone.new(Slot, FanIds, PumpIds)
    return TComponentThermalZone_from_obj({Slot = Slot, FanIds = FanIds, PumpIds = PumpIds})
end
---@param obj CoolingConfig.ComponentThermalZone
function TComponentThermalZone:init_from_obj(obj)
    self.Slot = obj.Slot
    self.FanIds = obj.FanIds
    self.PumpIds = obj.PumpIds
end

function TComponentThermalZone:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentThermalZone.group)
end

TComponentThermalZone.from_obj = TComponentThermalZone_from_obj

TComponentThermalZone.proto_property = {'Slot', 'FanIds', 'PumpIds'}

TComponentThermalZone.default = {0, {}, {}}

TComponentThermalZone.struct = {
    {name = 'Slot', is_array = false, struct = nil}, {name = 'FanIds', is_array = true, struct = nil},
    {name = 'PumpIds', is_array = true, struct = nil}
}

function TComponentThermalZone:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'FanIds', self.FanIds, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'PumpIds', self.PumpIds, 'uint8', false, errs, need_convert)

    TComponentThermalZone:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentThermalZone.proto_property, errs, need_convert)
    return self
end

function TComponentThermalZone:unpack(_)
    return self.Slot, self.FanIds, self.PumpIds
end

CoolingConfig.ComponentThermalZone = TComponentThermalZone

---@class CoolingConfig.GetComponentThermalZoneRsp
---@field ComponentThermalZone CoolingConfig.ComponentThermalZone[]
local TGetComponentThermalZoneRsp = {}
TGetComponentThermalZoneRsp.__index = TGetComponentThermalZoneRsp
TGetComponentThermalZoneRsp.group = {}

local function TGetComponentThermalZoneRsp_from_obj(obj)
    obj.ComponentThermalZone = utils.from_obj(CoolingConfig.ComponentThermalZone, obj.ComponentThermalZone, true)
    return setmetatable(obj, TGetComponentThermalZoneRsp)
end

function TGetComponentThermalZoneRsp.new(ComponentThermalZone)
    return TGetComponentThermalZoneRsp_from_obj({ComponentThermalZone = ComponentThermalZone})
end
---@param obj CoolingConfig.GetComponentThermalZoneRsp
function TGetComponentThermalZoneRsp:init_from_obj(obj)
    self.ComponentThermalZone = obj.ComponentThermalZone
end

function TGetComponentThermalZoneRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentThermalZoneRsp.group)
end

TGetComponentThermalZoneRsp.from_obj = TGetComponentThermalZoneRsp_from_obj

TGetComponentThermalZoneRsp.proto_property = {'ComponentThermalZone'}

TGetComponentThermalZoneRsp.default = {{}}

TGetComponentThermalZoneRsp.struct = {
    {name = 'ComponentThermalZone', is_array = true, struct = CoolingConfig.ComponentThermalZone.struct}
}

function TGetComponentThermalZoneRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.ComponentThermalZone) do
        CoolingConfig.ComponentThermalZone.new(v.Slot, v.FanIds, v.PumpIds):validate(prefix, errs, need_convert)
    end

    TGetComponentThermalZoneRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentThermalZoneRsp.proto_property, errs, need_convert)
    return self
end

function TGetComponentThermalZoneRsp:unpack(raw)
    return utils.unpack(raw, self.ComponentThermalZone, true)
end

CoolingConfig.GetComponentThermalZoneRsp = TGetComponentThermalZoneRsp

---@class CoolingConfig.CustomTargetTemperatureItem
---@field TemperatureType integer
---@field TargetTemperatureCelsius integer
---@field MinTargetTemperatureCelsius integer
---@field MaxTargetTemperatureCelsius integer
local TCustomTargetTemperatureItem = {}
TCustomTargetTemperatureItem.__index = TCustomTargetTemperatureItem
TCustomTargetTemperatureItem.group = {}

local function TCustomTargetTemperatureItem_from_obj(obj)
    return setmetatable(obj, TCustomTargetTemperatureItem)
end

function TCustomTargetTemperatureItem.new(TemperatureType, TargetTemperatureCelsius, MinTargetTemperatureCelsius,
    MaxTargetTemperatureCelsius)
    return TCustomTargetTemperatureItem_from_obj({
        TemperatureType = TemperatureType,
        TargetTemperatureCelsius = TargetTemperatureCelsius,
        MinTargetTemperatureCelsius = MinTargetTemperatureCelsius,
        MaxTargetTemperatureCelsius = MaxTargetTemperatureCelsius
    })
end
---@param obj CoolingConfig.CustomTargetTemperatureItem
function TCustomTargetTemperatureItem:init_from_obj(obj)
    self.TemperatureType = obj.TemperatureType
    self.TargetTemperatureCelsius = obj.TargetTemperatureCelsius
    self.MinTargetTemperatureCelsius = obj.MinTargetTemperatureCelsius
    self.MaxTargetTemperatureCelsius = obj.MaxTargetTemperatureCelsius
end

function TCustomTargetTemperatureItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomTargetTemperatureItem.group)
end

TCustomTargetTemperatureItem.from_obj = TCustomTargetTemperatureItem_from_obj

TCustomTargetTemperatureItem.proto_property = {
    'TemperatureType', 'TargetTemperatureCelsius', 'MinTargetTemperatureCelsius', 'MaxTargetTemperatureCelsius'
}

TCustomTargetTemperatureItem.default = {0, 0, 0, 0}

TCustomTargetTemperatureItem.struct = {
    {name = 'TemperatureType', is_array = false, struct = nil},
    {name = 'TargetTemperatureCelsius', is_array = false, struct = nil},
    {name = 'MinTargetTemperatureCelsius', is_array = false, struct = nil},
    {name = 'MaxTargetTemperatureCelsius', is_array = false, struct = nil}
}

function TCustomTargetTemperatureItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureType', self.TemperatureType, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'TargetTemperatureCelsius', self.TargetTemperatureCelsius, 'uint8', false, errs,
        need_convert)
    validate.Optional(prefix .. 'MinTargetTemperatureCelsius', self.MinTargetTemperatureCelsius, 'uint8', false, errs,
        need_convert)
    validate.Optional(prefix .. 'MaxTargetTemperatureCelsius', self.MaxTargetTemperatureCelsius, 'uint8', false, errs,
        need_convert)

    TCustomTargetTemperatureItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomTargetTemperatureItem.proto_property, errs, need_convert)
    return self
end

function TCustomTargetTemperatureItem:unpack(_)
    return self.TemperatureType, self.TargetTemperatureCelsius, self.MinTargetTemperatureCelsius,
        self.MaxTargetTemperatureCelsius
end

CoolingConfig.CustomTargetTemperatureItem = TCustomTargetTemperatureItem

---@class CoolingConfig.GetCustomTargetTemperaturesRsp
---@field CustomTargetTemperatures CoolingConfig.CustomTargetTemperatureItem[]
local TGetCustomTargetTemperaturesRsp = {}
TGetCustomTargetTemperaturesRsp.__index = TGetCustomTargetTemperaturesRsp
TGetCustomTargetTemperaturesRsp.group = {}

local function TGetCustomTargetTemperaturesRsp_from_obj(obj)
    obj.CustomTargetTemperatures = utils.from_obj(CoolingConfig.CustomTargetTemperatureItem,
        obj.CustomTargetTemperatures, true)
    return setmetatable(obj, TGetCustomTargetTemperaturesRsp)
end

function TGetCustomTargetTemperaturesRsp.new(CustomTargetTemperatures)
    return TGetCustomTargetTemperaturesRsp_from_obj({CustomTargetTemperatures = CustomTargetTemperatures})
end
---@param obj CoolingConfig.GetCustomTargetTemperaturesRsp
function TGetCustomTargetTemperaturesRsp:init_from_obj(obj)
    self.CustomTargetTemperatures = obj.CustomTargetTemperatures
end

function TGetCustomTargetTemperaturesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCustomTargetTemperaturesRsp.group)
end

TGetCustomTargetTemperaturesRsp.from_obj = TGetCustomTargetTemperaturesRsp_from_obj

TGetCustomTargetTemperaturesRsp.proto_property = {'CustomTargetTemperatures'}

TGetCustomTargetTemperaturesRsp.default = {{}}

TGetCustomTargetTemperaturesRsp.struct = {
    {name = 'CustomTargetTemperatures', is_array = true, struct = CoolingConfig.CustomTargetTemperatureItem.struct}
}

function TGetCustomTargetTemperaturesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.CustomTargetTemperatures) do
        CoolingConfig.CustomTargetTemperatureItem.new(v.TemperatureType, v.TargetTemperatureCelsius,
            v.MinTargetTemperatureCelsius, v.MaxTargetTemperatureCelsius):validate(prefix, errs, need_convert)
    end

    TGetCustomTargetTemperaturesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCustomTargetTemperaturesRsp.proto_property, errs, need_convert)
    return self
end

function TGetCustomTargetTemperaturesRsp:unpack(raw)
    return utils.unpack(raw, self.CustomTargetTemperatures, true)
end

CoolingConfig.GetCustomTargetTemperaturesRsp = TGetCustomTargetTemperaturesRsp

CoolingConfig.interface = mdb.register_interface('bmc.kepler.Systems.CoolingConfig', {
    SmartCoolingState = {'s', {}, true, 'Enabled'},
    SmartCoolingMode = {'s', nil, true, 'EnergySaving'},
    Medium = {'s', nil, true, 'Air'},
    CtrlMode = {'s', {'EMIT_CHANGE'}, true, 'Auto'},
    TimeOut = {'u', {'VOLATILE'}, true, 30},
    ManualLevel = {'y', {'EMIT_CHANGE'}, true, 10},
    LevelPercentRange = {'ay', {'CONST'}, true, nil},
    SensorLocationSupported = {'b', {'CONST'}, true, false},
    MinAllowedFanSpeedPercent = {'y', {'EMIT_CHANGE'}, false, 255},
    MinAllowedFanSpeedEnabled = {'b', {}, true, false},
    MixedModeSupported = {'b', {}, true, false}
}, {
    SetCtrlMode = {'a{ss}su', '', TSetCtrlModeReq, TSetCtrlModeRsp},
    SetManualLevel = {'a{ss}yy', '', TSetManualLevelReq, TSetManualLevelRsp},
    SetMedium = {'a{ss}s', '', TSetMediumReq, TSetMediumRsp},
    SetSmartCoolingMode = {'a{ss}s', '', TSetSmartCoolingModeReq, TSetSmartCoolingModeRsp},
    GetAbnormalPolicyEffectiveStatus = {
        'a{ss}s', 'b', TGetAbnormalPolicyEffectiveStatusReq, TGetAbnormalPolicyEffectiveStatusRsp
    },
    SetMinPWM = {'a{ss}sayay', '', TSetMinPWMReq, TSetMinPWMRsp},
    GetComponentThermalZone = {'a{ss}s', 'a(yayay)', TGetComponentThermalZoneReq, TGetComponentThermalZoneRsp},
    GetCustomTargetTemperatures = {'a{ss}', 'a(uyyy)', TGetCustomTargetTemperaturesReq, TGetCustomTargetTemperaturesRsp},
    SetMinAllowedFanSpeedEnabled = {'a{ss}b', '', TSetMinAllowedFanSpeedEnabledReq, TSetMinAllowedFanSpeedEnabledRsp}
}, {})

return CoolingConfig
