--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFanLevel = {}

---@class ThermalMgmtIpmiCmds.SetFanLevelReq
---@field PicmgIdentifier integer
---@field FruId integer
---@field FanLevel integer
---@field LocalCtllEnable string
local TSetFanLevelReq = {}
TSetFanLevelReq.__index = TSetFanLevelReq
TSetFanLevelReq.group = {}

local function TSetFanLevelReq_from_obj(obj)
    return setmetatable(obj, TSetFanLevelReq)
end

function TSetFanLevelReq.new(PicmgIdentifier, FruId, FanLevel, LocalCtllEnable)
    return TSetFanLevelReq_from_obj({
        PicmgIdentifier = PicmgIdentifier,
        FruId = FruId,
        FanLevel = FanLevel,
        LocalCtllEnable = LocalCtllEnable
    })
end
---@param obj ThermalMgmtIpmiCmds.SetFanLevelReq
function TSetFanLevelReq:init_from_obj(obj)
    self.PicmgIdentifier = obj.PicmgIdentifier
    self.FruId = obj.FruId
    self.FanLevel = obj.FanLevel
    self.LocalCtllEnable = obj.LocalCtllEnable
end

function TSetFanLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanLevelReq.group)
end

TSetFanLevelReq.from_obj = TSetFanLevelReq_from_obj

TSetFanLevelReq.proto_property = {'PicmgIdentifier', 'FruId', 'FanLevel', 'LocalCtllEnable'}

TSetFanLevelReq.default = {0, 0, 0, ''}

TSetFanLevelReq.struct = {
    {name = 'PicmgIdentifier', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil},
    {name = 'FanLevel', is_array = false, struct = nil}, {name = 'LocalCtllEnable', is_array = false, struct = nil}
}

function TSetFanLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FanLevel', self.FanLevel, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LocalCtllEnable', self.LocalCtllEnable, 'string', false, errs, need_convert)

    TSetFanLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanLevelReq.proto_property, errs, need_convert)
    return self
end

function TSetFanLevelReq:unpack(_)
    return self.PicmgIdentifier, self.FruId, self.FanLevel, self.LocalCtllEnable
end

SetFanLevel.SetFanLevelReq = TSetFanLevelReq

---@class ThermalMgmtIpmiCmds.SetFanLevelRsp
---@field CompletionCode integer
---@field PicmgIdentifier integer
local TSetFanLevelRsp = {}
TSetFanLevelRsp.__index = TSetFanLevelRsp
TSetFanLevelRsp.group = {}

local function TSetFanLevelRsp_from_obj(obj)
    return setmetatable(obj, TSetFanLevelRsp)
end

function TSetFanLevelRsp.new(CompletionCode, PicmgIdentifier)
    return TSetFanLevelRsp_from_obj({CompletionCode = CompletionCode, PicmgIdentifier = PicmgIdentifier})
end
---@param obj ThermalMgmtIpmiCmds.SetFanLevelRsp
function TSetFanLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgIdentifier = obj.PicmgIdentifier
end

function TSetFanLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanLevelRsp.group)
end

TSetFanLevelRsp.from_obj = TSetFanLevelRsp_from_obj

TSetFanLevelRsp.proto_property = {'CompletionCode', 'PicmgIdentifier'}

TSetFanLevelRsp.default = {0, 0}

TSetFanLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'PicmgIdentifier', is_array = false, struct = nil}
}

function TSetFanLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier, 'uint8', false, errs, need_convert)

    TSetFanLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanLevelRsp.proto_property, errs, need_convert)
    return self
end

function TSetFanLevelRsp:unpack(_)
    return self.CompletionCode, self.PicmgIdentifier
end

SetFanLevel.SetFanLevelRsp = TSetFanLevelRsp

return SetFanLevel
