--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetValveOpeningDegree = {}

---@class ThermalMgmtIpmiCmds.GetValveOpeningDegreeReq
---@field ManufactureId integer
---@field Index integer
local TGetValveOpeningDegreeReq = {}
TGetValveOpeningDegreeReq.__index = TGetValveOpeningDegreeReq
TGetValveOpeningDegreeReq.group = {}

local function TGetValveOpeningDegreeReq_from_obj(obj)
    return setmetatable(obj, TGetValveOpeningDegreeReq)
end

function TGetValveOpeningDegreeReq.new(ManufactureId, Index)
    return TGetValveOpeningDegreeReq_from_obj({ManufactureId = ManufactureId, Index = Index})
end
---@param obj ThermalMgmtIpmiCmds.GetValveOpeningDegreeReq
function TGetValveOpeningDegreeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Index = obj.Index
end

function TGetValveOpeningDegreeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetValveOpeningDegreeReq.group)
end

TGetValveOpeningDegreeReq.from_obj = TGetValveOpeningDegreeReq_from_obj

TGetValveOpeningDegreeReq.proto_property = {'ManufactureId', 'Index'}

TGetValveOpeningDegreeReq.default = {0, 0}

TGetValveOpeningDegreeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Index', is_array = false, struct = nil}
}

function TGetValveOpeningDegreeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Index', self.Index, 'uint8', false, errs, need_convert)

    TGetValveOpeningDegreeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetValveOpeningDegreeReq.proto_property, errs, need_convert)
    return self
end

function TGetValveOpeningDegreeReq:unpack(_)
    return self.ManufactureId, self.Index
end

GetValveOpeningDegree.GetValveOpeningDegreeReq = TGetValveOpeningDegreeReq

---@class ThermalMgmtIpmiCmds.GetValveOpeningDegreeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data integer
local TGetValveOpeningDegreeRsp = {}
TGetValveOpeningDegreeRsp.__index = TGetValveOpeningDegreeRsp
TGetValveOpeningDegreeRsp.group = {}

local function TGetValveOpeningDegreeRsp_from_obj(obj)
    return setmetatable(obj, TGetValveOpeningDegreeRsp)
end

function TGetValveOpeningDegreeRsp.new(CompletionCode, ManufactureId, Data)
    return TGetValveOpeningDegreeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Data = Data
    })
end
---@param obj ThermalMgmtIpmiCmds.GetValveOpeningDegreeRsp
function TGetValveOpeningDegreeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetValveOpeningDegreeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetValveOpeningDegreeRsp.group)
end

TGetValveOpeningDegreeRsp.from_obj = TGetValveOpeningDegreeRsp_from_obj

TGetValveOpeningDegreeRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetValveOpeningDegreeRsp.default = {0, 0, 0}

TGetValveOpeningDegreeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetValveOpeningDegreeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'uint16', false, errs, need_convert)

    TGetValveOpeningDegreeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetValveOpeningDegreeRsp.proto_property, errs, need_convert)
    return self
end

function TGetValveOpeningDegreeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetValveOpeningDegree.GetValveOpeningDegreeRsp = TGetValveOpeningDegreeRsp

return GetValveOpeningDegree
