--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetInitCoolingUnitLevel = {}

---@class ThermalMgmtIpmiCmds.GetInitCoolingUnitLevelReq
---@field ManufactureId integer
---@field ParamLen integer
local TGetInitCoolingUnitLevelReq = {}
TGetInitCoolingUnitLevelReq.__index = TGetInitCoolingUnitLevelReq
TGetInitCoolingUnitLevelReq.group = {}

local function TGetInitCoolingUnitLevelReq_from_obj(obj)
    return setmetatable(obj, TGetInitCoolingUnitLevelReq)
end

function TGetInitCoolingUnitLevelReq.new(ManufactureId, ParamLen)
    return TGetInitCoolingUnitLevelReq_from_obj({ManufactureId = ManufactureId, ParamLen = ParamLen})
end
---@param obj ThermalMgmtIpmiCmds.GetInitCoolingUnitLevelReq
function TGetInitCoolingUnitLevelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ParamLen = obj.ParamLen
end

function TGetInitCoolingUnitLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetInitCoolingUnitLevelReq.group)
end

TGetInitCoolingUnitLevelReq.from_obj = TGetInitCoolingUnitLevelReq_from_obj

TGetInitCoolingUnitLevelReq.proto_property = {'ManufactureId', 'ParamLen'}

TGetInitCoolingUnitLevelReq.default = {0, 0}

TGetInitCoolingUnitLevelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'ParamLen', is_array = false, struct = nil}
}

function TGetInitCoolingUnitLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ParamLen', self.ParamLen, 'uint16', false, errs, need_convert)

    TGetInitCoolingUnitLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetInitCoolingUnitLevelReq.proto_property, errs, need_convert)
    return self
end

function TGetInitCoolingUnitLevelReq:unpack(_)
    return self.ManufactureId, self.ParamLen
end

GetInitCoolingUnitLevel.GetInitCoolingUnitLevelReq = TGetInitCoolingUnitLevelReq

---@class ThermalMgmtIpmiCmds.GetInitCoolingUnitLevelRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Level integer
local TGetInitCoolingUnitLevelRsp = {}
TGetInitCoolingUnitLevelRsp.__index = TGetInitCoolingUnitLevelRsp
TGetInitCoolingUnitLevelRsp.group = {}

local function TGetInitCoolingUnitLevelRsp_from_obj(obj)
    return setmetatable(obj, TGetInitCoolingUnitLevelRsp)
end

function TGetInitCoolingUnitLevelRsp.new(CompletionCode, ManufactureId, Level)
    return TGetInitCoolingUnitLevelRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Level = Level
    })
end
---@param obj ThermalMgmtIpmiCmds.GetInitCoolingUnitLevelRsp
function TGetInitCoolingUnitLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Level = obj.Level
end

function TGetInitCoolingUnitLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetInitCoolingUnitLevelRsp.group)
end

TGetInitCoolingUnitLevelRsp.from_obj = TGetInitCoolingUnitLevelRsp_from_obj

TGetInitCoolingUnitLevelRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Level'}

TGetInitCoolingUnitLevelRsp.default = {0, 0, 0}

TGetInitCoolingUnitLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Level', is_array = false, struct = nil}
}

function TGetInitCoolingUnitLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Level', self.Level, 'uint8', false, errs, need_convert)

    TGetInitCoolingUnitLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetInitCoolingUnitLevelRsp.proto_property, errs, need_convert)
    return self
end

function TGetInitCoolingUnitLevelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Level
end

GetInitCoolingUnitLevel.GetInitCoolingUnitLevelRsp = TGetInitCoolingUnitLevelRsp

return GetInitCoolingUnitLevel
