--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCoolingMode = {}

---@class ThermalMgmtIpmiCmds.GetCoolingModeReq
---@field ManufactureId integer
---@field PolicyOption string
local TGetCoolingModeReq = {}
TGetCoolingModeReq.__index = TGetCoolingModeReq
TGetCoolingModeReq.group = {}

local function TGetCoolingModeReq_from_obj(obj)
    return setmetatable(obj, TGetCoolingModeReq)
end

function TGetCoolingModeReq.new(ManufactureId, PolicyOption)
    return TGetCoolingModeReq_from_obj({ManufactureId = ManufactureId, PolicyOption = PolicyOption})
end
---@param obj ThermalMgmtIpmiCmds.GetCoolingModeReq
function TGetCoolingModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.PolicyOption = obj.PolicyOption
end

function TGetCoolingModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCoolingModeReq.group)
end

TGetCoolingModeReq.from_obj = TGetCoolingModeReq_from_obj

TGetCoolingModeReq.proto_property = {'ManufactureId', 'PolicyOption'}

TGetCoolingModeReq.default = {0, ''}

TGetCoolingModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'PolicyOption', is_array = false, struct = nil}
}

function TGetCoolingModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PolicyOption', self.PolicyOption, 'string', false, errs, need_convert)

    TGetCoolingModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCoolingModeReq.proto_property, errs, need_convert)
    return self
end

function TGetCoolingModeReq:unpack(_)
    return self.ManufactureId, self.PolicyOption
end

GetCoolingMode.GetCoolingModeReq = TGetCoolingModeReq

---@class ThermalMgmtIpmiCmds.GetCoolingModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field PolicyOption integer
---@field PolicyValue integer
local TGetCoolingModeRsp = {}
TGetCoolingModeRsp.__index = TGetCoolingModeRsp
TGetCoolingModeRsp.group = {}

local function TGetCoolingModeRsp_from_obj(obj)
    return setmetatable(obj, TGetCoolingModeRsp)
end

function TGetCoolingModeRsp.new(CompletionCode, ManufactureId, PolicyOption, PolicyValue)
    return TGetCoolingModeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        PolicyOption = PolicyOption,
        PolicyValue = PolicyValue
    })
end
---@param obj ThermalMgmtIpmiCmds.GetCoolingModeRsp
function TGetCoolingModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.PolicyOption = obj.PolicyOption
    self.PolicyValue = obj.PolicyValue
end

function TGetCoolingModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCoolingModeRsp.group)
end

TGetCoolingModeRsp.from_obj = TGetCoolingModeRsp_from_obj

TGetCoolingModeRsp.proto_property = {'CompletionCode', 'ManufactureId', 'PolicyOption', 'PolicyValue'}

TGetCoolingModeRsp.default = {0, 0, 0, 0}

TGetCoolingModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'PolicyOption', is_array = false, struct = nil}, {name = 'PolicyValue', is_array = false, struct = nil}
}

function TGetCoolingModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PolicyOption', self.PolicyOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PolicyValue', self.PolicyValue, 'uint8', false, errs, need_convert)

    TGetCoolingModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCoolingModeRsp.proto_property, errs, need_convert)
    return self
end

function TGetCoolingModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.PolicyOption, self.PolicyValue
end

GetCoolingMode.GetCoolingModeRsp = TGetCoolingModeRsp

return GetCoolingMode
