--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCoolingDeviceMode = {}

---@class ThermalMgmtIpmiCmds.GetCoolingDeviceModeReq
---@field ManufactureId integer
---@field DeviceType integer
local TGetCoolingDeviceModeReq = {}
TGetCoolingDeviceModeReq.__index = TGetCoolingDeviceModeReq
TGetCoolingDeviceModeReq.group = {}

local function TGetCoolingDeviceModeReq_from_obj(obj)
    return setmetatable(obj, TGetCoolingDeviceModeReq)
end

function TGetCoolingDeviceModeReq.new(ManufactureId, DeviceType)
    return TGetCoolingDeviceModeReq_from_obj({ManufactureId = ManufactureId, DeviceType = DeviceType})
end
---@param obj ThermalMgmtIpmiCmds.GetCoolingDeviceModeReq
function TGetCoolingDeviceModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
end

function TGetCoolingDeviceModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCoolingDeviceModeReq.group)
end

TGetCoolingDeviceModeReq.from_obj = TGetCoolingDeviceModeReq_from_obj

TGetCoolingDeviceModeReq.proto_property = {'ManufactureId', 'DeviceType'}

TGetCoolingDeviceModeReq.default = {0, 0}

TGetCoolingDeviceModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil}
}

function TGetCoolingDeviceModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)

    TGetCoolingDeviceModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCoolingDeviceModeReq.proto_property, errs, need_convert)
    return self
end

function TGetCoolingDeviceModeReq:unpack(_)
    return self.ManufactureId, self.DeviceType
end

GetCoolingDeviceMode.GetCoolingDeviceModeReq = TGetCoolingDeviceModeReq

---@class ThermalMgmtIpmiCmds.GetCoolingDeviceModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Mode integer
---@field Timeout string
local TGetCoolingDeviceModeRsp = {}
TGetCoolingDeviceModeRsp.__index = TGetCoolingDeviceModeRsp
TGetCoolingDeviceModeRsp.group = {}

local function TGetCoolingDeviceModeRsp_from_obj(obj)
    return setmetatable(obj, TGetCoolingDeviceModeRsp)
end

function TGetCoolingDeviceModeRsp.new(CompletionCode, ManufactureId, Mode, Timeout)
    return TGetCoolingDeviceModeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Mode = Mode,
        Timeout = Timeout
    })
end
---@param obj ThermalMgmtIpmiCmds.GetCoolingDeviceModeRsp
function TGetCoolingDeviceModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Mode = obj.Mode
    self.Timeout = obj.Timeout
end

function TGetCoolingDeviceModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCoolingDeviceModeRsp.group)
end

TGetCoolingDeviceModeRsp.from_obj = TGetCoolingDeviceModeRsp_from_obj

TGetCoolingDeviceModeRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Mode', 'Timeout'}

TGetCoolingDeviceModeRsp.default = {0, 0, 0, ''}

TGetCoolingDeviceModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Mode', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil}
}

function TGetCoolingDeviceModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'string', false, errs, need_convert)

    TGetCoolingDeviceModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCoolingDeviceModeRsp.proto_property, errs, need_convert)
    return self
end

function TGetCoolingDeviceModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Mode, self.Timeout
end

GetCoolingDeviceMode.GetCoolingDeviceModeRsp = TGetCoolingDeviceModeRsp

return GetCoolingDeviceMode
