--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCoolingDeviceLevel = {}

---@class ThermalMgmtIpmiCmds.GetCoolingDeviceLevelReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceId integer
---@field Mode integer
local TGetCoolingDeviceLevelReq = {}
TGetCoolingDeviceLevelReq.__index = TGetCoolingDeviceLevelReq
TGetCoolingDeviceLevelReq.group = {}

local function TGetCoolingDeviceLevelReq_from_obj(obj)
    return setmetatable(obj, TGetCoolingDeviceLevelReq)
end

function TGetCoolingDeviceLevelReq.new(ManufactureId, DeviceType, DeviceId, Mode)
    return TGetCoolingDeviceLevelReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceId = DeviceId,
        Mode = Mode
    })
end
---@param obj ThermalMgmtIpmiCmds.GetCoolingDeviceLevelReq
function TGetCoolingDeviceLevelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceId = obj.DeviceId
    self.Mode = obj.Mode
end

function TGetCoolingDeviceLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCoolingDeviceLevelReq.group)
end

TGetCoolingDeviceLevelReq.from_obj = TGetCoolingDeviceLevelReq_from_obj

TGetCoolingDeviceLevelReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceId', 'Mode'}

TGetCoolingDeviceLevelReq.default = {0, 0, 0, 0}

TGetCoolingDeviceLevelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceId', is_array = false, struct = nil}, {name = 'Mode', is_array = false, struct = nil}
}

function TGetCoolingDeviceLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)

    TGetCoolingDeviceLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCoolingDeviceLevelReq.proto_property, errs, need_convert)
    return self
end

function TGetCoolingDeviceLevelReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceId, self.Mode
end

GetCoolingDeviceLevel.GetCoolingDeviceLevelReq = TGetCoolingDeviceLevelReq

---@class ThermalMgmtIpmiCmds.GetCoolingDeviceLevelRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field DeviceNum integer
---@field Level string
local TGetCoolingDeviceLevelRsp = {}
TGetCoolingDeviceLevelRsp.__index = TGetCoolingDeviceLevelRsp
TGetCoolingDeviceLevelRsp.group = {}

local function TGetCoolingDeviceLevelRsp_from_obj(obj)
    return setmetatable(obj, TGetCoolingDeviceLevelRsp)
end

function TGetCoolingDeviceLevelRsp.new(CompletionCode, ManufactureId, DeviceNum, Level)
    return TGetCoolingDeviceLevelRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        DeviceNum = DeviceNum,
        Level = Level
    })
end
---@param obj ThermalMgmtIpmiCmds.GetCoolingDeviceLevelRsp
function TGetCoolingDeviceLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.DeviceNum = obj.DeviceNum
    self.Level = obj.Level
end

function TGetCoolingDeviceLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCoolingDeviceLevelRsp.group)
end

TGetCoolingDeviceLevelRsp.from_obj = TGetCoolingDeviceLevelRsp_from_obj

TGetCoolingDeviceLevelRsp.proto_property = {'CompletionCode', 'ManufactureId', 'DeviceNum', 'Level'}

TGetCoolingDeviceLevelRsp.default = {0, 0, 0, ''}

TGetCoolingDeviceLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'DeviceNum', is_array = false, struct = nil}, {name = 'Level', is_array = false, struct = nil}
}

function TGetCoolingDeviceLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNum', self.DeviceNum, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Level', self.Level, 'string', false, errs, need_convert)

    TGetCoolingDeviceLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCoolingDeviceLevelRsp.proto_property, errs, need_convert)
    return self
end

function TGetCoolingDeviceLevelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.DeviceNum, self.Level
end

GetCoolingDeviceLevel.GetCoolingDeviceLevelRsp = TGetCoolingDeviceLevelRsp

return GetCoolingDeviceLevel
