-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-7-25
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PidConfiguration = {}

---@class PidConfiguration.SetPidConfigItemRsp
local TSetPidConfigItemRsp = {}
TSetPidConfigItemRsp.__index = TSetPidConfigItemRsp
TSetPidConfigItemRsp.group = {}

local function TSetPidConfigItemRsp_from_obj(obj)
    return setmetatable(obj, TSetPidConfigItemRsp)
end

function TSetPidConfigItemRsp.new()
    return TSetPidConfigItemRsp_from_obj({})
end
---@param obj PidConfiguration.SetPidConfigItemRsp
function TSetPidConfigItemRsp:init_from_obj(obj)

end

function TSetPidConfigItemRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPidConfigItemRsp.group)
end

TSetPidConfigItemRsp.from_obj = TSetPidConfigItemRsp_from_obj

TSetPidConfigItemRsp.proto_property = {}

TSetPidConfigItemRsp.default = {}

TSetPidConfigItemRsp.struct = {}

function TSetPidConfigItemRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPidConfigItemRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPidConfigItemRsp.proto_property, errs, need_convert)
    return self
end

function TSetPidConfigItemRsp:unpack(_)
end

PidConfiguration.SetPidConfigItemRsp = TSetPidConfigItemRsp

---@class PidConfiguration.SetPidConfigItemReq
---@field ItemIndex integer
---@field ItemValue integer
local TSetPidConfigItemReq = {}
TSetPidConfigItemReq.__index = TSetPidConfigItemReq
TSetPidConfigItemReq.group = {}

local function TSetPidConfigItemReq_from_obj(obj)
    return setmetatable(obj, TSetPidConfigItemReq)
end

function TSetPidConfigItemReq.new(ItemIndex, ItemValue)
    return TSetPidConfigItemReq_from_obj({ItemIndex = ItemIndex, ItemValue = ItemValue})
end
---@param obj PidConfiguration.SetPidConfigItemReq
function TSetPidConfigItemReq:init_from_obj(obj)
    self.ItemIndex = obj.ItemIndex
    self.ItemValue = obj.ItemValue
end

function TSetPidConfigItemReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPidConfigItemReq.group)
end

TSetPidConfigItemReq.from_obj = TSetPidConfigItemReq_from_obj

TSetPidConfigItemReq.proto_property = {'ItemIndex', 'ItemValue'}

TSetPidConfigItemReq.default = {0, 0}

TSetPidConfigItemReq.descriptions = {
    [=[PID configuration item index, 0: high-temperature configuration item.]=], [=[Indicate configuration item value]=]
}

TSetPidConfigItemReq.struct = {
    {name = 'ItemIndex', is_array = false, struct = nil}, {name = 'ItemValue', is_array = false, struct = nil}
}

function TSetPidConfigItemReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ItemIndex', self.ItemIndex, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ItemValue', self.ItemValue, 'uint8', false, errs, need_convert)

    TSetPidConfigItemReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPidConfigItemReq.proto_property, errs, need_convert)
    return self
end

function TSetPidConfigItemReq:unpack(_)
    return self.ItemIndex, self.ItemValue
end

PidConfiguration.SetPidConfigItemReq = TSetPidConfigItemReq

---@class PidConfiguration.SetPidPrintModeRsp
local TSetPidPrintModeRsp = {}
TSetPidPrintModeRsp.__index = TSetPidPrintModeRsp
TSetPidPrintModeRsp.group = {}

local function TSetPidPrintModeRsp_from_obj(obj)
    return setmetatable(obj, TSetPidPrintModeRsp)
end

function TSetPidPrintModeRsp.new()
    return TSetPidPrintModeRsp_from_obj({})
end
---@param obj PidConfiguration.SetPidPrintModeRsp
function TSetPidPrintModeRsp:init_from_obj(obj)

end

function TSetPidPrintModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPidPrintModeRsp.group)
end

TSetPidPrintModeRsp.from_obj = TSetPidPrintModeRsp_from_obj

TSetPidPrintModeRsp.proto_property = {}

TSetPidPrintModeRsp.default = {}

TSetPidPrintModeRsp.struct = {}

function TSetPidPrintModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPidPrintModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPidPrintModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetPidPrintModeRsp:unpack(_)
end

PidConfiguration.SetPidPrintModeRsp = TSetPidPrintModeRsp

---@class PidConfiguration.SetPidPrintModeReq
---@field Type integer
---@field Enabled integer
local TSetPidPrintModeReq = {}
TSetPidPrintModeReq.__index = TSetPidPrintModeReq
TSetPidPrintModeReq.group = {}

local function TSetPidPrintModeReq_from_obj(obj)
    return setmetatable(obj, TSetPidPrintModeReq)
end

function TSetPidPrintModeReq.new(Type, Enabled)
    return TSetPidPrintModeReq_from_obj({Type = Type, Enabled = Enabled})
end
---@param obj PidConfiguration.SetPidPrintModeReq
function TSetPidPrintModeReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Enabled = obj.Enabled
end

function TSetPidPrintModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPidPrintModeReq.group)
end

TSetPidPrintModeReq.from_obj = TSetPidPrintModeReq_from_obj

TSetPidPrintModeReq.proto_property = {'Type', 'Enabled'}

TSetPidPrintModeReq.default = {0, 0}

TSetPidPrintModeReq.descriptions = {
    [=[PID message type, 1: configuration message, 2: control message.]=],
    [=[Indicate whether to enable to print PID message, 0: disable, 1: enable.]=]
}

TSetPidPrintModeReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'Enabled', is_array = false, struct = nil}
}

function TSetPidPrintModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs, need_convert)

    TSetPidPrintModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPidPrintModeReq.proto_property, errs, need_convert)
    return self
end

function TSetPidPrintModeReq:unpack(_)
    return self.Type, self.Enabled
end

PidConfiguration.SetPidPrintModeReq = TSetPidPrintModeReq

---@class PidConfiguration.GetVersionRsp
local TGetVersionRsp = {}
TGetVersionRsp.__index = TGetVersionRsp
TGetVersionRsp.group = {}

local function TGetVersionRsp_from_obj(obj)
    return setmetatable(obj, TGetVersionRsp)
end

function TGetVersionRsp.new()
    return TGetVersionRsp_from_obj({})
end
---@param obj PidConfiguration.GetVersionRsp
function TGetVersionRsp:init_from_obj(obj)

end

function TGetVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetVersionRsp.group)
end

TGetVersionRsp.from_obj = TGetVersionRsp_from_obj

TGetVersionRsp.proto_property = {}

TGetVersionRsp.default = {}

TGetVersionRsp.struct = {}

function TGetVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetVersionRsp.proto_property, errs, need_convert)
    return self
end

function TGetVersionRsp:unpack(_)
end

PidConfiguration.GetVersionRsp = TGetVersionRsp

---@class PidConfiguration.GetVersionReq
local TGetVersionReq = {}
TGetVersionReq.__index = TGetVersionReq
TGetVersionReq.group = {}

local function TGetVersionReq_from_obj(obj)
    return setmetatable(obj, TGetVersionReq)
end

function TGetVersionReq.new()
    return TGetVersionReq_from_obj({})
end
---@param obj PidConfiguration.GetVersionReq
function TGetVersionReq:init_from_obj(obj)

end

function TGetVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetVersionReq.group)
end

TGetVersionReq.from_obj = TGetVersionReq_from_obj

TGetVersionReq.proto_property = {}

TGetVersionReq.default = {}

TGetVersionReq.struct = {}

function TGetVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetVersionReq.proto_property, errs, need_convert)
    return self
end

function TGetVersionReq:unpack(_)
end

PidConfiguration.GetVersionReq = TGetVersionReq

PidConfiguration.interface = mdb.register_interface('bmc.kepler.Debug.PidConfiguration', {}, {
    GetVersion = {'a{ss}', '', TGetVersionReq, TGetVersionRsp, [=[Print PID version. For example: getpidver]=]},
    SetPidPrintMode = {
        'a{ss}yy', '', TSetPidPrintModeReq, TSetPidPrintModeRsp,
        [=[Set PID message output. For example: setpidprintmode 1 1]=]
    },
    SetPidConfigItem = {
        'a{ss}yy', '', TSetPidConfigItemReq, TSetPidConfigItemRsp,
        [=[Set PID module configuration items. For example: setpidconf 0 1]=]
    }
}, {})

return PidConfiguration
