-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-7-25
-- Description: DO NOT EDIT; Code generated by "model.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local pid_configuration_intf_types = require 'debug.json_types.PidConfiguration'
local properties_intf_types = require 'mdb.bmc.kepler.Object.PropertiesInterface'

local ThermalMgmtDebug = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Debug.PidConfiguration'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Debug.PidConfiguration'] = {
            ['GetVersion'] = {
                ['req'] = {},
                ['rsp'] = {},
                ['privilege'] = {'ReadOnly'},
                ['displayDescription'] = 'Print PID version. For example: getpidver',
                ['cmdName'] = 'getpidver'
            },
            ['SetPidPrintMode'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['displayDescription'] = 'PID message type, 1: configuration message, 2: control message.',
                        ['param'] = 'Type'
                    }, {
                        ['baseType'] = 'U8',
                        ['displayDescription'] = 'Indicate whether to enable to print PID message, 0: disable, 1: enable.',
                        ['param'] = 'Enabled'
                    }
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'},
                ['displayDescription'] = 'Set PID message output. For example: setpidprintmode 1 1',
                ['cmdName'] = 'setpidprintmode'
            },
            ['SetPidConfigItem'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['displayDescription'] = 'PID configuration item index, 0: high-temperature configuration item.',
                        ['param'] = 'ItemIndex'
                    },
                    {
                        ['baseType'] = 'U8',
                        ['displayDescription'] = 'Indicate configuration item value',
                        ['param'] = 'ItemValue'
                    }
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'},
                ['displayDescription'] = 'Set PID module configuration items. For example: setpidconf 0 1',
                ['cmdName'] = 'setpidconf'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Debug/ThermalMgmt'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Debug.PidConfiguration'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['methods'] = {
                    ['GetVersion'] = privilege.ReadOnly,
                    ['SetPidPrintMode'] = privilege.BasicSetting,
                    ['SetPidConfigItem'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = pid_configuration_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('ThermalMgmtDebug', ThermalMgmtDebug):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplThermalMgmtDebugPidConfigurationGetVersion(cb)
    class('ThermalMgmtDebug')['bmc.kepler.Debug.PidConfiguration'].GetVersion = function(obj, ctx, ...)
        local req = pid_configuration_intf_types.GetVersionReq.new(...):validate(nil, nil, true)
        local rsp = pid_configuration_intf_types.GetVersionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplThermalMgmtDebugPidConfigurationSetPidPrintMode(cb)
    class('ThermalMgmtDebug')['bmc.kepler.Debug.PidConfiguration'].SetPidPrintMode = function(obj, ctx, ...)
        local req = pid_configuration_intf_types.SetPidPrintModeReq.new(...):validate(nil, nil, true)
        local rsp = pid_configuration_intf_types.SetPidPrintModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplThermalMgmtDebugPidConfigurationSetPidConfigItem(cb)
    class('ThermalMgmtDebug')['bmc.kepler.Debug.PidConfiguration'].SetPidConfigItem = function(obj, ctx, ...)
        local req = pid_configuration_intf_types.SetPidConfigItemReq.new(...):validate(nil, nil, true)
        local rsp = pid_configuration_intf_types.SetPidConfigItemRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
