-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local Mprivate = {}

---@class Mprivate.CustomReadInfoRsp
---@field PwmTable integer[]
local TCustomReadInfoRsp = {}
TCustomReadInfoRsp.__index = TCustomReadInfoRsp
TCustomReadInfoRsp.group = {}

local function TCustomReadInfoRsp_from_obj(obj)
    return setmetatable(obj, TCustomReadInfoRsp)
end

function TCustomReadInfoRsp.new(PwmTable)
    return TCustomReadInfoRsp_from_obj({PwmTable = PwmTable})
end
---@param obj Mprivate.CustomReadInfoRsp
function TCustomReadInfoRsp:init_from_obj(obj)
    self.PwmTable = obj.PwmTable
end

function TCustomReadInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomReadInfoRsp.group)
end

TCustomReadInfoRsp.from_obj = TCustomReadInfoRsp_from_obj

TCustomReadInfoRsp.proto_property = {'PwmTable'}

TCustomReadInfoRsp.default = {{}}

TCustomReadInfoRsp.struct = {{name = 'PwmTable', is_array = true, struct = nil}}

function TCustomReadInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PwmTable', self.PwmTable, 'uint8', false, errs, need_convert)

    TCustomReadInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomReadInfoRsp.proto_property, errs, need_convert)
    return self
end

function TCustomReadInfoRsp:unpack(_)
    return self.PwmTable
end

Mprivate.CustomReadInfoRsp = TCustomReadInfoRsp

---@class Mprivate.CustomReadInfoReq
local TCustomReadInfoReq = {}
TCustomReadInfoReq.__index = TCustomReadInfoReq
TCustomReadInfoReq.group = {}

local function TCustomReadInfoReq_from_obj(obj)
    return setmetatable(obj, TCustomReadInfoReq)
end

function TCustomReadInfoReq.new()
    return TCustomReadInfoReq_from_obj({})
end
---@param obj Mprivate.CustomReadInfoReq
function TCustomReadInfoReq:init_from_obj(obj)

end

function TCustomReadInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomReadInfoReq.group)
end

TCustomReadInfoReq.from_obj = TCustomReadInfoReq_from_obj

TCustomReadInfoReq.proto_property = {}

TCustomReadInfoReq.default = {}

TCustomReadInfoReq.struct = {}

function TCustomReadInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCustomReadInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomReadInfoReq.proto_property, errs, need_convert)
    return self
end

function TCustomReadInfoReq:unpack(_)
end

Mprivate.CustomReadInfoReq = TCustomReadInfoReq

---@class Mprivate.CustomSetFanSpeedRsp
---@field Result integer
local TCustomSetFanSpeedRsp = {}
TCustomSetFanSpeedRsp.__index = TCustomSetFanSpeedRsp
TCustomSetFanSpeedRsp.group = {}

local function TCustomSetFanSpeedRsp_from_obj(obj)
    return setmetatable(obj, TCustomSetFanSpeedRsp)
end

function TCustomSetFanSpeedRsp.new(Result)
    return TCustomSetFanSpeedRsp_from_obj({Result = Result})
end
---@param obj Mprivate.CustomSetFanSpeedRsp
function TCustomSetFanSpeedRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TCustomSetFanSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetFanSpeedRsp.group)
end

TCustomSetFanSpeedRsp.from_obj = TCustomSetFanSpeedRsp_from_obj

TCustomSetFanSpeedRsp.proto_property = {'Result'}

TCustomSetFanSpeedRsp.default = {0}

TCustomSetFanSpeedRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TCustomSetFanSpeedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TCustomSetFanSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetFanSpeedRsp.proto_property, errs, need_convert)
    return self
end

function TCustomSetFanSpeedRsp:unpack(_)
    return self.Result
end

Mprivate.CustomSetFanSpeedRsp = TCustomSetFanSpeedRsp

---@class Mprivate.CustomSetFanSpeedReq
---@field Length integer
---@field Info integer[]
local TCustomSetFanSpeedReq = {}
TCustomSetFanSpeedReq.__index = TCustomSetFanSpeedReq
TCustomSetFanSpeedReq.group = {}

local function TCustomSetFanSpeedReq_from_obj(obj)
    return setmetatable(obj, TCustomSetFanSpeedReq)
end

function TCustomSetFanSpeedReq.new(Length, Info)
    return TCustomSetFanSpeedReq_from_obj({Length = Length, Info = Info})
end
---@param obj Mprivate.CustomSetFanSpeedReq
function TCustomSetFanSpeedReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Info = obj.Info
end

function TCustomSetFanSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetFanSpeedReq.group)
end

TCustomSetFanSpeedReq.from_obj = TCustomSetFanSpeedReq_from_obj

TCustomSetFanSpeedReq.proto_property = {'Length', 'Info'}

TCustomSetFanSpeedReq.default = {0, {}}

TCustomSetFanSpeedReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Info', is_array = true, struct = nil}
}

function TCustomSetFanSpeedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Info', self.Info, 'int16', false, errs, need_convert)

    TCustomSetFanSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetFanSpeedReq.proto_property, errs, need_convert)
    return self
end

function TCustomSetFanSpeedReq:unpack(_)
    return self.Length, self.Info
end

Mprivate.CustomSetFanSpeedReq = TCustomSetFanSpeedReq

---@class Mprivate.CustomSetSensorNameRsp
---@field Result integer
local TCustomSetSensorNameRsp = {}
TCustomSetSensorNameRsp.__index = TCustomSetSensorNameRsp
TCustomSetSensorNameRsp.group = {}

local function TCustomSetSensorNameRsp_from_obj(obj)
    return setmetatable(obj, TCustomSetSensorNameRsp)
end

function TCustomSetSensorNameRsp.new(Result)
    return TCustomSetSensorNameRsp_from_obj({Result = Result})
end
---@param obj Mprivate.CustomSetSensorNameRsp
function TCustomSetSensorNameRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TCustomSetSensorNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetSensorNameRsp.group)
end

TCustomSetSensorNameRsp.from_obj = TCustomSetSensorNameRsp_from_obj

TCustomSetSensorNameRsp.proto_property = {'Result'}

TCustomSetSensorNameRsp.default = {0}

TCustomSetSensorNameRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TCustomSetSensorNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TCustomSetSensorNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetSensorNameRsp.proto_property, errs, need_convert)
    return self
end

function TCustomSetSensorNameRsp:unpack(_)
    return self.Result
end

Mprivate.CustomSetSensorNameRsp = TCustomSetSensorNameRsp

---@class Mprivate.CustomSetSensorNameReq
---@field Length integer
---@field Info integer[]
local TCustomSetSensorNameReq = {}
TCustomSetSensorNameReq.__index = TCustomSetSensorNameReq
TCustomSetSensorNameReq.group = {}

local function TCustomSetSensorNameReq_from_obj(obj)
    return setmetatable(obj, TCustomSetSensorNameReq)
end

function TCustomSetSensorNameReq.new(Length, Info)
    return TCustomSetSensorNameReq_from_obj({Length = Length, Info = Info})
end
---@param obj Mprivate.CustomSetSensorNameReq
function TCustomSetSensorNameReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Info = obj.Info
end

function TCustomSetSensorNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetSensorNameReq.group)
end

TCustomSetSensorNameReq.from_obj = TCustomSetSensorNameReq_from_obj

TCustomSetSensorNameReq.proto_property = {'Length', 'Info'}

TCustomSetSensorNameReq.default = {0, {}}

TCustomSetSensorNameReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Info', is_array = true, struct = nil}
}

function TCustomSetSensorNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Info', self.Info, 'int16', false, errs, need_convert)

    TCustomSetSensorNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetSensorNameReq.proto_property, errs, need_convert)
    return self
end

function TCustomSetSensorNameReq:unpack(_)
    return self.Length, self.Info
end

Mprivate.CustomSetSensorNameReq = TCustomSetSensorNameReq

---@class Mprivate.CustomSetFanAlarmSpeedRsp
---@field Result integer
local TCustomSetFanAlarmSpeedRsp = {}
TCustomSetFanAlarmSpeedRsp.__index = TCustomSetFanAlarmSpeedRsp
TCustomSetFanAlarmSpeedRsp.group = {}

local function TCustomSetFanAlarmSpeedRsp_from_obj(obj)
    return setmetatable(obj, TCustomSetFanAlarmSpeedRsp)
end

function TCustomSetFanAlarmSpeedRsp.new(Result)
    return TCustomSetFanAlarmSpeedRsp_from_obj({Result = Result})
end
---@param obj Mprivate.CustomSetFanAlarmSpeedRsp
function TCustomSetFanAlarmSpeedRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TCustomSetFanAlarmSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetFanAlarmSpeedRsp.group)
end

TCustomSetFanAlarmSpeedRsp.from_obj = TCustomSetFanAlarmSpeedRsp_from_obj

TCustomSetFanAlarmSpeedRsp.proto_property = {'Result'}

TCustomSetFanAlarmSpeedRsp.default = {0}

TCustomSetFanAlarmSpeedRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TCustomSetFanAlarmSpeedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TCustomSetFanAlarmSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetFanAlarmSpeedRsp.proto_property, errs, need_convert)
    return self
end

function TCustomSetFanAlarmSpeedRsp:unpack(_)
    return self.Result
end

Mprivate.CustomSetFanAlarmSpeedRsp = TCustomSetFanAlarmSpeedRsp

---@class Mprivate.CustomSetFanAlarmSpeedReq
---@field Length integer
---@field Info integer[]
local TCustomSetFanAlarmSpeedReq = {}
TCustomSetFanAlarmSpeedReq.__index = TCustomSetFanAlarmSpeedReq
TCustomSetFanAlarmSpeedReq.group = {}

local function TCustomSetFanAlarmSpeedReq_from_obj(obj)
    return setmetatable(obj, TCustomSetFanAlarmSpeedReq)
end

function TCustomSetFanAlarmSpeedReq.new(Length, Info)
    return TCustomSetFanAlarmSpeedReq_from_obj({Length = Length, Info = Info})
end
---@param obj Mprivate.CustomSetFanAlarmSpeedReq
function TCustomSetFanAlarmSpeedReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Info = obj.Info
end

function TCustomSetFanAlarmSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetFanAlarmSpeedReq.group)
end

TCustomSetFanAlarmSpeedReq.from_obj = TCustomSetFanAlarmSpeedReq_from_obj

TCustomSetFanAlarmSpeedReq.proto_property = {'Length', 'Info'}

TCustomSetFanAlarmSpeedReq.default = {0, {}}

TCustomSetFanAlarmSpeedReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Info', is_array = true, struct = nil}
}

function TCustomSetFanAlarmSpeedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Info', self.Info, 'int16', false, errs, need_convert)

    TCustomSetFanAlarmSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetFanAlarmSpeedReq.proto_property, errs, need_convert)
    return self
end

function TCustomSetFanAlarmSpeedReq:unpack(_)
    return self.Length, self.Info
end

Mprivate.CustomSetFanAlarmSpeedReq = TCustomSetFanAlarmSpeedReq

---@class Mprivate.CustomSetEnvTempConfigRsp
---@field Result integer
local TCustomSetEnvTempConfigRsp = {}
TCustomSetEnvTempConfigRsp.__index = TCustomSetEnvTempConfigRsp
TCustomSetEnvTempConfigRsp.group = {}

local function TCustomSetEnvTempConfigRsp_from_obj(obj)
    return setmetatable(obj, TCustomSetEnvTempConfigRsp)
end

function TCustomSetEnvTempConfigRsp.new(Result)
    return TCustomSetEnvTempConfigRsp_from_obj({Result = Result})
end
---@param obj Mprivate.CustomSetEnvTempConfigRsp
function TCustomSetEnvTempConfigRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TCustomSetEnvTempConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetEnvTempConfigRsp.group)
end

TCustomSetEnvTempConfigRsp.from_obj = TCustomSetEnvTempConfigRsp_from_obj

TCustomSetEnvTempConfigRsp.proto_property = {'Result'}

TCustomSetEnvTempConfigRsp.default = {0}

TCustomSetEnvTempConfigRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TCustomSetEnvTempConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TCustomSetEnvTempConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetEnvTempConfigRsp.proto_property, errs, need_convert)
    return self
end

function TCustomSetEnvTempConfigRsp:unpack(_)
    return self.Result
end

Mprivate.CustomSetEnvTempConfigRsp = TCustomSetEnvTempConfigRsp

---@class Mprivate.CustomSetEnvTempConfigReq
---@field Length integer
---@field Info integer[]
local TCustomSetEnvTempConfigReq = {}
TCustomSetEnvTempConfigReq.__index = TCustomSetEnvTempConfigReq
TCustomSetEnvTempConfigReq.group = {}

local function TCustomSetEnvTempConfigReq_from_obj(obj)
    return setmetatable(obj, TCustomSetEnvTempConfigReq)
end

function TCustomSetEnvTempConfigReq.new(Length, Info)
    return TCustomSetEnvTempConfigReq_from_obj({Length = Length, Info = Info})
end
---@param obj Mprivate.CustomSetEnvTempConfigReq
function TCustomSetEnvTempConfigReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Info = obj.Info
end

function TCustomSetEnvTempConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetEnvTempConfigReq.group)
end

TCustomSetEnvTempConfigReq.from_obj = TCustomSetEnvTempConfigReq_from_obj

TCustomSetEnvTempConfigReq.proto_property = {'Length', 'Info'}

TCustomSetEnvTempConfigReq.default = {0, {}}

TCustomSetEnvTempConfigReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Info', is_array = true, struct = nil}
}

function TCustomSetEnvTempConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Info', self.Info, 'int16', false, errs, need_convert)

    TCustomSetEnvTempConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetEnvTempConfigReq.proto_property, errs, need_convert)
    return self
end

function TCustomSetEnvTempConfigReq:unpack(_)
    return self.Length, self.Info
end

Mprivate.CustomSetEnvTempConfigReq = TCustomSetEnvTempConfigReq

---@class Mprivate.CustomSetRealTimeTempRsp
---@field Result integer
local TCustomSetRealTimeTempRsp = {}
TCustomSetRealTimeTempRsp.__index = TCustomSetRealTimeTempRsp
TCustomSetRealTimeTempRsp.group = {}

local function TCustomSetRealTimeTempRsp_from_obj(obj)
    return setmetatable(obj, TCustomSetRealTimeTempRsp)
end

function TCustomSetRealTimeTempRsp.new(Result)
    return TCustomSetRealTimeTempRsp_from_obj({Result = Result})
end
---@param obj Mprivate.CustomSetRealTimeTempRsp
function TCustomSetRealTimeTempRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TCustomSetRealTimeTempRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetRealTimeTempRsp.group)
end

TCustomSetRealTimeTempRsp.from_obj = TCustomSetRealTimeTempRsp_from_obj

TCustomSetRealTimeTempRsp.proto_property = {'Result'}

TCustomSetRealTimeTempRsp.default = {0}

TCustomSetRealTimeTempRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TCustomSetRealTimeTempRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TCustomSetRealTimeTempRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetRealTimeTempRsp.proto_property, errs, need_convert)
    return self
end

function TCustomSetRealTimeTempRsp:unpack(_)
    return self.Result
end

Mprivate.CustomSetRealTimeTempRsp = TCustomSetRealTimeTempRsp

---@class Mprivate.CustomSetRealTimeTempReq
---@field Length integer
---@field Info integer[]
local TCustomSetRealTimeTempReq = {}
TCustomSetRealTimeTempReq.__index = TCustomSetRealTimeTempReq
TCustomSetRealTimeTempReq.group = {}

local function TCustomSetRealTimeTempReq_from_obj(obj)
    return setmetatable(obj, TCustomSetRealTimeTempReq)
end

function TCustomSetRealTimeTempReq.new(Length, Info)
    return TCustomSetRealTimeTempReq_from_obj({Length = Length, Info = Info})
end
---@param obj Mprivate.CustomSetRealTimeTempReq
function TCustomSetRealTimeTempReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Info = obj.Info
end

function TCustomSetRealTimeTempReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetRealTimeTempReq.group)
end

TCustomSetRealTimeTempReq.from_obj = TCustomSetRealTimeTempReq_from_obj

TCustomSetRealTimeTempReq.proto_property = {'Length', 'Info'}

TCustomSetRealTimeTempReq.default = {0, {}}

TCustomSetRealTimeTempReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Info', is_array = true, struct = nil}
}

function TCustomSetRealTimeTempReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Info', self.Info, 'int16', false, errs, need_convert)

    TCustomSetRealTimeTempReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetRealTimeTempReq.proto_property, errs, need_convert)
    return self
end

function TCustomSetRealTimeTempReq:unpack(_)
    return self.Length, self.Info
end

Mprivate.CustomSetRealTimeTempReq = TCustomSetRealTimeTempReq

---@class Mprivate.CustomSetFanConfigRsp
---@field Result integer
local TCustomSetFanConfigRsp = {}
TCustomSetFanConfigRsp.__index = TCustomSetFanConfigRsp
TCustomSetFanConfigRsp.group = {}

local function TCustomSetFanConfigRsp_from_obj(obj)
    return setmetatable(obj, TCustomSetFanConfigRsp)
end

function TCustomSetFanConfigRsp.new(Result)
    return TCustomSetFanConfigRsp_from_obj({Result = Result})
end
---@param obj Mprivate.CustomSetFanConfigRsp
function TCustomSetFanConfigRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TCustomSetFanConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetFanConfigRsp.group)
end

TCustomSetFanConfigRsp.from_obj = TCustomSetFanConfigRsp_from_obj

TCustomSetFanConfigRsp.proto_property = {'Result'}

TCustomSetFanConfigRsp.default = {0}

TCustomSetFanConfigRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TCustomSetFanConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TCustomSetFanConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetFanConfigRsp.proto_property, errs, need_convert)
    return self
end

function TCustomSetFanConfigRsp:unpack(_)
    return self.Result
end

Mprivate.CustomSetFanConfigRsp = TCustomSetFanConfigRsp

---@class Mprivate.CustomSetFanConfigReq
---@field Length integer
---@field Info integer[]
local TCustomSetFanConfigReq = {}
TCustomSetFanConfigReq.__index = TCustomSetFanConfigReq
TCustomSetFanConfigReq.group = {}

local function TCustomSetFanConfigReq_from_obj(obj)
    return setmetatable(obj, TCustomSetFanConfigReq)
end

function TCustomSetFanConfigReq.new(Length, Info)
    return TCustomSetFanConfigReq_from_obj({Length = Length, Info = Info})
end
---@param obj Mprivate.CustomSetFanConfigReq
function TCustomSetFanConfigReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Info = obj.Info
end

function TCustomSetFanConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetFanConfigReq.group)
end

TCustomSetFanConfigReq.from_obj = TCustomSetFanConfigReq_from_obj

TCustomSetFanConfigReq.proto_property = {'Length', 'Info'}

TCustomSetFanConfigReq.default = {0, {}}

TCustomSetFanConfigReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Info', is_array = true, struct = nil}
}

function TCustomSetFanConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Info', self.Info, 'int16', false, errs, need_convert)

    TCustomSetFanConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetFanConfigReq.proto_property, errs, need_convert)
    return self
end

function TCustomSetFanConfigReq:unpack(_)
    return self.Length, self.Info
end

Mprivate.CustomSetFanConfigReq = TCustomSetFanConfigReq

---@class Mprivate.CustomSetTargetTempConfigRsp
---@field Result integer
local TCustomSetTargetTempConfigRsp = {}
TCustomSetTargetTempConfigRsp.__index = TCustomSetTargetTempConfigRsp
TCustomSetTargetTempConfigRsp.group = {}

local function TCustomSetTargetTempConfigRsp_from_obj(obj)
    return setmetatable(obj, TCustomSetTargetTempConfigRsp)
end

function TCustomSetTargetTempConfigRsp.new(Result)
    return TCustomSetTargetTempConfigRsp_from_obj({Result = Result})
end
---@param obj Mprivate.CustomSetTargetTempConfigRsp
function TCustomSetTargetTempConfigRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TCustomSetTargetTempConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetTargetTempConfigRsp.group)
end

TCustomSetTargetTempConfigRsp.from_obj = TCustomSetTargetTempConfigRsp_from_obj

TCustomSetTargetTempConfigRsp.proto_property = {'Result'}

TCustomSetTargetTempConfigRsp.default = {0}

TCustomSetTargetTempConfigRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TCustomSetTargetTempConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TCustomSetTargetTempConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetTargetTempConfigRsp.proto_property, errs, need_convert)
    return self
end

function TCustomSetTargetTempConfigRsp:unpack(_)
    return self.Result
end

Mprivate.CustomSetTargetTempConfigRsp = TCustomSetTargetTempConfigRsp

---@class Mprivate.CustomSetTargetTempConfigReq
---@field Length integer
---@field Info integer[]
local TCustomSetTargetTempConfigReq = {}
TCustomSetTargetTempConfigReq.__index = TCustomSetTargetTempConfigReq
TCustomSetTargetTempConfigReq.group = {}

local function TCustomSetTargetTempConfigReq_from_obj(obj)
    return setmetatable(obj, TCustomSetTargetTempConfigReq)
end

function TCustomSetTargetTempConfigReq.new(Length, Info)
    return TCustomSetTargetTempConfigReq_from_obj({Length = Length, Info = Info})
end
---@param obj Mprivate.CustomSetTargetTempConfigReq
function TCustomSetTargetTempConfigReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Info = obj.Info
end

function TCustomSetTargetTempConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomSetTargetTempConfigReq.group)
end

TCustomSetTargetTempConfigReq.from_obj = TCustomSetTargetTempConfigReq_from_obj

TCustomSetTargetTempConfigReq.proto_property = {'Length', 'Info'}

TCustomSetTargetTempConfigReq.default = {0, {}}

TCustomSetTargetTempConfigReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Info', is_array = true, struct = nil}
}

function TCustomSetTargetTempConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Info', self.Info, 'int16', false, errs, need_convert)

    TCustomSetTargetTempConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomSetTargetTempConfigReq.proto_property, errs, need_convert)
    return self
end

function TCustomSetTargetTempConfigReq:unpack(_)
    return self.Length, self.Info
end

Mprivate.CustomSetTargetTempConfigReq = TCustomSetTargetTempConfigReq

---@class Mprivate.CustomPidCountValueRsp
local TCustomPidCountValueRsp = {}
TCustomPidCountValueRsp.__index = TCustomPidCountValueRsp
TCustomPidCountValueRsp.group = {}

local function TCustomPidCountValueRsp_from_obj(obj)
    return setmetatable(obj, TCustomPidCountValueRsp)
end

function TCustomPidCountValueRsp.new()
    return TCustomPidCountValueRsp_from_obj({})
end
---@param obj Mprivate.CustomPidCountValueRsp
function TCustomPidCountValueRsp:init_from_obj(obj)

end

function TCustomPidCountValueRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomPidCountValueRsp.group)
end

TCustomPidCountValueRsp.from_obj = TCustomPidCountValueRsp_from_obj

TCustomPidCountValueRsp.proto_property = {}

TCustomPidCountValueRsp.default = {}

TCustomPidCountValueRsp.struct = {}

function TCustomPidCountValueRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCustomPidCountValueRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomPidCountValueRsp.proto_property, errs, need_convert)
    return self
end

function TCustomPidCountValueRsp:unpack(_)
end

Mprivate.CustomPidCountValueRsp = TCustomPidCountValueRsp

---@class Mprivate.CustomPidCountValueReq
local TCustomPidCountValueReq = {}
TCustomPidCountValueReq.__index = TCustomPidCountValueReq
TCustomPidCountValueReq.group = {}

local function TCustomPidCountValueReq_from_obj(obj)
    return setmetatable(obj, TCustomPidCountValueReq)
end

function TCustomPidCountValueReq.new()
    return TCustomPidCountValueReq_from_obj({})
end
---@param obj Mprivate.CustomPidCountValueReq
function TCustomPidCountValueReq:init_from_obj(obj)

end

function TCustomPidCountValueReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomPidCountValueReq.group)
end

TCustomPidCountValueReq.from_obj = TCustomPidCountValueReq_from_obj

TCustomPidCountValueReq.proto_property = {}

TCustomPidCountValueReq.default = {}

TCustomPidCountValueReq.struct = {}

function TCustomPidCountValueReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCustomPidCountValueReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomPidCountValueReq.proto_property, errs, need_convert)
    return self
end

function TCustomPidCountValueReq:unpack(_)
end

Mprivate.CustomPidCountValueReq = TCustomPidCountValueReq

---@class Mprivate.CustomPidUpdateSensorValueRsp
local TCustomPidUpdateSensorValueRsp = {}
TCustomPidUpdateSensorValueRsp.__index = TCustomPidUpdateSensorValueRsp
TCustomPidUpdateSensorValueRsp.group = {}

local function TCustomPidUpdateSensorValueRsp_from_obj(obj)
    return setmetatable(obj, TCustomPidUpdateSensorValueRsp)
end

function TCustomPidUpdateSensorValueRsp.new()
    return TCustomPidUpdateSensorValueRsp_from_obj({})
end
---@param obj Mprivate.CustomPidUpdateSensorValueRsp
function TCustomPidUpdateSensorValueRsp:init_from_obj(obj)

end

function TCustomPidUpdateSensorValueRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomPidUpdateSensorValueRsp.group)
end

TCustomPidUpdateSensorValueRsp.from_obj = TCustomPidUpdateSensorValueRsp_from_obj

TCustomPidUpdateSensorValueRsp.proto_property = {}

TCustomPidUpdateSensorValueRsp.default = {}

TCustomPidUpdateSensorValueRsp.struct = {}

function TCustomPidUpdateSensorValueRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCustomPidUpdateSensorValueRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomPidUpdateSensorValueRsp.proto_property, errs, need_convert)
    return self
end

function TCustomPidUpdateSensorValueRsp:unpack(_)
end

Mprivate.CustomPidUpdateSensorValueRsp = TCustomPidUpdateSensorValueRsp

---@class Mprivate.CustomPidUpdateSensorValueReq
local TCustomPidUpdateSensorValueReq = {}
TCustomPidUpdateSensorValueReq.__index = TCustomPidUpdateSensorValueReq
TCustomPidUpdateSensorValueReq.group = {}

local function TCustomPidUpdateSensorValueReq_from_obj(obj)
    return setmetatable(obj, TCustomPidUpdateSensorValueReq)
end

function TCustomPidUpdateSensorValueReq.new()
    return TCustomPidUpdateSensorValueReq_from_obj({})
end
---@param obj Mprivate.CustomPidUpdateSensorValueReq
function TCustomPidUpdateSensorValueReq:init_from_obj(obj)

end

function TCustomPidUpdateSensorValueReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomPidUpdateSensorValueReq.group)
end

TCustomPidUpdateSensorValueReq.from_obj = TCustomPidUpdateSensorValueReq_from_obj

TCustomPidUpdateSensorValueReq.proto_property = {}

TCustomPidUpdateSensorValueReq.default = {}

TCustomPidUpdateSensorValueReq.struct = {}

function TCustomPidUpdateSensorValueReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCustomPidUpdateSensorValueReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomPidUpdateSensorValueReq.proto_property, errs, need_convert)
    return self
end

function TCustomPidUpdateSensorValueReq:unpack(_)
end

Mprivate.CustomPidUpdateSensorValueReq = TCustomPidUpdateSensorValueReq

---@class Mprivate.CustomTarTempCtrInitRsp
local TCustomTarTempCtrInitRsp = {}
TCustomTarTempCtrInitRsp.__index = TCustomTarTempCtrInitRsp
TCustomTarTempCtrInitRsp.group = {}

local function TCustomTarTempCtrInitRsp_from_obj(obj)
    return setmetatable(obj, TCustomTarTempCtrInitRsp)
end

function TCustomTarTempCtrInitRsp.new()
    return TCustomTarTempCtrInitRsp_from_obj({})
end
---@param obj Mprivate.CustomTarTempCtrInitRsp
function TCustomTarTempCtrInitRsp:init_from_obj(obj)

end

function TCustomTarTempCtrInitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomTarTempCtrInitRsp.group)
end

TCustomTarTempCtrInitRsp.from_obj = TCustomTarTempCtrInitRsp_from_obj

TCustomTarTempCtrInitRsp.proto_property = {}

TCustomTarTempCtrInitRsp.default = {}

TCustomTarTempCtrInitRsp.struct = {}

function TCustomTarTempCtrInitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCustomTarTempCtrInitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomTarTempCtrInitRsp.proto_property, errs, need_convert)
    return self
end

function TCustomTarTempCtrInitRsp:unpack(_)
end

Mprivate.CustomTarTempCtrInitRsp = TCustomTarTempCtrInitRsp

---@class Mprivate.CustomTarTempCtrInitReq
local TCustomTarTempCtrInitReq = {}
TCustomTarTempCtrInitReq.__index = TCustomTarTempCtrInitReq
TCustomTarTempCtrInitReq.group = {}

local function TCustomTarTempCtrInitReq_from_obj(obj)
    return setmetatable(obj, TCustomTarTempCtrInitReq)
end

function TCustomTarTempCtrInitReq.new()
    return TCustomTarTempCtrInitReq_from_obj({})
end
---@param obj Mprivate.CustomTarTempCtrInitReq
function TCustomTarTempCtrInitReq:init_from_obj(obj)

end

function TCustomTarTempCtrInitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomTarTempCtrInitReq.group)
end

TCustomTarTempCtrInitReq.from_obj = TCustomTarTempCtrInitReq_from_obj

TCustomTarTempCtrInitReq.proto_property = {}

TCustomTarTempCtrInitReq.default = {}

TCustomTarTempCtrInitReq.struct = {}

function TCustomTarTempCtrInitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCustomTarTempCtrInitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomTarTempCtrInitReq.proto_property, errs, need_convert)
    return self
end

function TCustomTarTempCtrInitReq:unpack(_)
end

Mprivate.CustomTarTempCtrInitReq = TCustomTarTempCtrInitReq

return Mprivate
