-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MValves = {}

---@class MValves.InvalidLocationId
---@field InvalidLocationId integer
local TInvalidLocationId = {}
TInvalidLocationId.__index = TInvalidLocationId
TInvalidLocationId.group = {}

local function TInvalidLocationId_from_obj(obj)
    return setmetatable(obj, TInvalidLocationId)
end

function TInvalidLocationId.new(InvalidLocationId)
    return TInvalidLocationId_from_obj({InvalidLocationId = InvalidLocationId or 0})
end
---@param obj MValves.InvalidLocationId
function TInvalidLocationId:init_from_obj(obj)
    self.InvalidLocationId = obj.InvalidLocationId or 0
end

function TInvalidLocationId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInvalidLocationId.group)
end

TInvalidLocationId.from_obj = TInvalidLocationId_from_obj

TInvalidLocationId.proto_property = {'InvalidLocationId'}

TInvalidLocationId.default = {0}

TInvalidLocationId.struct = {{name = 'InvalidLocationId', is_array = false, struct = nil}}

function TInvalidLocationId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InvalidLocationId', self.InvalidLocationId, 'uint8', false, errs, need_convert)

    TInvalidLocationId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInvalidLocationId.proto_property, errs, need_convert)
    return self
end

function TInvalidLocationId:unpack(_)
    return self.InvalidLocationId
end

MValves.InvalidLocationId = TInvalidLocationId

---@class MValves.PatrolType
---@field PatrolType integer
local TPatrolType = {}
TPatrolType.__index = TPatrolType
TPatrolType.group = {}

local function TPatrolType_from_obj(obj)
    return setmetatable(obj, TPatrolType)
end

function TPatrolType.new(PatrolType)
    return TPatrolType_from_obj({PatrolType = PatrolType or 0})
end
---@param obj MValves.PatrolType
function TPatrolType:init_from_obj(obj)
    self.PatrolType = obj.PatrolType or 0
end

function TPatrolType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPatrolType.group)
end

TPatrolType.from_obj = TPatrolType_from_obj

TPatrolType.proto_property = {'PatrolType'}

TPatrolType.default = {0}

TPatrolType.struct = {{name = 'PatrolType', is_array = false, struct = nil}}

function TPatrolType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PatrolType', self.PatrolType, 'uint8', false, errs, need_convert)

    TPatrolType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPatrolType.proto_property, errs, need_convert)
    return self
end

function TPatrolType:unpack(_)
    return self.PatrolType
end

MValves.PatrolType = TPatrolType

---@class MValves.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or [=[0]=]})
end
---@param obj MValves.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or [=[0]=]
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MValves.Id = TId

return MValves
