-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFanGroup = {}

---@class MFanGroup.ResetSpeedPercent
---@field ResetSpeedPercent integer
local TResetSpeedPercent = {}
TResetSpeedPercent.__index = TResetSpeedPercent
TResetSpeedPercent.group = {}

local function TResetSpeedPercent_from_obj(obj)
    return setmetatable(obj, TResetSpeedPercent)
end

function TResetSpeedPercent.new(ResetSpeedPercent)
    return TResetSpeedPercent_from_obj({ResetSpeedPercent = ResetSpeedPercent or 100})
end
---@param obj MFanGroup.ResetSpeedPercent
function TResetSpeedPercent:init_from_obj(obj)
    self.ResetSpeedPercent = obj.ResetSpeedPercent or 100
end

function TResetSpeedPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetSpeedPercent.group)
end

TResetSpeedPercent.from_obj = TResetSpeedPercent_from_obj

TResetSpeedPercent.proto_property = {'ResetSpeedPercent'}

TResetSpeedPercent.default = {0}

TResetSpeedPercent.struct = {{name = 'ResetSpeedPercent', is_array = false, struct = nil}}

function TResetSpeedPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetSpeedPercent', self.ResetSpeedPercent, 'uint8', false, errs, need_convert)

    TResetSpeedPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetSpeedPercent.proto_property, errs, need_convert)
    return self
end

function TResetSpeedPercent:unpack(_)
    return self.ResetSpeedPercent
end

MFanGroup.ResetSpeedPercent = TResetSpeedPercent

return MFanGroup
