-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'
require'mc.plugin.loader'.load()
local Feature1 = require'thermal_mgmt.features.Feature1'.get_instance()

local fan_class_types = require 'class.types.Fan'
local fan_type_class_types = require 'class.types.FanType'
local fan_info_class_types = require 'class.types.FanInfo'
local thermal_configuration_class_types = require 'class.types.ThermalConfiguration'
local pwm_channel_class_types = require 'class.types.PWMChannel'
local systems_fans_class_types = require 'class.types.SystemsFans'
local fans_class_types = require 'class.types.Fans'
local pumps_class_types = require 'class.types.Pumps'
local pump_class_types = require 'class.types.Pump'
local valves_class_types = require 'class.types.Valves'
local basic_cooling_config_class_types = require 'class.types.BasicCoolingConfig'
local fan_group_class_types = require 'class.types.FanGroup'
local fan_group_policy_class_types = require 'class.types.FanGroupPolicy'
local cooling_config_class_types = require 'class.types.CoolingConfig'
local air_cooling_config_class_types = require 'class.types.AirCoolingConfig'
local liquid_cooling_config_class_types = require 'class.types.LiquidCoolingConfig'
local cooling_fan_class_types = require 'class.types.CoolingFan'
local cooling_requirement_class_types = require 'class.types.CoolingRequirement'
local cooling_policy_class_types = require 'class.types.CoolingPolicy'
local cooling_area_class_types = require 'class.types.CoolingArea'
local abnormal_fan_class_types = require 'class.types.AbnormalFan'
local abnormal_pump_class_types = require 'class.types.AbnormalPump'
local thermal_subsystem_class_types = require 'class.types.ThermalSubsystem'
local private_class_types = require 'class.types.private'
local fan_intf_types = require 'thermal_mgmt.json_types.Fan'
local metric_intf_types = require 'thermal_mgmt.json_types.Metric'
local properties_intf_types = require 'mdb.bmc.kepler.Object.PropertiesInterface'
local fan_type_intf_types = require 'thermal_mgmt.json_types.FanType'
local fans_intf_types = require 'thermal_mgmt.json_types.Fans'
local systems_pumps_intf_types = require 'thermal_mgmt.json_types.SystemsPumps'
local pump_intf_types = require 'thermal_mgmt.json_types.Pump'
local valves_intf_types = require 'thermal_mgmt.json_types.Valves'
local valve_intf_types = require 'thermal_mgmt.json_types.Valve'
local fan_group_intf_types = require 'thermal_mgmt.json_types.FanGroup'
local pump_group_intf_types = require 'thermal_mgmt.json_types.PumpGroup'
local cooling_config_intf_types = require 'thermal_mgmt.json_types.CoolingConfig'
local disk_cooling_config_intf_types = require 'thermal_mgmt.json_types.DiskCoolingConfig'
local air_cooling_config_intf_types = require 'thermal_mgmt.json_types.AirCoolingConfig'
local fan_snapshot_intf_types = require 'thermal_mgmt.json_types.FanSnapshot'
local liquid_cooling_config_intf_types = require 'thermal_mgmt.json_types.LiquidCoolingConfig'
local cooling_fan_intf_types = require 'thermal_mgmt.json_types.CoolingFan'
local cooling_pump_intf_types = require 'thermal_mgmt.json_types.CoolingPump'
local cooling_requirement_intf_types = require 'thermal_mgmt.json_types.CoolingRequirement'
local cooling_policy_intf_types = require 'thermal_mgmt.json_types.CoolingPolicy'
local cooling_area_intf_types = require 'thermal_mgmt.json_types.CoolingArea'
local cooling_policies_intf_types = require 'thermal_mgmt.json_types.CoolingPolicies'
local thermal_subsystem_pumps_intf_types = require 'thermal_mgmt.json_types.ThermalSubsystemPumps'
local metrics_intf_types = require 'thermal_mgmt.json_types.Metrics'
local thermal_mgmt_intf_types = require 'thermal_mgmt.json_types.ThermalMgmt'
local thermal_control_strategy_intf_types = require 'thermal_mgmt.json_types.ThermalControlStrategy'

local Fan = {
    ['table_name'] = 't_fan',
    ['prop_configs'] = {
        ['FanObjectName'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = fan_class_types.FanObjectName
        },
        ['PowerGood'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = fan_class_types.PowerGood},
        ['DualConnector'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Connector',
            ['validator'] = fan_class_types.DualConnector
        },
        ['SingleConnector'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Connector',
            ['validator'] = fan_class_types.SingleConnector
        },
        ['IdentifyStatus'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = fan_class_types.IdentifyStatus}
    },
    ['default_props'] = {
        ['FanObjectName'] = fan_class_types.FanObjectName.default[1],
        ['PowerGood'] = fan_class_types.PowerGood.default[1],
        ['DualConnector'] = fan_class_types.DualConnector.default[1],
        ['SingleConnector'] = fan_class_types.SingleConnector.default[1],
        ['IdentifyStatus'] = 0
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Fan'] = {
            ['FanId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.FanId
            },
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.Slot
            },
            ['Type'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = fan_intf_types.Type},
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.Model
            },
            ['Coefficient'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.Coefficient
            },
            ['FanHealth'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = fan_intf_types.FanHealth},
            ['FanEntity'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = fan_intf_types.FanEntity},
            ['FrontPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.FrontPresence
            },
            ['RearPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.RearPresence
            },
            ['FrontSpeed'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.FrontSpeed
            },
            ['RearSpeed'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.RearSpeed
            },
            ['FrontStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = fan_intf_types.FrontStatus
            },
            ['RearStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = fan_intf_types.RearStatus
            },
            ['FrontRPM'] = {['baseType'] = 'U16', ['readOnly'] = true, ['validator'] = fan_intf_types.FrontRPM},
            ['RearRPM'] = {['baseType'] = 'U16', ['readOnly'] = true, ['validator'] = fan_intf_types.RearRPM},
            ['HardwarePWM'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.HardwarePWM
            },
            ['PWMPercentage'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['validator'] = fan_intf_types.PWMPercentage
            },
            ['ExpectedPWM'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.ExpectedPWM
            },
            ['FanAlarmLed'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = fan_intf_types.FanAlarmLed},
            ['BOM'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = fan_intf_types.BOM},
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.SystemId
            },
            ['MaxSupportedPWM'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.MaxSupportedPWM
            },
            ['IdentifySpeedLevel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.IdentifySpeedLevel
            },
            ['PartNumber'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = fan_intf_types.PartNumber},
            ['FrontMaxSpeed'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['validator'] = fan_intf_types.FrontMaxSpeed
            },
            ['RearMaxSpeed'] = {['baseType'] = 'U32', ['readOnly'] = true, ['validator'] = fan_intf_types.RearMaxSpeed},
            ['IsTwins'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.IsTwins
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.Position
            },
            ['SpeedStable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = fan_intf_types.SpeedStable
            },
            ['FunctionDesc'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.FunctionDesc
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_intf_types.DeviceName
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Fan'] = {
            ['SetFanPWM'] = {
                ['req'] = {{['baseType'] = 'Double', ['param'] = 'PWM'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Result'}}
            }
        },
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/DataCollectionItem'}, ['param'] = 'Val'}
                }
            },
            ['GetItems'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Component'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Classification'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Identification'},
                    {['baseType'] = 'String[]', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {['req'] = {{['baseType'] = 'U8', ['param'] = 'Enabled'}}, ['rsp'] = {}}
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Thermal/Fans/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Fan'] = {
            ['property_defaults'] = {
                ['FanId'] = fan_intf_types.FanId.default[1],
                ['Slot'] = fan_intf_types.Slot.default[1],
                ['Type'] = fan_intf_types.Type.default[1],
                ['Model'] = fan_intf_types.Model.default[1],
                ['Coefficient'] = fan_intf_types.Coefficient.default[1],
                ['FanHealth'] = fan_intf_types.FanHealth.default[1],
                ['FanEntity'] = fan_intf_types.FanEntity.default[1],
                ['FrontPresence'] = fan_intf_types.FrontPresence.default[1],
                ['RearPresence'] = fan_intf_types.RearPresence.default[1],
                ['FrontSpeed'] = fan_intf_types.FrontSpeed.default[1],
                ['RearSpeed'] = fan_intf_types.RearSpeed.default[1],
                ['FrontStatus'] = fan_intf_types.FrontStatus.default[1],
                ['RearStatus'] = fan_intf_types.RearStatus.default[1],
                ['FrontRPM'] = fan_intf_types.FrontRPM.default[1],
                ['RearRPM'] = fan_intf_types.RearRPM.default[1],
                ['HardwarePWM'] = fan_intf_types.HardwarePWM.default[1],
                ['PWMPercentage'] = fan_intf_types.PWMPercentage.default[1],
                ['ExpectedPWM'] = fan_intf_types.ExpectedPWM.default[1],
                ['FanAlarmLed'] = fan_intf_types.FanAlarmLed.default[1],
                ['BOM'] = fan_intf_types.BOM.default[1],
                ['SystemId'] = fan_intf_types.SystemId.default[1],
                ['MaxSupportedPWM'] = fan_intf_types.MaxSupportedPWM.default[1],
                ['IdentifySpeedLevel'] = fan_intf_types.IdentifySpeedLevel.default[1],
                ['PartNumber'] = fan_intf_types.PartNumber.default[1],
                ['FrontMaxSpeed'] = fan_intf_types.FrontMaxSpeed.default[1],
                ['RearMaxSpeed'] = fan_intf_types.RearMaxSpeed.default[1],
                ['IsTwins'] = fan_intf_types.IsTwins.default[1],
                ['Position'] = fan_intf_types.Position.default[1],
                ['SpeedStable'] = fan_intf_types.SpeedStable.default[1],
                ['FunctionDesc'] = fan_intf_types.FunctionDesc.default[1],
                ['DeviceName'] = fan_intf_types.DeviceName.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = fan_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local FanType = {
    ['table_name'] = 't_fan_type',
    ['prop_configs'] = {
        ['FanTypeObjectName'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = fan_type_class_types.FanTypeObjectName
        }
    },
    ['default_props'] = {['FanTypeObjectName'] = fan_type_class_types.FanTypeObjectName.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.FanType'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.Name
            },
            ['Index'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.Index
            },
            ['IsDefaultType'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.IsDefaultType
            },
            ['IsTwins'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.IsTwins
            },
            ['FrontMaxSpeed'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.FrontMaxSpeed
            },
            ['RearMaxSpeed'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.RearMaxSpeed
            },
            ['IdentifyRangeLow'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.IdentifyRangeLow
            },
            ['IdentifyRangeHigh'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.IdentifyRangeHigh
            },
            ['MatchedCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = fan_type_intf_types.MatchedCount
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.PartNumber
            },
            ['BOM'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.BOM
            },
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fan_type_intf_types.SystemId
            },
            ['SpeedRange'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = fan_type_intf_types.SpeedRange
            },
            ['PowerRange'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = fan_type_intf_types.PowerRange
            },
            ['FanDiameterMm'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = fan_type_intf_types.FanDiameterMm
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Thermal/FanTypes/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.FanType'] = {
            ['property_defaults'] = {
                ['Name'] = fan_type_intf_types.Name.default[1],
                ['Index'] = fan_type_intf_types.Index.default[1],
                ['IsDefaultType'] = fan_type_intf_types.IsDefaultType.default[1],
                ['IsTwins'] = fan_type_intf_types.IsTwins.default[1],
                ['FrontMaxSpeed'] = fan_type_intf_types.FrontMaxSpeed.default[1],
                ['RearMaxSpeed'] = fan_type_intf_types.RearMaxSpeed.default[1],
                ['IdentifyRangeLow'] = fan_type_intf_types.IdentifyRangeLow.default[1],
                ['IdentifyRangeHigh'] = fan_type_intf_types.IdentifyRangeHigh.default[1],
                ['MatchedCount'] = fan_type_intf_types.MatchedCount.default[1],
                ['PartNumber'] = fan_type_intf_types.PartNumber.default[1],
                ['BOM'] = fan_type_intf_types.BOM.default[1],
                ['SystemId'] = fan_type_intf_types.SystemId.default[1],
                ['SpeedRange'] = fan_type_intf_types.SpeedRange.default[1],
                ['PowerRange'] = fan_type_intf_types.PowerRange.default[1],
                ['FanDiameterMm'] = fan_type_intf_types.FanDiameterMm.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['SpeedRange'] = {['read'] = privilege.ReadOnly},
                    ['PowerRange'] = {['read'] = privilege.ReadOnly},
                    ['FanDiameterMm'] = {['read'] = privilege.ReadOnly}
                }
            },
            ['interface_types'] = fan_type_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local FanInfo = {
    ['table_name'] = 't_fan_info',
    ['prop_configs'] = {
        ['FanId'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['primaryKey'] = true,
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.FanId
        },
        ['SystemId'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['primaryKey'] = true,
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.SystemId
        },
        ['FanPosition'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['primaryKey'] = true,
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.FanPosition
        },
        ['Type'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.Type
        },
        ['Model'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.Model
        },
        ['BOM'] = {
            ['baseType'] = 'String',
            ['default'] = 'NA',
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.BOM
        },
        ['PartNumber'] = {
            ['baseType'] = 'String',
            ['default'] = 'NA',
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.PartNumber
        },
        ['FrontMaxSpeed'] = {
            ['baseType'] = 'U32',
            ['default'] = 10000,
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.FrontMaxSpeed
        },
        ['RearMaxSpeed'] = {
            ['baseType'] = 'U32',
            ['default'] = 10000,
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.RearMaxSpeed
        },
        ['IsTwins'] = {
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['usage'] = {'ResetPer'},
            ['validator'] = fan_info_class_types.IsTwins
        }
    },
    ['default_props'] = {
        ['FanId'] = 0,
        ['SystemId'] = 0,
        ['FanPosition'] = '',
        ['Type'] = 0,
        ['Model'] = '',
        ['BOM'] = 'NA',
        ['PartNumber'] = 'NA',
        ['FrontMaxSpeed'] = 10000,
        ['RearMaxSpeed'] = 10000,
        ['IsTwins'] = true
    }
}

local ThermalConfiguration = {
    ['table_name'] = 't_thermal_configuration',
    ['prop_configs'] = {
        ['StandbyFan'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = thermal_configuration_class_types.StandbyFan
        },
        ['FanStartSlot'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = thermal_configuration_class_types.FanStartSlot
        },
        ['Id'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['validator'] = thermal_configuration_class_types.Id
        }
    },
    ['default_props'] = {
        ['StandbyFan'] = 0,
        ['FanStartSlot'] = thermal_configuration_class_types.FanStartSlot.default[1],
        ['Id'] = 1
    }
}

local PWMChannel = {
    ['table_name'] = 't_pwm_channel',
    ['prop_configs'] = {
        ['PWMChannelObjectName'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = pwm_channel_class_types.PWMChannelObjectName
        },
        ['ManageFans'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = pwm_channel_class_types.ManageFans
        }
    },
    ['default_props'] = {
        ['PWMChannelObjectName'] = pwm_channel_class_types.PWMChannelObjectName.default[1],
        ['ManageFans'] = pwm_channel_class_types.ManageFans.default[1]
    }
}

local SystemsFans = {
    ['table_name'] = 't_systems_fans',
    ['prop_configs'] = {
        ['SystemId'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['validator'] = systems_fans_class_types.SystemId
        }
    },
    ['default_props'] = {['SystemId'] = 1},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Fans'] = {
            ['WorkInStandby'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = fans_intf_types.WorkInStandby
            },
            ['EstimatedTotalPowerWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = fans_intf_types.EstimatedTotalPowerWatts
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Fans'] = {
            ['SetPWM'] = {
                ['req'] = {{['baseType'] = 'Double[]', ['param'] = 'PWM'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Thermal/Fans'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Fans'] = {
            ['property_defaults'] = {
                ['WorkInStandby'] = fans_intf_types.WorkInStandby.default[1],
                ['EstimatedTotalPowerWatts'] = fans_intf_types.EstimatedTotalPowerWatts.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPWM'] = privilege.BasicSetting}},
            ['interface_types'] = fans_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Fans = {
    ['table_name'] = 't_fans',
    ['prop_configs'] = {
        ['FansObjectName'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = fans_class_types.FansObjectName
        },
        ['PWMChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = fans_class_types.PWMChip
        },
        ['SetPWMCmd'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = fans_class_types.SetPWMCmd},
        ['WorkInStandby'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = fans_class_types.WorkInStandby
        }
    },
    ['default_props'] = {
        ['FansObjectName'] = fans_class_types.FansObjectName.default[1],
        ['PWMChip'] = fans_class_types.PWMChip.default[1],
        ['SetPWMCmd'] = fans_class_types.SetPWMCmd.default[1],
        ['WorkInStandby'] = 0
    }
}

local Pumps = {
    ['table_name'] = 't_pumps',
    ['prop_configs'] = {
        ['PumpsObjectName'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = pumps_class_types.PumpsObjectName
        },
        ['PWMChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = pumps_class_types.PWMChip
        },
        ['SetPWMCmd'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = pumps_class_types.SetPWMCmd}
    },
    ['default_props'] = {
        ['PumpsObjectName'] = pumps_class_types.PumpsObjectName.default[1],
        ['PWMChip'] = pumps_class_types.PWMChip.default[1],
        ['SetPWMCmd'] = pumps_class_types.SetPWMCmd.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Pumps'] = {
            ['WorkInStandby'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['validator'] = systems_pumps_intf_types.WorkInStandby
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Pumps'] = {
            ['SetPWM'] = {
                ['req'] = {{['baseType'] = 'Double[]', ['param'] = 'PWM'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Thermal/Pumps'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Pumps'] = {
            ['property_defaults'] = {['WorkInStandby'] = systems_pumps_intf_types.WorkInStandby.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPWM'] = privilege.BasicSetting}},
            ['interface_types'] = systems_pumps_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Pump = {
    ['table_name'] = 't_pump',
    ['prop_configs'] = {
        ['PowerGood'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = pump_class_types.PowerGood}
    },
    ['default_props'] = {['PowerGood'] = pump_class_types.PowerGood.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Pump'] = {
            ['Id'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = pump_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.Slot
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.Model
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.PartNumber
            },
            ['ExpectedPWM'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.ExpectedPWM
            },
            ['ActualPWM'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.ActualPWM
            },
            ['MaxSupportedPWM'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.MaxSupportedPWM
            },
            ['SpeedRPM'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.SpeedRPM
            },
            ['MaxSpeedRPM'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.MaxSpeedRPM
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.Presence
            },
            ['Status'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = pump_intf_types.Status
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.Manufacturer
            },
            ['PhysicalContext'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'CPU', 'CPUSubsystem', 'Chassis', 'GPU', 'GPUSubsystem', ''},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.PhysicalContext
            },
            ['ProductionDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.ProductionDate
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.SerialNumber
            },
            ['ServiceLabel'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.ServiceLabel
            },
            ['LocationReference'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Bottom', 'Front', 'Left', 'Middle', 'Rear', 'Right', 'Top', ''},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.LocationReference
            },
            ['PumpType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Compressor', 'Liquid', ''},
                ['usage'] = {'CSR'},
                ['validator'] = pump_intf_types.PumpType
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Thermal/Pumps/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Pump'] = {
            ['property_defaults'] = {
                ['Id'] = pump_intf_types.Id.default[1],
                ['Slot'] = pump_intf_types.Slot.default[1],
                ['Model'] = pump_intf_types.Model.default[1],
                ['PartNumber'] = pump_intf_types.PartNumber.default[1],
                ['ExpectedPWM'] = pump_intf_types.ExpectedPWM.default[1],
                ['ActualPWM'] = pump_intf_types.ActualPWM.default[1],
                ['MaxSupportedPWM'] = pump_intf_types.MaxSupportedPWM.default[1],
                ['SpeedRPM'] = pump_intf_types.SpeedRPM.default[1],
                ['MaxSpeedRPM'] = pump_intf_types.MaxSpeedRPM.default[1],
                ['Presence'] = pump_intf_types.Presence.default[1],
                ['Status'] = pump_intf_types.Status.default[1],
                ['Manufacturer'] = pump_intf_types.Manufacturer.default[1],
                ['PhysicalContext'] = pump_intf_types.PhysicalContext.default[1],
                ['ProductionDate'] = pump_intf_types.ProductionDate.default[1],
                ['SerialNumber'] = pump_intf_types.SerialNumber.default[1],
                ['ServiceLabel'] = pump_intf_types.ServiceLabel.default[1],
                ['LocationReference'] = pump_intf_types.LocationReference.default[1],
                ['PumpType'] = pump_intf_types.PumpType.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = pump_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Valves = {
    ['table_name'] = 't_valves',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '0',
            ['validator'] = valves_class_types.Id
        },
        ['PatrolType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = valves_class_types.PatrolType
        },
        ['InvalidLocationId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = valves_class_types.InvalidLocationId
        }
    },
    ['default_props'] = {['Id'] = '0', ['PatrolType'] = 0, ['InvalidLocationId'] = 0},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Valves'] = {
            ['LastPatrolTimestamp'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['validator'] = valves_intf_types.LastPatrolTimestamp
            },
            ['PatrolState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Idle', 'Ready', 'Running'},
                ['validator'] = valves_intf_types.PatrolState
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.Valves'] = {
            ['StartPatrol'] = {
                ['req'] = {{['baseType'] = 'U32', ['param'] = 'DelaySeconds'}},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Thermal/Valves'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Valves'] = {
            ['property_defaults'] = {
                ['LastPatrolTimestamp'] = valves_intf_types.LastPatrolTimestamp.default[1],
                ['PatrolState'] = valves_intf_types.PatrolState.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['StartPatrol'] = privilege.BasicSetting}},
            ['interface_types'] = valves_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Valve = {
    ['table_name'] = 't_valve',
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Valve'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = valve_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = valve_intf_types.Slot
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = valve_intf_types.Presence
            },
            ['OpeningDegree'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = valve_intf_types.OpeningDegree
            },
            ['StandardOpeningDegree'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = valve_intf_types.StandardOpeningDegree
            },
            ['Status'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = valve_intf_types.Status
            },
            ['OpeningDegreeState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = valve_intf_types.OpeningDegreeState
            },
            ['PatrolResult'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = valve_intf_types.PatrolResult
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Thermal/Valves/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Valve'] = {
            ['property_defaults'] = {
                ['Id'] = valve_intf_types.Id.default[1],
                ['Slot'] = valve_intf_types.Slot.default[1],
                ['Presence'] = valve_intf_types.Presence.default[1],
                ['OpeningDegree'] = valve_intf_types.OpeningDegree.default[1],
                ['StandardOpeningDegree'] = valve_intf_types.StandardOpeningDegree.default[1],
                ['Status'] = valve_intf_types.Status.default[1],
                ['OpeningDegreeState'] = valve_intf_types.OpeningDegreeState.default[1],
                ['PatrolResult'] = valve_intf_types.PatrolResult.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['OpeningDegree'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting}}
            },
            ['interface_types'] = valve_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local BasicCoolingConfig = {
    ['table_name'] = 't_basic_cooling_config',
    ['prop_configs'] = {
        ['FanGroupSpeedDiffThresholdPercent'] = {
            ['baseType'] = 'S16',
            ['usage'] = {'CSR'},
            ['default'] = 32767,
            ['validator'] = basic_cooling_config_class_types.FanGroupSpeedDiffThresholdPercent
        },
        ['PsuFanSpeedCalibration'] = {
            ['baseType'] = 'S16',
            ['usage'] = {'CSR'},
            ['default'] = 32767,
            ['validator'] = basic_cooling_config_class_types.PsuFanSpeedCalibration
        },
        ['Id'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['validator'] = basic_cooling_config_class_types.Id
        }
    },
    ['default_props'] = {['FanGroupSpeedDiffThresholdPercent'] = 32767, ['PsuFanSpeedCalibration'] = 32767, ['Id'] = 1}
}

local FanGroup = {
    ['table_name'] = 't_fan_group',
    ['prop_configs'] = {
        ['ResetSpeedPercent'] = {
            ['default'] = 100,
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = fan_group_class_types.ResetSpeedPercent
        }
    },
    ['default_props'] = {['ResetSpeedPercent'] = 100},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.FanGroup'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = fan_group_intf_types.Id
            },
            ['FanSlots'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = fan_group_intf_types.FanSlots
            },
            ['SpeedPercent'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = fan_group_intf_types.SpeedPercent
            },
            ['ExpectedSpeedPercent'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'ResetPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = fan_group_intf_types.ExpectedSpeedPercent
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem/FanGroups/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.FanGroup'] = {
            ['property_defaults'] = {
                ['Id'] = fan_group_intf_types.Id.default[1],
                ['FanSlots'] = fan_group_intf_types.FanSlots.default[1],
                ['SpeedPercent'] = fan_group_intf_types.SpeedPercent.default[1],
                ['ExpectedSpeedPercent'] = fan_group_intf_types.ExpectedSpeedPercent.default[1]
            },
            ['privileges'] = {
                ['props'] = {
                    ['Id'] = {['read'] = privilege.ReadOnly},
                    ['FanSlots'] = {['read'] = privilege.ReadOnly},
                    ['SpeedPercent'] = {['read'] = privilege.ReadOnly},
                    ['ExpectedSpeedPercent'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting}
                }
            },
            ['interface_types'] = fan_group_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local FanGroupPolicy = {
    ['table_name'] = 't_fan_group_policy',
    ['prop_configs'] = {
        ['Id'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['validator'] = fan_group_policy_class_types.Id
        },
        ['PolicyType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = fan_group_policy_class_types.PolicyType
        },
        ['FanGroupIds'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = fan_group_policy_class_types.FanGroupIds
        },
        ['RelativeGroupIds'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = fan_group_policy_class_types.RelativeGroupIds
        },
        ['SpeedPercentDifference'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'S16',
            ['default'] = 32767,
            ['validator'] = fan_group_policy_class_types.SpeedPercentDifference
        }
    },
    ['default_props'] = {
        ['Id'] = fan_group_policy_class_types.Id.default[1],
        ['PolicyType'] = 0,
        ['FanGroupIds'] = fan_group_policy_class_types.FanGroupIds.default[1],
        ['RelativeGroupIds'] = fan_group_policy_class_types.RelativeGroupIds.default[1],
        ['SpeedPercentDifference'] = 32767
    }
}

local PumpGroup = {
    ['table_name'] = 't_pump_group',
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.PumpGroup'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = pump_group_intf_types.Id
            },
            ['PumpSlots'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = pump_group_intf_types.PumpSlots
            },
            ['SpeedPercent'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = pump_group_intf_types.SpeedPercent
            },
            ['ExpectedSpeedPercent'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'ResetPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = pump_group_intf_types.ExpectedSpeedPercent
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem/PumpGroups/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.PumpGroup'] = {
            ['property_defaults'] = {
                ['Id'] = pump_group_intf_types.Id.default[1],
                ['PumpSlots'] = pump_group_intf_types.PumpSlots.default[1],
                ['SpeedPercent'] = pump_group_intf_types.SpeedPercent.default[1],
                ['ExpectedSpeedPercent'] = pump_group_intf_types.ExpectedSpeedPercent.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Id'] = {['read'] = privilege.ReadOnly},
                    ['PumpSlots'] = {['read'] = privilege.ReadOnly},
                    ['SpeedPercent'] = {['read'] = privilege.ReadOnly},
                    ['ExpectedSpeedPercent'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting}
                }
            },
            ['interface_types'] = pump_group_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CoolingConfig = {
    ['table_name'] = 't_cooling_config',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['notAllowNull'] = true,
            ['validator'] = cooling_config_class_types.Id
        },
        ['MinimalLevel'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['default'] = 0,
            ['validator'] = cooling_config_class_types.MinimalLevel
        },
        ['MaxLimitLevel'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['default'] = 100,
            ['validator'] = cooling_config_class_types.MaxLimitLevel
        },
        ['FanLevel'] = {['baseType'] = 'U8', ['default'] = 20, ['validator'] = cooling_config_class_types.FanLevel},
        ['FanCtrlEnable'] = {
            ['baseType'] = 'String',
            ['default'] = 'Enabled',
            ['pattern'] = [=[^(Enabled|Disabled)$]=],
            ['validator'] = cooling_config_class_types.FanCtrlEnable
        },
        ['CoolingWay'] = {
            ['baseType'] = 'String',
            ['default'] = 'Proactive',
            ['pattern'] = [=[^(Proactive|Passive)$]=],
            ['validator'] = cooling_config_class_types.CoolingWay
        },
        ['FanBoardNum'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['default'] = 1,
            ['validator'] = cooling_config_class_types.FanBoardNum
        },
        ['OriginalSmartCoolingMode'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['default'] = '',
            ['validator'] = cooling_config_class_types.OriginalSmartCoolingMode
        },
        ['InitLevelInStartup'] = {
            ['usage'] = {'CSR', 'PoweroffPer'},
            ['baseType'] = 'U8',
            ['minimum'] = 0,
            ['maximum'] = 100,
            ['default'] = 100,
            ['notAllowNull'] = true,
            ['validator'] = cooling_config_class_types.InitLevelInStartup
        }
    },
    ['default_props'] = {
        ['Id'] = cooling_config_class_types.Id.default[1],
        ['MinimalLevel'] = 0,
        ['MaxLimitLevel'] = 100,
        ['FanLevel'] = 20,
        ['FanCtrlEnable'] = 'Enabled',
        ['CoolingWay'] = 'Proactive',
        ['FanBoardNum'] = 1,
        ['OriginalSmartCoolingMode'] = '',
        ['InitLevelInStartup'] = 100
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.CoolingConfig'] = {
            ['SmartCoolingState'] = {
                ['baseType'] = 'String',
                ['default'] = 'Enabled',
                ['readOnly'] = true,
                ['enum'] = {'Enabled', 'Disabled'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.SmartCoolingState
            },
            ['SmartCoolingMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'EnergySaving',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.SmartCoolingMode
            },
            ['Medium'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Air',
                ['enum'] = {'Air', 'Liquid', 'Air/Liquid'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.Medium
            },
            ['CtrlMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Auto',
                ['enum'] = {'Auto', 'Manual', 'Mixed'},
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.CtrlMode
            },
            ['TimeOut'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 30,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.TimeOut
            },
            ['ManualLevel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 10,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.ManualLevel
            },
            ['LevelPercentRange'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.LevelPercentRange
            },
            ['SensorLocationSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = false,
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.SensorLocationSupported
            },
            ['MinAllowedFanSpeedPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = cooling_config_intf_types.MinAllowedFanSpeedPercent
            },
            ['MinAllowedFanSpeedEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.MinAllowedFanSpeedEnabled
            },
            ['MixedModeSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_config_intf_types.MixedModeSupported
            }
        },
        ['bmc.kepler.Systems.DiskCoolingConfig'] = {
            ['DiskRowTemperatureAvailable'] = {
                ['baseType'] = 'Boolean',
                ['default'] = false,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.DiskRowTemperatureAvailable
            },
            ['SysHDDsMaxTemperature'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.SysHDDsMaxTemperature
            },
            ['SysSSDsMaxTemperature'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.SysSSDsMaxTemperature
            },
            ['SysM2sMaxTemperature'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.SysM2sMaxTemperature
            },
            ['SysAllSSDsMaxTemperature'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.SysAllSSDsMaxTemperature
            },
            ['FrontNVMeSSDMaxTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.FrontNVMeSSDMaxTemperatureCelsius
            },
            ['FrontHddMaxTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.FrontHddMaxTemperatureCelsius
            },
            ['RearNVMeSSDMaxTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.RearNVMeSSDMaxTemperatureCelsius
            },
            ['RearHddMaxTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['default'] = 32768,
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = disk_cooling_config_intf_types.RearHddMaxTemperatureCelsius
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.CoolingConfig'] = {
            ['SetCtrlMode'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'CtrlMode'}, {['baseType'] = 'U32', ['param'] = 'Timeout'}
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['SetManualLevel'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'UnitId'}, {['baseType'] = 'U8', ['param'] = 'Level'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetMedium'] = {
                ['req'] = {{['baseType'] = 'String', ['pattern'] = [=[^(Air|Liquid)$]=], ['param'] = 'Medium'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetSmartCoolingMode'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Mode'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetAbnormalPolicyEffectiveStatus'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Fan', 'Pump', 'Temperature', 'All'},
                        ['param'] = 'PolicyType'
                    }
                },
                ['rsp'] = {{['baseType'] = 'Boolean', ['param'] = 'EffectiveStatus'}},
                ['privilege'] = {'ReadOnly'}
            },
            ['SetMinPWM'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['pattern'] = [=[^(Fan|Pump)$]=],
                        ['enum'] = {'Fan', 'Pump'},
                        ['param'] = 'DeviceType'
                    }, {['baseType'] = 'U8[]', ['param'] = 'DeviceIds'},
                    {['baseType'] = 'U8[]', ['param'] = 'DeviceSpeeds'}
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetComponentThermalZone'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'ComponentType'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/ComponentThermalZone'},
                        ['param'] = 'ComponentThermalZone'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['GetCustomTargetTemperatures'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/CustomTargetTemperatureItem'},
                        ['param'] = 'CustomTargetTemperatures'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['SetMinAllowedFanSpeedEnabled'] = {
                ['req'] = {{['baseType'] = 'Boolean', ['param'] = 'MinAllowedFanSpeedEnabled'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/CoolingConfig'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.CoolingConfig'] = {
            ['property_defaults'] = {
                ['SmartCoolingState'] = 'Enabled',
                ['SmartCoolingMode'] = 'EnergySaving',
                ['Medium'] = 'Air',
                ['CtrlMode'] = 'Auto',
                ['TimeOut'] = 30,
                ['ManualLevel'] = 10,
                ['LevelPercentRange'] = cooling_config_intf_types.LevelPercentRange.default[1],
                ['SensorLocationSupported'] = false,
                ['MinAllowedFanSpeedPercent'] = 255,
                ['MinAllowedFanSpeedEnabled'] = false,
                ['MixedModeSupported'] = false
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['SmartCoolingState'] = {['read'] = privilege.ReadOnly},
                    ['SmartCoolingMode'] = {['read'] = privilege.ReadOnly},
                    ['Medium'] = {['read'] = privilege.ReadOnly},
                    ['CtrlMode'] = {['read'] = privilege.ReadOnly},
                    ['TimeOut'] = {['read'] = privilege.ReadOnly},
                    ['ManualLevel'] = {['read'] = privilege.ReadOnly},
                    ['LevelPercentRange'] = {['read'] = privilege.ReadOnly},
                    ['SensorLocationSupported'] = {['read'] = privilege.ReadOnly},
                    ['MinAllowedFanSpeedPercent'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['MinAllowedFanSpeedEnabled'] = {['read'] = privilege.ReadOnly},
                    ['MixedModeSupported'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {
                    ['SetCtrlMode'] = privilege.BasicSetting,
                    ['SetManualLevel'] = privilege.BasicSetting,
                    ['SetMedium'] = privilege.BasicSetting,
                    ['SetSmartCoolingMode'] = privilege.BasicSetting,
                    ['GetAbnormalPolicyEffectiveStatus'] = privilege.ReadOnly,
                    ['SetMinPWM'] = privilege.BasicSetting,
                    ['GetComponentThermalZone'] = privilege.ReadOnly,
                    ['GetCustomTargetTemperatures'] = privilege.ReadOnly,
                    ['SetMinAllowedFanSpeedEnabled'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = cooling_config_intf_types
        },
        ['bmc.kepler.Systems.DiskCoolingConfig'] = {
            ['property_defaults'] = {
                ['DiskRowTemperatureAvailable'] = false,
                ['SysHDDsMaxTemperature'] = 32768,
                ['SysSSDsMaxTemperature'] = 32768,
                ['SysM2sMaxTemperature'] = 32768,
                ['SysAllSSDsMaxTemperature'] = 32768,
                ['FrontNVMeSSDMaxTemperatureCelsius'] = 32768,
                ['FrontHddMaxTemperatureCelsius'] = 32768,
                ['RearNVMeSSDMaxTemperatureCelsius'] = 32768,
                ['RearHddMaxTemperatureCelsius'] = 32768
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['interface'] = privilege.ReadOnly},
            ['interface_types'] = disk_cooling_config_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local AirCoolingConfig = {
    ['table_name'] = 't_cooling_fans_config',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = air_cooling_config_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = air_cooling_config_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.AirCoolingConfig'] = {
            ['CtrlMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Auto',
                ['enum'] = {'Auto', 'Manual', 'Mixed'},
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.CtrlMode
            },
            ['CtrlModePersistType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PermanentPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.CtrlModePersistType
            },
            ['CtrlModeResetPersist'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Auto',
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'ResetPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.CtrlModeResetPersist
            },
            ['CtrlModePoweroffPersist'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Auto',
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.CtrlModePoweroffPersist
            },
            ['TimeOut'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 30,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.TimeOut
            },
            ['ManualSpeedPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['minimum'] = 0,
                ['maximum'] = 100,
                ['default'] = 10,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.ManualSpeedPercent
            },
            ['ManualSpeedPercentResetPersist'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['minimum'] = 0,
                ['maximum'] = 100,
                ['default'] = 0,
                ['usage'] = {'ResetPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.ManualSpeedPercentResetPersist
            },
            ['ManualSpeedPercentPoweroffPersist'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['minimum'] = 0,
                ['maximum'] = 100,
                ['default'] = 0,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.ManualSpeedPercentPoweroffPersist
            },
            ['SpeedPercentRange'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.SpeedPercentRange
            },
            ['MinAllowedSpeedPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'PoweroffPer', 'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = air_cooling_config_intf_types.MinAllowedSpeedPercent
            },
            ['InitialSpeedPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 100,
                ['minimum'] = 0,
                ['maximum'] = 100,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = air_cooling_config_intf_types.InitialSpeedPercent
            },
            ['ActiveAlgorithm'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'N/A',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = air_cooling_config_intf_types.ActiveAlgorithm
            },
            ['SpeedDeviationThresholdPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['minimum'] = 10,
                ['maximum'] = 100,
                ['default'] = 25,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = air_cooling_config_intf_types.SpeedDeviationThresholdPercent
            }
        },
        ['bmc.kepler.Systems.FanSnapshot'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.AirCoolingConfig'] = {
            ['SetCtrlMode'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['enum'] = {'Auto', 'Manual', 'Mixed'}, ['param'] = 'CtrlMode'},
                    {['baseType'] = 'U32', ['param'] = 'Timeout'}
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['SetCtrlModePersist'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['enum'] = {'Auto', 'Manual', 'Mixed'}, ['param'] = 'CtrlMode'},
                    {['baseType'] = 'U8', ['param'] = 'CtrlModePersistType'},
                    {['baseType'] = 'U32', ['param'] = 'Timeout'}
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['SetManualSpeedPercent'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'FanId'}, {['baseType'] = 'U8', ['param'] = 'SpeedPercent'}
                },
                ['privilege'] = {'BasicSetting'}
            }
        },
        ['bmc.kepler.Systems.FanSnapshot'] = {
            ['GetActivatedPolicyFactors'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Struct', ['$ref'] = '#/defs/FanSnapshot', ['param'] = 'RetData'}},
                ['privilege'] = {'ReadOnly'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/AirCoolingConfig'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.AirCoolingConfig'] = {
            ['property_defaults'] = {
                ['CtrlMode'] = 'Auto',
                ['CtrlModePersistType'] = 0,
                ['CtrlModeResetPersist'] = 'Auto',
                ['CtrlModePoweroffPersist'] = 'Auto',
                ['TimeOut'] = 30,
                ['ManualSpeedPercent'] = 10,
                ['ManualSpeedPercentResetPersist'] = 0,
                ['ManualSpeedPercentPoweroffPersist'] = 0,
                ['SpeedPercentRange'] = air_cooling_config_intf_types.SpeedPercentRange.default[1],
                ['MinAllowedSpeedPercent'] = 255,
                ['InitialSpeedPercent'] = 100,
                ['ActiveAlgorithm'] = 'N/A',
                ['SpeedDeviationThresholdPercent'] = 25
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['CtrlMode'] = {['read'] = privilege.ReadOnly},
                    ['CtrlModePersistType'] = {['read'] = privilege.ReadOnly},
                    ['CtrlModeResetPersist'] = {['read'] = privilege.ReadOnly},
                    ['CtrlModePoweroffPersist'] = {['read'] = privilege.ReadOnly},
                    ['TimeOut'] = {['read'] = privilege.ReadOnly},
                    ['ManualSpeedPercent'] = {['read'] = privilege.ReadOnly},
                    ['ManualSpeedPercentResetPersist'] = {['read'] = privilege.ReadOnly},
                    ['ManualSpeedPercentPoweroffPersist'] = {['read'] = privilege.ReadOnly},
                    ['SpeedPercentRange'] = {['read'] = privilege.ReadOnly},
                    ['MinAllowedSpeedPercent'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['InitialSpeedPercent'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['ActiveAlgorithm'] = {['read'] = privilege.ReadOnly},
                    ['SpeedDeviationThresholdPercent'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.BasicSetting
                    }
                },
                ['methods'] = {
                    ['SetCtrlMode'] = privilege.BasicSetting,
                    ['SetCtrlModePersist'] = privilege.BasicSetting,
                    ['SetManualSpeedPercent'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = air_cooling_config_intf_types
        },
        ['bmc.kepler.Systems.FanSnapshot'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['GetActivatedPolicyFactors'] = privilege.ReadOnly}
            },
            ['interface_types'] = fan_snapshot_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LiquidCoolingConfig = {
    ['prop_configs'] = {
        ['MaxPumpNum'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['default'] = 0,
            ['validator'] = liquid_cooling_config_class_types.MaxPumpNum
        }
    },
    ['default_props'] = {['MaxPumpNum'] = 0},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.LiquidCoolingConfig'] = {
            ['CtrlMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Auto',
                ['enum'] = {'Auto', 'Manual', 'Mixed'},
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = liquid_cooling_config_intf_types.CtrlMode
            },
            ['TimeOut'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 30,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = liquid_cooling_config_intf_types.TimeOut
            },
            ['ManualLevel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 25,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = liquid_cooling_config_intf_types.ManualLevel
            },
            ['LevelPercentRange'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = liquid_cooling_config_intf_types.LevelPercentRange
            },
            ['ActiveAlgorithm'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'N/A',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = liquid_cooling_config_intf_types.ActiveAlgorithm
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.LiquidCoolingConfig'] = {
            ['SetManualLevel'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'UnitId'}, {['baseType'] = 'U8', ['param'] = 'Level'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetCtrlMode'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'CtrlMode'}, {['baseType'] = 'U32', ['param'] = 'Timeout'}
                },
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/LiquidCoolingConfig'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.LiquidCoolingConfig'] = {
            ['property_defaults'] = {
                ['CtrlMode'] = 'Auto',
                ['TimeOut'] = 30,
                ['ManualLevel'] = 25,
                ['LevelPercentRange'] = liquid_cooling_config_intf_types.LevelPercentRange.default[1],
                ['ActiveAlgorithm'] = 'N/A'
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['CtrlMode'] = {['read'] = privilege.ReadOnly},
                    ['TimeOut'] = {['read'] = privilege.ReadOnly},
                    ['ManualLevel'] = {['read'] = privilege.ReadOnly},
                    ['LevelPercentRange'] = {['read'] = privilege.ReadOnly},
                    ['ActiveAlgorithm'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {['SetManualLevel'] = privilege.BasicSetting, ['SetCtrlMode'] = privilege.BasicSetting}
            },
            ['interface_types'] = liquid_cooling_config_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CoolingFan = {
    ['table_name'] = 't_cooling_fan',
    ['prop_configs'] = {
        ['Slot'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = cooling_fan_class_types.Slot},
        ['MaxSupportedPWM'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = cooling_fan_class_types.MaxSupportedPWM
        }
    },
    ['default_props'] = {
        ['Slot'] = cooling_fan_class_types.Slot.default[1],
        ['MaxSupportedPWM'] = cooling_fan_class_types.MaxSupportedPWM.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.CoolingFan'] = {
            ['FanId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = cooling_fan_intf_types.FanId
            },
            ['HardwarePWM'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_fan_intf_types.HardwarePWM
            },
            ['FrontPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_fan_intf_types.FrontPresence
            },
            ['RearPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_fan_intf_types.RearPresence
            },
            ['FrontStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_fan_intf_types.FrontStatus
            },
            ['RearStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_fan_intf_types.RearStatus
            },
            ['FrontSpeed'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_fan_intf_types.FrontSpeed
            },
            ['RearSpeed'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_fan_intf_types.RearSpeed
            },
            ['Level'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_fan_intf_types.Level
            },
            ['ManualSpeedPercentResetPersist'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['minimum'] = 0,
                ['maximum'] = 100,
                ['default'] = 0,
                ['usage'] = {'ResetPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_fan_intf_types.ManualSpeedPercentResetPersist
            },
            ['ManualSpeedPercentPoweroffPersist'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['minimum'] = 0,
                ['maximum'] = 100,
                ['default'] = 0,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_fan_intf_types.ManualSpeedPercentPoweroffPersist
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/CoolingFan/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.CoolingFan'] = {
            ['property_defaults'] = {
                ['FanId'] = cooling_fan_intf_types.FanId.default[1],
                ['HardwarePWM'] = cooling_fan_intf_types.HardwarePWM.default[1],
                ['FrontPresence'] = 1,
                ['RearPresence'] = 1,
                ['FrontStatus'] = 0,
                ['RearStatus'] = 0,
                ['FrontSpeed'] = cooling_fan_intf_types.FrontSpeed.default[1],
                ['RearSpeed'] = cooling_fan_intf_types.RearSpeed.default[1],
                ['Level'] = cooling_fan_intf_types.Level.default[1],
                ['ManualSpeedPercentResetPersist'] = 0,
                ['ManualSpeedPercentPoweroffPersist'] = 0
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Level'] = {['read'] = privilege.ReadOnly},
                    ['ManualSpeedPercentResetPersist'] = {['read'] = privilege.ReadOnly},
                    ['ManualSpeedPercentPoweroffPersist'] = {['read'] = privilege.ReadOnly}
                }
            },
            ['interface_types'] = cooling_fan_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CoolingPump = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.CoolingPump'] = {
            ['Id'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_pump_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_pump_intf_types.Slot
            },
            ['ActualPWM'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_pump_intf_types.ActualPWM
            },
            ['Speed'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = cooling_pump_intf_types.Speed
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 1,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cooling_pump_intf_types.Presence
            },
            ['Status'] = {
                ['baseType'] = 'U8',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cooling_pump_intf_types.Status
            },
            ['Level'] = {
                ['baseType'] = 'U8',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['readOnly'] = true,
                ['validator'] = cooling_pump_intf_types.Level
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/CoolingPumps/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.CoolingPump'] = {
            ['property_defaults'] = {
                ['Id'] = cooling_pump_intf_types.Id.default[1],
                ['Slot'] = cooling_pump_intf_types.Slot.default[1],
                ['ActualPWM'] = cooling_pump_intf_types.ActualPWM.default[1],
                ['Speed'] = cooling_pump_intf_types.Speed.default[1],
                ['Presence'] = 1,
                ['Status'] = 0,
                ['Level'] = cooling_pump_intf_types.Level.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = cooling_pump_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CoolingRequirement = {
    ['table_name'] = 't_cooling_requirement',
    ['prop_configs'] = {
        ['BaseId'] = {['usage'] = {}, ['baseType'] = 'U8', ['validator'] = cooling_requirement_class_types.BaseId},
        ['Slot'] = {['usage'] = {}, ['baseType'] = 'U8', ['validator'] = cooling_requirement_class_types.Slot},
        ['Enabled'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = cooling_requirement_class_types.Enabled
        },
        ['IsValid'] = {
            ['usage'] = {},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = cooling_requirement_class_types.IsValid
        },
        ['BackupRequirementIdx'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U64',
            ['validator'] = cooling_requirement_class_types.BackupRequirementIdx
        },
        ['IsBackupRequirement'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = cooling_requirement_class_types.IsBackupRequirement
        },
        ['ObtainTempFaildToValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['validator'] = cooling_requirement_class_types.ObtainTempFaildToValid
        },
        ['CoolingMedium'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['pattern'] = [=[^(Air|Liquid)$]=],
            ['default'] = 'Air',
            ['validator'] = cooling_requirement_class_types.CoolingMedium
        },
        ['LiquidFailedValue'] = {
            ['privilege'] = {['read'] = {'ReadOnly'}},
            ['usage'] = {'CSR'},
            ['baseType'] = 'U64',
            ['validator'] = cooling_requirement_class_types.LiquidFailedValue
        },
        ['OriginTargetTemperatureCelsius'] = {
            ['usage'] = {},
            ['baseType'] = 'U8',
            ['validator'] = cooling_requirement_class_types.OriginTargetTemperatureCelsius
        },
        ['OriginFailedValue'] = {
            ['usage'] = {},
            ['baseType'] = 'U64',
            ['validator'] = cooling_requirement_class_types.OriginFailedValue
        },
        ['OriginMaxAllowedTemperatureCelsius'] = {
            ['usage'] = {},
            ['baseType'] = 'U8',
            ['validator'] = cooling_requirement_class_types.OriginMaxAllowedTemperatureCelsius
        },
        ['OriginSmartCoolingTargetTemperature'] = {
            ['usage'] = {},
            ['baseType'] = 'U8[]',
            ['validator'] = cooling_requirement_class_types.OriginSmartCoolingTargetTemperature
        },
        ['SmartCoolingTargetTemperature'] = {
            ['usage'] = {'CSR', 'PoweroffPer'},
            ['baseType'] = 'S16[]',
            ['validator'] = cooling_requirement_class_types.SmartCoolingTargetTemperature
        }
    },
    ['default_props'] = {
        ['BaseId'] = cooling_requirement_class_types.BaseId.default[1],
        ['Slot'] = cooling_requirement_class_types.Slot.default[1],
        ['Enabled'] = true,
        ['IsValid'] = 1,
        ['BackupRequirementIdx'] = cooling_requirement_class_types.BackupRequirementIdx.default[1],
        ['IsBackupRequirement'] = false,
        ['ObtainTempFaildToValid'] = cooling_requirement_class_types.ObtainTempFaildToValid.default[1],
        ['CoolingMedium'] = 'Air',
        ['LiquidFailedValue'] = cooling_requirement_class_types.LiquidFailedValue.default[1],
        ['OriginTargetTemperatureCelsius'] = cooling_requirement_class_types.OriginTargetTemperatureCelsius.default[1],
        ['OriginFailedValue'] = cooling_requirement_class_types.OriginFailedValue.default[1],
        ['OriginMaxAllowedTemperatureCelsius'] = cooling_requirement_class_types.OriginMaxAllowedTemperatureCelsius
            .default[1],
        ['OriginSmartCoolingTargetTemperature'] = cooling_requirement_class_types.OriginSmartCoolingTargetTemperature
            .default[1],
        ['SmartCoolingTargetTemperature'] = cooling_requirement_class_types.SmartCoolingTargetTemperature.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.CoolingRequirement'] = {
            ['RequirementId'] = {
                ['baseType'] = 'U64',
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['primaryKey'] = true,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['notAllowNull'] = true,
                ['validator'] = cooling_requirement_intf_types.RequirementId
            },
            ['TemperatureType'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.TemperatureType
            },
            ['ActiveInStandby'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = false,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.ActiveInStandby
            },
            ['TargetTemperatureCelsius'] = {
                ['baseType'] = 'U8',
                ['default'] = 127,
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.TargetTemperatureCelsius
            },
            ['MaxAllowedTemperatureCelsius'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.MaxAllowedTemperatureCelsius
            },
            ['CustomSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.CustomSupported
            },
            ['CustomTargetTemperatureCelsius'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.CustomTargetTemperatureCelsius
            },
            ['TargetTemperatureRangeCelsius'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.TargetTemperatureRangeCelsius
            },
            ['MonitoringStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.MonitoringStatus
            },
            ['MonitoringValue'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.MonitoringValue
            },
            ['FailedValue'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.FailedValue
            },
            ['ThresholdValue'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.ThresholdValue
            },
            ['AlarmSpeed'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.AlarmSpeed
            },
            ['SmartCoolingTargetTemperatureCelsius'] = {
                ['baseType'] = 'S16[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.SmartCoolingTargetTemperatureCelsius
            },
            ['SensorName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_requirement_intf_types.SensorName
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.CoolingRequirement'] = {
            ['SetTargetTemperature'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'TemperatureCelsius'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetSmartCoolingTargetTemperature'] = {
                ['req'] = {{['baseType'] = 'S16[]', ['param'] = 'SmartCoolingTargetTemperature'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetBasicCoolingTargetTemperature'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'BasicCoolingTargetTemperature'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetMaxAllowedTemperature'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'MaxAllowedTemperature'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetFailedValue'] = {
                ['req'] = {{['baseType'] = 'U64', ['param'] = 'FailedValue'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetBackupTemperatureCelsius'] = {['req'] = {{['baseType'] = 'Double', ['param'] = 'TemperatureCelsius'}}},
            ['SetBackupTemperatureStatus'] = {['req'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/CoolingRequirement/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.CoolingRequirement'] = {
            ['property_defaults'] = {
                ['RequirementId'] = cooling_requirement_intf_types.RequirementId.default[1],
                ['TemperatureType'] = 4294967295,
                ['ActiveInStandby'] = false,
                ['TargetTemperatureCelsius'] = 127,
                ['MaxAllowedTemperatureCelsius'] = cooling_requirement_intf_types.MaxAllowedTemperatureCelsius.default[1],
                ['CustomSupported'] = cooling_requirement_intf_types.CustomSupported.default[1],
                ['CustomTargetTemperatureCelsius'] = 255,
                ['TargetTemperatureRangeCelsius'] = cooling_requirement_intf_types.TargetTemperatureRangeCelsius.default[1],
                ['MonitoringStatus'] = cooling_requirement_intf_types.MonitoringStatus.default[1],
                ['MonitoringValue'] = cooling_requirement_intf_types.MonitoringValue.default[1],
                ['FailedValue'] = cooling_requirement_intf_types.FailedValue.default[1],
                ['ThresholdValue'] = cooling_requirement_intf_types.ThresholdValue.default[1],
                ['AlarmSpeed'] = cooling_requirement_intf_types.AlarmSpeed.default[1],
                ['SmartCoolingTargetTemperatureCelsius'] = cooling_requirement_intf_types.SmartCoolingTargetTemperatureCelsius
                    .default[1],
                ['SensorName'] = cooling_requirement_intf_types.SensorName.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['RequirementId'] = {['read'] = privilege.ReadOnly},
                    ['TemperatureType'] = {['read'] = privilege.ReadOnly},
                    ['ActiveInStandby'] = {['read'] = privilege.ReadOnly},
                    ['TargetTemperatureCelsius'] = {['read'] = privilege.ReadOnly},
                    ['MaxAllowedTemperatureCelsius'] = {['read'] = privilege.ReadOnly},
                    ['CustomSupported'] = {['read'] = privilege.ReadOnly},
                    ['CustomTargetTemperatureCelsius'] = {['read'] = privilege.ReadOnly},
                    ['TargetTemperatureRangeCelsius'] = {['read'] = privilege.ReadOnly},
                    ['MonitoringStatus'] = {['read'] = privilege.ReadOnly},
                    ['MonitoringValue'] = {['read'] = privilege.ReadOnly},
                    ['FailedValue'] = {['read'] = privilege.ReadOnly},
                    ['ThresholdValue'] = {['read'] = privilege.ReadOnly},
                    ['AlarmSpeed'] = {['read'] = privilege.ReadOnly},
                    ['SmartCoolingTargetTemperatureCelsius'] = {['read'] = privilege.ReadOnly},
                    ['SensorName'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {
                    ['SetTargetTemperature'] = privilege.BasicSetting,
                    ['SetSmartCoolingTargetTemperature'] = privilege.BasicSetting,
                    ['SetBasicCoolingTargetTemperature'] = privilege.BasicSetting,
                    ['SetMaxAllowedTemperature'] = privilege.BasicSetting,
                    ['SetFailedValue'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = cooling_requirement_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CoolingPolicy = {
    ['table_name'] = 't_cooling_policy',
    ['prop_configs'] = {
        ['TemperatureArray'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'String',
            ['notAllowNull'] = false,
            ['validator'] = cooling_policy_class_types.TemperatureArray
        },
        ['FanSpeedArray'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'String',
            ['notAllowNull'] = false,
            ['validator'] = cooling_policy_class_types.FanSpeedArray
        },
        ['FanType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = cooling_policy_class_types.FanType
        },
        ['DiskTempUnavailableToValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['validator'] = cooling_policy_class_types.DiskTempUnavailableToValid
        },
        ['HDDBackPlaneName'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = cooling_policy_class_types.HDDBackPlaneName
        },
        ['HDDRearBackPlaneName'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = cooling_policy_class_types.HDDRearBackPlaneName
        },
        ['HDDBackPlaneType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['pattern'] = [=[^(FrontPosition|MiddlePosition|RearPosition)$]=],
            ['validator'] = cooling_policy_class_types.HDDBackPlaneType
        },
        ['PCIeCardName'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = cooling_policy_class_types.PCIeCardName
        },
        ['CoolingMedium'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['pattern'] = [=[^(Air|Liquid)$]=],
            ['default'] = 'Air',
            ['validator'] = cooling_policy_class_types.CoolingMedium
        },
        ['OriginTemperatureRangeLow'] = {
            ['usage'] = {},
            ['baseType'] = 'S16[]',
            ['validator'] = cooling_policy_class_types.OriginTemperatureRangeLow
        },
        ['OriginTemperatureRangeHigh'] = {
            ['usage'] = {},
            ['baseType'] = 'S16[]',
            ['validator'] = cooling_policy_class_types.OriginTemperatureRangeHigh
        },
        ['OriginSpeedRangeLow'] = {
            ['usage'] = {},
            ['baseType'] = 'S16[]',
            ['validator'] = cooling_policy_class_types.OriginSpeedRangeLow
        },
        ['OriginSpeedRangeHigh'] = {
            ['usage'] = {},
            ['baseType'] = 'S16[]',
            ['validator'] = cooling_policy_class_types.OriginSpeedRangeHigh
        }
    },
    ['default_props'] = {
        ['TemperatureArray'] = cooling_policy_class_types.TemperatureArray.default[1],
        ['FanSpeedArray'] = cooling_policy_class_types.FanSpeedArray.default[1],
        ['FanType'] = cooling_policy_class_types.FanType.default[1],
        ['DiskTempUnavailableToValid'] = cooling_policy_class_types.DiskTempUnavailableToValid.default[1],
        ['HDDBackPlaneName'] = cooling_policy_class_types.HDDBackPlaneName.default[1],
        ['HDDRearBackPlaneName'] = cooling_policy_class_types.HDDRearBackPlaneName.default[1],
        ['HDDBackPlaneType'] = cooling_policy_class_types.HDDBackPlaneType.default[1],
        ['PCIeCardName'] = cooling_policy_class_types.PCIeCardName.default[1],
        ['CoolingMedium'] = 'Air',
        ['OriginTemperatureRangeLow'] = cooling_policy_class_types.OriginTemperatureRangeLow.default[1],
        ['OriginTemperatureRangeHigh'] = cooling_policy_class_types.OriginTemperatureRangeHigh.default[1],
        ['OriginSpeedRangeLow'] = cooling_policy_class_types.OriginSpeedRangeLow.default[1],
        ['OriginSpeedRangeHigh'] = cooling_policy_class_types.OriginSpeedRangeHigh.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.CoolingPolicy'] = {
            ['PolicyIdx'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['primaryKey'] = true,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.PolicyIdx
            },
            ['PolicyType'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.PolicyType
            },
            ['IsValid'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.IsValid
            },
            ['ExpCondVal'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.ExpCondVal
            },
            ['ActualCondVal'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.ActualCondVal
            },
            ['CustomSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.CustomSupported
            },
            ['FanSpeedRangePercents'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.FanSpeedRangePercents
            },
            ['Hysteresis'] = {
                ['baseType'] = 'U8',
                ['default'] = 0,
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.Hysteresis
            },
            ['TemperatureRangeLow'] = {
                ['baseType'] = 'S16[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.TemperatureRangeLow
            },
            ['TemperatureRangeHigh'] = {
                ['baseType'] = 'S16[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.TemperatureRangeHigh
            },
            ['SpeedRangeLow'] = {
                ['baseType'] = 'S16[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.SpeedRangeLow
            },
            ['SpeedRangeHigh'] = {
                ['baseType'] = 'S16[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = cooling_policy_intf_types.SpeedRangeHigh
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.CoolingPolicy'] = {
            ['SetCustomCoolingPolicy'] = {
                ['req'] = {
                    {['baseType'] = 'U8[]', ['param'] = 'TemperatureArray'},
                    {['baseType'] = 'U8[]', ['param'] = 'FanSpeedArray'}
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['SetHysteresis'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'Hysteresis'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/CoolingPolicy/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.CoolingPolicy'] = {
            ['property_defaults'] = {
                ['PolicyIdx'] = cooling_policy_intf_types.PolicyIdx.default[1],
                ['PolicyType'] = 4294967295,
                ['IsValid'] = 1,
                ['ExpCondVal'] = cooling_policy_intf_types.ExpCondVal.default[1],
                ['ActualCondVal'] = cooling_policy_intf_types.ActualCondVal.default[1],
                ['CustomSupported'] = cooling_policy_intf_types.CustomSupported.default[1],
                ['FanSpeedRangePercents'] = cooling_policy_intf_types.FanSpeedRangePercents.default[1],
                ['Hysteresis'] = 0,
                ['TemperatureRangeLow'] = cooling_policy_intf_types.TemperatureRangeLow.default[1],
                ['TemperatureRangeHigh'] = cooling_policy_intf_types.TemperatureRangeHigh.default[1],
                ['SpeedRangeLow'] = cooling_policy_intf_types.SpeedRangeLow.default[1],
                ['SpeedRangeHigh'] = cooling_policy_intf_types.SpeedRangeHigh.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['PolicyIdx'] = {['read'] = privilege.ReadOnly},
                    ['PolicyType'] = {['read'] = privilege.ReadOnly},
                    ['IsValid'] = {['read'] = privilege.ReadOnly},
                    ['ExpCondVal'] = {['read'] = privilege.ReadOnly},
                    ['ActualCondVal'] = {['read'] = privilege.ReadOnly},
                    ['CustomSupported'] = {['read'] = privilege.ReadOnly},
                    ['FanSpeedRangePercents'] = {['read'] = privilege.ReadOnly},
                    ['Hysteresis'] = {['read'] = privilege.ReadOnly},
                    ['TemperatureRangeLow'] = {['read'] = privilege.ReadOnly},
                    ['TemperatureRangeHigh'] = {['read'] = privilege.ReadOnly},
                    ['SpeedRangeLow'] = {['read'] = privilege.ReadOnly},
                    ['SpeedRangeHigh'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {
                    ['SetCustomCoolingPolicy'] = privilege.BasicSetting,
                    ['SetHysteresis'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = cooling_policy_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CoolingArea = {
    ['prop_configs'] = {
        ['LiquidCoolingDeviceGroup'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['default'] = {},
            ['validator'] = cooling_area_class_types.LiquidCoolingDeviceGroup
        },
        ['Priority'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = cooling_area_class_types.Priority
        }
    },
    ['default_props'] = {['LiquidCoolingDeviceGroup'] = {}, ['Priority'] = 1},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.CoolingArea'] = {
            ['AreaId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cooling_area_intf_types.AreaId
            },
            ['RequirementIdx'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cooling_area_intf_types.RequirementIdx
            },
            ['PolicyIdxGroup'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cooling_area_intf_types.PolicyIdxGroup
            },
            ['FanIdxGroup'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cooling_area_intf_types.FanIdxGroup
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/CoolingArea/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.CoolingArea'] = {
            ['property_defaults'] = {
                ['AreaId'] = cooling_area_intf_types.AreaId.default[1],
                ['RequirementIdx'] = cooling_area_intf_types.RequirementIdx.default[1],
                ['PolicyIdxGroup'] = cooling_area_intf_types.PolicyIdxGroup.default[1],
                ['FanIdxGroup'] = cooling_area_intf_types.FanIdxGroup.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = cooling_area_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local AbnormalFan = {
    ['prop_configs'] = {
        ['Id'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = abnormal_fan_class_types.Id},
        ['FanIdx'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = abnormal_fan_class_types.FanIdx},
        ['Status'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['pattern'] = [=[^(AbnormalRotation|NotInPosition)$]=],
            ['validator'] = abnormal_fan_class_types.Status
        },
        ['FanGroup'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32[]', ['validator'] = abnormal_fan_class_types.FanGroup},
        ['SpeedPercentage'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 80,
            ['validator'] = abnormal_fan_class_types.SpeedPercentage
        },
        ['Priority'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = abnormal_fan_class_types.Priority
        }
    },
    ['default_props'] = {
        ['Id'] = abnormal_fan_class_types.Id.default[1],
        ['FanIdx'] = abnormal_fan_class_types.FanIdx.default[1],
        ['Status'] = abnormal_fan_class_types.Status.default[1],
        ['FanGroup'] = abnormal_fan_class_types.FanGroup.default[1],
        ['SpeedPercentage'] = 80,
        ['Priority'] = 1
    }
}

local AbnormalPump = {
    ['prop_configs'] = {
        ['Id'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = abnormal_pump_class_types.Id},
        ['DeviceId'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = abnormal_pump_class_types.DeviceId},
        ['Models'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['pattern'] = [=[^(AbnormalRotation|NotInPosition|StopWorking)$]=],
            ['validator'] = abnormal_pump_class_types.Models
        },
        ['LiquidCoolingIds'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32[]',
            ['validator'] = abnormal_pump_class_types.LiquidCoolingIds
        },
        ['AirCoolingIds'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32[]',
            ['validator'] = abnormal_pump_class_types.AirCoolingIds
        },
        ['LiquidCoolingPWMs'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = abnormal_pump_class_types.LiquidCoolingPWMs
        },
        ['AirCoolingPWMs'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = abnormal_pump_class_types.AirCoolingPWMs
        }
    },
    ['default_props'] = {
        ['Id'] = abnormal_pump_class_types.Id.default[1],
        ['DeviceId'] = abnormal_pump_class_types.DeviceId.default[1],
        ['Models'] = abnormal_pump_class_types.Models.default[1],
        ['LiquidCoolingIds'] = abnormal_pump_class_types.LiquidCoolingIds.default[1],
        ['AirCoolingIds'] = abnormal_pump_class_types.AirCoolingIds.default[1],
        ['LiquidCoolingPWMs'] = abnormal_pump_class_types.LiquidCoolingPWMs.default[1],
        ['AirCoolingPWMs'] = abnormal_pump_class_types.AirCoolingPWMs.default[1]
    }
}

local CoolingPolicies = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.CoolingPolicies'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.CoolingPolicies'] = {
            ['GetSpecificPWM'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['enum'] = {'Air', 'Liquid'}, ['param'] = 'Medium'},
                    {['baseType'] = 'U8', ['enum'] = {1, 2}, ['param'] = 'PolicyType'}, {
                        ['baseType'] = 'String',
                        ['enum'] = {'EnergySaving', 'LowNoise', 'HighPerformance', 'Custom', 'LiquidCooling'},
                        ['param'] = 'SmartCoolingMode'
                    }, {['baseType'] = 'S16', ['param'] = 'Temperature'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'ControlPWM'}},
                ['privilege'] = {'ReadOnly'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem/CoolingPolicies'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.CoolingPolicies'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['methods'] = {['GetSpecificPWM'] = privilege.ReadOnly}},
            ['interface_types'] = cooling_policies_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local ThermalSubsystem = {
    ['table_name'] = 't_thermal_subsystem',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = thermal_subsystem_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = thermal_subsystem_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.ThermalSubsystem.Pumps'] = {
            ['StandardPumpsResourceEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['default'] = true,
                ['validator'] = thermal_subsystem_pumps_intf_types.StandardPumpsResourceEnabled
            }
        },
        ['bmc.kepler.Chassis.ThermalSubsystem.Metrics'] = {
            ['TotalPowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = metrics_intf_types.TotalPowerWatts
            },
            ['EnergyConsumptionkWh'] = {
                ['baseType'] = 'Double',
                ['ReadOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = metrics_intf_types.EnergyConsumptionkWh
            },
            ['ResetTime'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = metrics_intf_types.ResetTime
            },
            ['TotalPrePowerOnHeatingTimeSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = metrics_intf_types.TotalPrePowerOnHeatingTimeSeconds
            },
            ['TotalRuntimeHeatingTimeSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = metrics_intf_types.TotalRuntimeHeatingTimeSeconds
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.ThermalSubsystem.Metrics'] = {
            ['ResetMetrics'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'BasicSetting'}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/ThermalSubsystem'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.ThermalSubsystem.Pumps'] = {
            ['property_defaults'] = {['StandardPumpsResourceEnabled'] = true},
            ['privileges'] = {['props'] = {['StandardPumpsResourceEnabled'] = {['read'] = privilege.ReadOnly}}},
            ['interface_types'] = thermal_subsystem_pumps_intf_types
        },
        ['bmc.kepler.Chassis.ThermalSubsystem.Metrics'] = {
            ['property_defaults'] = {
                ['TotalPowerWatts'] = metrics_intf_types.TotalPowerWatts.default[1],
                ['EnergyConsumptionkWh'] = metrics_intf_types.EnergyConsumptionkWh.default[1],
                ['ResetTime'] = metrics_intf_types.ResetTime.default[1],
                ['TotalPrePowerOnHeatingTimeSeconds'] = metrics_intf_types.TotalPrePowerOnHeatingTimeSeconds.default[1],
                ['TotalRuntimeHeatingTimeSeconds'] = metrics_intf_types.TotalRuntimeHeatingTimeSeconds.default[1]
            },
            ['privileges'] = {
                ['props'] = {
                    ['TotalPowerWatts'] = {['read'] = privilege.ReadOnly},
                    ['EnergyConsumptionkWh'] = {['read'] = privilege.ReadOnly},
                    ['ResetTime'] = {['read'] = privilege.ReadOnly},
                    ['TotalPrePowerOnHeatingTimeSeconds'] = {['read'] = privilege.ReadOnly},
                    ['TotalRuntimeHeatingTimeSeconds'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {['ResetMetrics'] = privilege.BasicSetting}
            },
            ['interface_types'] = metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local ThermalMgmt = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ThermalMgmt'] = {},
        ['bmc.kepler.Release.ThermalControlStrategy'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.ThermalMgmt'] = {
            ['SetFanPWM'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'SystemId'}, {['baseType'] = 'U8', ['param'] = 'FanId'},
                    {['baseType'] = 'Double', ['param'] = 'PWM'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Result'}},
                ['privilege'] = {'BasicSetting'}
            }
        },
        ['bmc.kepler.Release.ThermalControlStrategy'] = {
            ['GetActivatedPolicy'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['displayDescription'] = 'Cooling device type.', ['param'] = 'Type'}, {
                        ['baseType'] = 'U8',
                        ['displayDescription'] = 'Cooling effective mode, 0: effective factor, 1: algorithm.',
                        ['param'] = 'Mode'
                    }
                },
                ['rsp'] = {
                    {['baseType'] = 'String', ['String'] = '当前生效的散热策略', ['param'] = 'ActivatedPolicy'}
                },
                ['privilege'] = {'ReadOnly'},
                ['displayDescription'] = 'Get activated policy for a specified cooling device type and mode. For example: getactivatedpolicy Fan 0',
                ['cmdName'] = 'getactivatedpolicy'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ThermalMgmt'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ThermalMgmt'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['methods'] = {['SetFanPWM'] = privilege.BasicSetting}},
            ['interface_types'] = thermal_mgmt_intf_types
        },
        ['bmc.kepler.Release.ThermalControlStrategy'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['methods'] = {['GetActivatedPolicy'] = privilege.ReadOnly}},
            ['interface_types'] = thermal_control_strategy_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('Fan', Fan):set_bus(bus)
    class('FanType', FanType):set_bus(bus)
    class('FanInfo', FanInfo):set_bus(bus)
    class('ThermalConfiguration', ThermalConfiguration):set_bus(bus)
    class('PWMChannel', PWMChannel):set_bus(bus)
    class('SystemsFans', SystemsFans):set_bus(bus)
    class('Fans', Fans):set_bus(bus)
    class('Pumps', Pumps):set_bus(bus)
    class('Pump', Pump):set_bus(bus)
    class('Valves', Valves):set_bus(bus)
    class('Valve', Valve):set_bus(bus)
    class('BasicCoolingConfig', BasicCoolingConfig):set_bus(bus)
    class('FanGroup', FanGroup):set_bus(bus)
    class('FanGroupPolicy', FanGroupPolicy):set_bus(bus)
    class('PumpGroup', PumpGroup):set_bus(bus)
    class('CoolingConfig', CoolingConfig):set_bus(bus)
    class('AirCoolingConfig', AirCoolingConfig):set_bus(bus)
    class('LiquidCoolingConfig', LiquidCoolingConfig):set_bus(bus)
    class('CoolingFan', CoolingFan):set_bus(bus)
    class('CoolingPump', CoolingPump):set_bus(bus)
    class('CoolingRequirement', CoolingRequirement):set_bus(bus)
    class('CoolingPolicy', CoolingPolicy):set_bus(bus)
    class('CoolingArea', CoolingArea):set_bus(bus)
    class('AbnormalFan', AbnormalFan):set_bus(bus)
    class('AbnormalPump', AbnormalPump):set_bus(bus)
    class('CoolingPolicies', CoolingPolicies):set_bus(bus)
    class('ThermalSubsystem', ThermalSubsystem):set_bus(bus)
    class('ThermalMgmt', ThermalMgmt):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplFanFanSetFanPWM(cb)
    class('Fan')['bmc.kepler.Systems.Fan'].SetFanPWM = function(obj, ctx, ...)
        local req = fan_intf_types.SetFanPWMReq.new(...):validate(nil, nil, true)
        local rsp = fan_intf_types.SetFanPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFanMetricGetData(cb)
    class('Fan')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFanMetricGetItems(cb)
    class('Fan')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplFanMetricSynDataAcquisitionEnable(cb)
    class('Fan')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSystemsFansFansSetPWM(cb)
    class('SystemsFans')['bmc.kepler.Systems.Fans'].SetPWM = function(obj, ctx, ...)
        local req = fans_intf_types.SetPWMReq.new(...):validate(nil, nil, true)
        local rsp = fans_intf_types.SetPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPumpsSystemsPumpsSetPWM(cb)
    class('Pumps')['bmc.kepler.Systems.Pumps'].SetPWM = function(obj, ctx, ...)
        local req = systems_pumps_intf_types.SetPWMReq.new(...):validate(nil, nil, true)
        local rsp = systems_pumps_intf_types.SetPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplValvesValvesStartPatrol(cb)
    class('Valves')['bmc.kepler.Chassis.Valves'].StartPatrol = function(obj, ctx, ...)
        local req = valves_intf_types.StartPatrolReq.new(...):validate(nil, nil, true)
        local rsp = valves_intf_types.StartPatrolRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigSetCtrlMode(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].SetCtrlMode = function(obj, ctx, ...)
        local req = cooling_config_intf_types.SetCtrlModeReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.SetCtrlModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigSetManualLevel(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].SetManualLevel = function(obj, ctx, ...)
        local req = cooling_config_intf_types.SetManualLevelReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.SetManualLevelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigSetMedium(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].SetMedium = function(obj, ctx, ...)
        local req = cooling_config_intf_types.SetMediumReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.SetMediumRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigSetSmartCoolingMode(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].SetSmartCoolingMode = function(obj, ctx, ...)
        local req = cooling_config_intf_types.SetSmartCoolingModeReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.SetSmartCoolingModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigGetAbnormalPolicyEffectiveStatus(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].GetAbnormalPolicyEffectiveStatus =
        function(obj, ctx, ...)
            local req = cooling_config_intf_types.GetAbnormalPolicyEffectiveStatusReq.new(...):validate(nil, nil, true)
            local rsp =
                cooling_config_intf_types.GetAbnormalPolicyEffectiveStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigSetMinPWM(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].SetMinPWM = function(obj, ctx, ...)
        local req = cooling_config_intf_types.SetMinPWMReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.SetMinPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigGetComponentThermalZone(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].GetComponentThermalZone = function(obj, ctx, ...)
        local req = cooling_config_intf_types.GetComponentThermalZoneReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.GetComponentThermalZoneRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigGetCustomTargetTemperatures(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].GetCustomTargetTemperatures = function(obj, ctx, ...)
        local req = cooling_config_intf_types.GetCustomTargetTemperaturesReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.GetCustomTargetTemperaturesRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingConfigCoolingConfigSetMinAllowedFanSpeedEnabled(cb)
    class('CoolingConfig')['bmc.kepler.Systems.CoolingConfig'].SetMinAllowedFanSpeedEnabled = function(obj, ctx, ...)
        local req = cooling_config_intf_types.SetMinAllowedFanSpeedEnabledReq.new(...):validate(nil, nil, true)
        local rsp = cooling_config_intf_types.SetMinAllowedFanSpeedEnabledRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAirCoolingConfigAirCoolingConfigSetCtrlMode(cb)
    class('AirCoolingConfig')['bmc.kepler.Systems.AirCoolingConfig'].SetCtrlMode = function(obj, ctx, ...)
        local req = air_cooling_config_intf_types.SetCtrlModeReq.new(...):validate(nil, nil, true)
        local rsp = air_cooling_config_intf_types.SetCtrlModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAirCoolingConfigAirCoolingConfigSetCtrlModePersist(cb)
    class('AirCoolingConfig')['bmc.kepler.Systems.AirCoolingConfig'].SetCtrlModePersist = function(obj, ctx, ...)
        local req = air_cooling_config_intf_types.SetCtrlModePersistReq.new(...):validate(nil, nil, true)
        local rsp = air_cooling_config_intf_types.SetCtrlModePersistRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAirCoolingConfigAirCoolingConfigSetManualSpeedPercent(cb)
    class('AirCoolingConfig')['bmc.kepler.Systems.AirCoolingConfig'].SetManualSpeedPercent = function(obj, ctx, ...)
        local req = air_cooling_config_intf_types.SetManualSpeedPercentReq.new(...):validate(nil, nil, true)
        local rsp = air_cooling_config_intf_types.SetManualSpeedPercentRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAirCoolingConfigFanSnapshotGetActivatedPolicyFactors(cb)
    class('AirCoolingConfig')['bmc.kepler.Systems.FanSnapshot'].GetActivatedPolicyFactors = function(obj, ctx, ...)
        local req = fan_snapshot_intf_types.GetActivatedPolicyFactorsReq.new(...):validate(nil, nil, true)
        local rsp = fan_snapshot_intf_types.GetActivatedPolicyFactorsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLiquidCoolingConfigLiquidCoolingConfigSetManualLevel(cb)
    class('LiquidCoolingConfig')['bmc.kepler.Systems.LiquidCoolingConfig'].SetManualLevel = function(obj, ctx, ...)
        local req = liquid_cooling_config_intf_types.SetManualLevelReq.new(...):validate(nil, nil, true)
        local rsp = liquid_cooling_config_intf_types.SetManualLevelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLiquidCoolingConfigLiquidCoolingConfigSetCtrlMode(cb)
    class('LiquidCoolingConfig')['bmc.kepler.Systems.LiquidCoolingConfig'].SetCtrlMode = function(obj, ctx, ...)
        local req = liquid_cooling_config_intf_types.SetCtrlModeReq.new(...):validate(nil, nil, true)
        local rsp = liquid_cooling_config_intf_types.SetCtrlModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingRequirementCoolingRequirementSetTargetTemperature(cb)
    class('CoolingRequirement')['bmc.kepler.Systems.CoolingRequirement'].SetTargetTemperature = function(obj, ctx, ...)
        local req = cooling_requirement_intf_types.SetTargetTemperatureReq.new(...):validate(nil, nil, true)
        local rsp = cooling_requirement_intf_types.SetTargetTemperatureRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingRequirementCoolingRequirementSetSmartCoolingTargetTemperature(cb)
    class('CoolingRequirement')['bmc.kepler.Systems.CoolingRequirement'].SetSmartCoolingTargetTemperature = function(
        obj, ctx, ...)
        local req = cooling_requirement_intf_types.SetSmartCoolingTargetTemperatureReq.new(...):validate(nil, nil, true)
        local rsp =
            cooling_requirement_intf_types.SetSmartCoolingTargetTemperatureRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingRequirementCoolingRequirementSetBasicCoolingTargetTemperature(cb)
    class('CoolingRequirement')['bmc.kepler.Systems.CoolingRequirement'].SetBasicCoolingTargetTemperature = function(
        obj, ctx, ...)
        local req = cooling_requirement_intf_types.SetBasicCoolingTargetTemperatureReq.new(...):validate(nil, nil, true)
        local rsp =
            cooling_requirement_intf_types.SetBasicCoolingTargetTemperatureRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingRequirementCoolingRequirementSetMaxAllowedTemperature(cb)
    class('CoolingRequirement')['bmc.kepler.Systems.CoolingRequirement'].SetMaxAllowedTemperature =
        function(obj, ctx, ...)
            local req = cooling_requirement_intf_types.SetMaxAllowedTemperatureReq.new(...):validate(nil, nil, true)
            local rsp =
                cooling_requirement_intf_types.SetMaxAllowedTemperatureRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingRequirementCoolingRequirementSetFailedValue(cb)
    class('CoolingRequirement')['bmc.kepler.Systems.CoolingRequirement'].SetFailedValue = function(obj, ctx, ...)
        local req = cooling_requirement_intf_types.SetFailedValueReq.new(...):validate(nil, nil, true)
        local rsp = cooling_requirement_intf_types.SetFailedValueRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingRequirementCoolingRequirementSetBackupTemperatureCelsius(cb)
    class('CoolingRequirement')['bmc.kepler.Systems.CoolingRequirement'].SetBackupTemperatureCelsius =
        function(obj, ctx, ...)
            local req = cooling_requirement_intf_types.SetBackupTemperatureCelsiusReq.new(...):validate(nil, nil, true)
            local rsp =
                cooling_requirement_intf_types.SetBackupTemperatureCelsiusRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingRequirementCoolingRequirementSetBackupTemperatureStatus(cb)
    class('CoolingRequirement')['bmc.kepler.Systems.CoolingRequirement'].SetBackupTemperatureStatus =
        function(obj, ctx, ...)
            local req = cooling_requirement_intf_types.SetBackupTemperatureStatusReq.new(...):validate(nil, nil, true)
            local rsp =
                cooling_requirement_intf_types.SetBackupTemperatureStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingPolicyCoolingPolicySetCustomCoolingPolicy(cb)
    class('CoolingPolicy')['bmc.kepler.Systems.CoolingPolicy'].SetCustomCoolingPolicy = function(obj, ctx, ...)
        local req = cooling_policy_intf_types.SetCustomCoolingPolicyReq.new(...):validate(nil, nil, true)
        local rsp = cooling_policy_intf_types.SetCustomCoolingPolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingPolicyCoolingPolicySetHysteresis(cb)
    class('CoolingPolicy')['bmc.kepler.Systems.CoolingPolicy'].SetHysteresis = function(obj, ctx, ...)
        local req = cooling_policy_intf_types.SetHysteresisReq.new(...):validate(nil, nil, true)
        local rsp = cooling_policy_intf_types.SetHysteresisRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCoolingPoliciesCoolingPoliciesGetSpecificPWM(cb)
    class('CoolingPolicies')['bmc.kepler.Chassis.CoolingPolicies'].GetSpecificPWM = function(obj, ctx, ...)
        local req = cooling_policies_intf_types.GetSpecificPWMReq.new(...):validate(nil, nil, true)
        local rsp = cooling_policies_intf_types.GetSpecificPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplThermalSubsystemMetricsResetMetrics(cb)
    class('ThermalSubsystem')['bmc.kepler.Chassis.ThermalSubsystem.Metrics'].ResetMetrics = function(obj, ctx, ...)
        local req = metrics_intf_types.ResetMetricsReq.new(...):validate(nil, nil, true)
        local rsp = metrics_intf_types.ResetMetricsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplThermalMgmtThermalMgmtSetFanPWM(cb)
    class('ThermalMgmt')['bmc.kepler.ThermalMgmt'].SetFanPWM = function(obj, ctx, ...)
        local req = thermal_mgmt_intf_types.SetFanPWMReq.new(...):validate(nil, nil, true)
        local rsp = thermal_mgmt_intf_types.SetFanPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplThermalMgmtThermalControlStrategyGetActivatedPolicy(cb)
    class('ThermalMgmt')['bmc.kepler.Release.ThermalControlStrategy'].GetActivatedPolicy = function(obj, ctx, ...)
        local req = thermal_control_strategy_intf_types.GetActivatedPolicyReq.new(...):validate(nil, nil, true)
        local rsp = thermal_control_strategy_intf_types.GetActivatedPolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplCustomTarTempCtrInit(cb)
    Feature1:set_default_callback('CustomTarTempCtrInit', cb)
end

function M.CustomTarTempCtrInit(...)
    local req = private_class_types.CustomTarTempCtrInitReq.new(...):validate(nil, nil, true)
    local rsp = private_class_types.CustomTarTempCtrInitRsp.new(Feature1:CustomTarTempCtrInit(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomPidUpdateSensorValue(cb)
    Feature1:set_default_callback('CustomPidUpdateSensorValue', cb)
end

function M.CustomPidUpdateSensorValue(...)
    local req = private_class_types.CustomPidUpdateSensorValueReq.new(...):validate(nil, nil, true)
    local rsp =
        private_class_types.CustomPidUpdateSensorValueRsp.new(Feature1:CustomPidUpdateSensorValue(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomPidCountValue(cb)
    Feature1:set_default_callback('CustomPidCountValue', cb)
end

function M.CustomPidCountValue(...)
    local req = private_class_types.CustomPidCountValueReq.new(...):validate(nil, nil, true)
    local rsp = private_class_types.CustomPidCountValueRsp.new(Feature1:CustomPidCountValue(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomSetTargetTempConfig(cb)
    Feature1:set_default_callback('CustomSetTargetTempConfig', cb)
end

function M.CustomSetTargetTempConfig(...)
    local req = private_class_types.CustomSetTargetTempConfigReq.new(...):validate(nil, nil, true)
    local rsp =
        private_class_types.CustomSetTargetTempConfigRsp.new(Feature1:CustomSetTargetTempConfig(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomSetFanConfig(cb)
    Feature1:set_default_callback('CustomSetFanConfig', cb)
end

function M.CustomSetFanConfig(...)
    local req = private_class_types.CustomSetFanConfigReq.new(...):validate(nil, nil, true)
    local rsp = private_class_types.CustomSetFanConfigRsp.new(Feature1:CustomSetFanConfig(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomSetRealTimeTemp(cb)
    Feature1:set_default_callback('CustomSetRealTimeTemp', cb)
end

function M.CustomSetRealTimeTemp(...)
    local req = private_class_types.CustomSetRealTimeTempReq.new(...):validate(nil, nil, true)
    local rsp =
        private_class_types.CustomSetRealTimeTempRsp.new(Feature1:CustomSetRealTimeTemp(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomSetEnvTempConfig(cb)
    Feature1:set_default_callback('CustomSetEnvTempConfig', cb)
end

function M.CustomSetEnvTempConfig(...)
    local req = private_class_types.CustomSetEnvTempConfigReq.new(...):validate(nil, nil, true)
    local rsp =
        private_class_types.CustomSetEnvTempConfigRsp.new(Feature1:CustomSetEnvTempConfig(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomSetFanAlarmSpeed(cb)
    Feature1:set_default_callback('CustomSetFanAlarmSpeed', cb)
end

function M.CustomSetFanAlarmSpeed(...)
    local req = private_class_types.CustomSetFanAlarmSpeedReq.new(...):validate(nil, nil, true)
    local rsp =
        private_class_types.CustomSetFanAlarmSpeedRsp.new(Feature1:CustomSetFanAlarmSpeed(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomSetSensorName(cb)
    Feature1:set_default_callback('CustomSetSensorName', cb)
end

function M.CustomSetSensorName(...)
    local req = private_class_types.CustomSetSensorNameReq.new(...):validate(nil, nil, true)
    local rsp = private_class_types.CustomSetSensorNameRsp.new(Feature1:CustomSetSensorName(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomSetFanSpeed(cb)
    Feature1:set_default_callback('CustomSetFanSpeed', cb)
end

function M.CustomSetFanSpeed(...)
    local req = private_class_types.CustomSetFanSpeedReq.new(...):validate(nil, nil, true)
    local rsp = private_class_types.CustomSetFanSpeedRsp.new(Feature1:CustomSetFanSpeed(req:unpack())):validate()
    return rsp:unpack(true)
end

-- The callback needs to be registered during app initialization
function M.ImplCustomReadInfo(cb)
    Feature1:set_default_callback('CustomReadInfo', cb)
end

function M.CustomReadInfo(...)
    local req = private_class_types.CustomReadInfoReq.new(...):validate(nil, nil, true)
    local rsp = private_class_types.CustomReadInfoRsp.new(Feature1:CustomReadInfo(req:unpack())):validate()
    return rsp:unpack(true)
end

return M
