-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_vpd_connector = require 'nvme.vpd_connector'

TestVpdConnector = {}

function TestVpdConnector.test_update_connector()
    c_vpd_connector.RefConnector = {
        AuxId = '255'
    }
    c_vpd_connector.verify_vpd_protocol = function() return 255 end
    c_vpd_connector:update_connector()
    lu.assertEquals('255', c_vpd_connector.RefConnector.AuxId)
    c_vpd_connector.verify_vpd_protocol = function() return 0 end
    c_vpd_connector:update_connector()
    c_vpd_connector:dtor()
    lu.assertEquals('0', c_vpd_connector.RefConnector.AuxId)
end