local lu = require 'luaunit'
local c_controller = require 'controller.controller_object'
local battery_collection = require 'battery.battery_collection'
local c_battery_object = require 'battery.battery_object'

TestUpdateControllerBatteryInfo = {}

function TestUpdateControllerBatteryInfo:test_update_controller_battery_info()
    local controller = {
        Id = 0,
        BatteryPresence = 1,
        BatteryFault = 255,
        BatteryHealth = 1,
        presence_debounce = {}
    }
    controller.presence_debounce.get_debounced_val = function()
        return true
    end
    local battery = {
        Fault = 0
    }
    battery.get_capcacitance_by_controller_id = function(id)
        return {State = 1, Fault = 0, Health = 1}
    end
    battery_collection.get_instance = function()
        return battery
    end
    local ok = pcall(c_controller.update_controller_battery_info, controller)
    lu.assertEquals(ok, true)
    lu.assertEquals(controller.BatteryFault,0)
end

function TestUpdateControllerBatteryInfo:test_check_fault()
    local info = {
        pack_missing = 0,
        temperature_high = 0,
        voltage_low = 0,
        replacepack = 0,
        learn_cycle_failed = 1,
        learn_cycle_timeout = 0,
        predictive_failure = 0,
        remaining_capacity_low = 0,
        no_space = 0,
        failed = 0
    }
    local mock_battery = {
        State = 1,
        Fault = 255,

        pack_missing = 0,
        temperature_high = 0,
        voltage_low = 0,
        replacepack = 0,
        learn_cycle_failed = 0,
        learn_cycle_timeout = 0,
        predictive_failure = 0,
        remaining_capacity_low = 0,
        no_space = 0,
        failed = 0
    }
    c_battery_object.check_fault(mock_battery, info)
    lu.assertEquals(mock_battery.learn_cycle_failed, 1)
    lu.assertEquals(mock_battery.Fault, 1)
end

function TestUpdateControllerBatteryInfo:test_create_battery()
    local mock_obj = {
        RefControllerDeviceName = "PCIe Card 10 (9560-8i)",
        get_parent = function()
            return {Id = 0}
        end
    }

    local mock_battery = {
        RefController = 255,
        pack_missing = 0,
        temperature_high = 0,
        voltage_low = 0,
        replacepack = 0,
        learn_cycle_failed = 0,
        learn_cycle_timeout = 0,
        predictive_failure = 0,
        remaining_capacity_low = 0,
        no_space = 0,
        failed = 0,
        on_update = 255,
        midavg = 255,
        cont_bin = 255,
        enable_request = 255,
        Fault = 255
    }
    c_battery_object.ctor(mock_battery, mock_obj)
    lu.assertEquals(mock_battery.voltage_low, 0)
    lu.assertEquals(mock_battery.replacepack, 0)
end

function TestUpdateControllerBatteryInfo:test_set_battery_default()
    local mock_battery = {
        cont_bin = {
            clear_debounced_val = function() end
        }
    }
    c_battery_object.set_default_values(mock_battery)
    lu.assertEquals(mock_battery.TemperatureCelsius, 0x7ffe)
    lu.assertEquals(mock_battery.enable_request, false)
    lu.assertEquals(mock_battery.State, 255)
end

function TestUpdateControllerBatteryInfo:test_battery_init()
    local origin_func = c_battery_object.super.init
    c_battery_object.super.init = function() end
    local mock_battery = {
        obj = {
            get_parent = function() end
        },
        on_update = {
            on = function() end
        }
    }
    c_battery_object.init(mock_battery)
    lu.assertEquals(mock_battery.RefController, 255)
    lu.assertEquals(mock_battery.State, 255)
    c_battery_object.super.init = origin_func
end

