-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local storageconfig = require 'storageconfig.storageconfig_object'
local controller_collection = require 'controller.controller_collection'
local controller = require 'controller.controller_object'
local common_def = require 'common_def'

local lu = require 'luaunit'

TEST_Storage_Config = {}

function TEST_Storage_Config:test_change_power_state()
    local obj = {
        start_ctrl_loaded_check = function()
        end
    }
    storageconfig.change_power_state(obj, 1)
    lu.assertEquals(obj.power_on, 1)

    storageconfig.change_power_state(obj, 0)
    lu.assertEquals(obj.power_on, 0)
    lu.assertEquals(obj.all_ctrl_loaded, false)
end

function TEST_Storage_Config:test_controller_collection_init()
    local obj = {
        controller_list = {},
        on_add_controller = {
            emit = function() end
        },
        link_interface = function() end,
        on_os_state_changed = {
            on = function() end
        }
    }
    local controller_obj = {
        Id = 0
    }
    local origin_add_on = controller.on_add_object.on
    local origin_fold = controller.collection.fold
    local origin_del_on = controller.on_delete_object.on
    controller.on_add_object.on = function(c, cb)
        cb(controller_obj)
    end
    controller.on_delete_object.on = function(c, cb)
        cb(controller_obj)
    end
    controller.collection.fold = function(c, cb)
        cb(nil, controller_obj)
    end
    controller_collection.init(obj)
    lu.assertEquals(next(obj.controller_list), nil)

    controller.on_add_object.on = origin_add_on
    controller.collection.fold = origin_fold
    controller.on_delete_object.on = origin_del_on
end

function TEST_Storage_Config:test_controller_collection_link_interface()
    local collection_obj = {
        intf_map = {}
    }
    local controller_obj = {
        [common_def.CONTROLLER_INTRERFACE[1]] = 1
    }

    controller_collection.link_interface(collection_obj, controller_obj, true)
    lu.assertEquals(collection_obj.intf_map[1], controller_obj)
end