-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local common_def = require 'common_def'
local sff = require 'nvme.sff_protocol.ssd_form_factor'

TEST_SSD_FORM_FACTOR = {}

function TEST_SSD_FORM_FACTOR:test_vpd_raid_ssd_form_get_info()
    local prefunc = sff.update_manufacture_id
    local prefunc2 = sff.update_manufacture
    sff.VPDChip = true
    sff.nvme_vpd_info = {
        ManufacturerId = common_def.INVALID_U16,
        Manufacturer = common_def.INVALID_STRING
    }
    sff.update_manufacture_id = function()
        sff.nvme_vpd_info.ManufacturerId = 1 
    end
    sff.update_manufacture = function()
        sff.nvme_vpd_info.Manufacturer = "NNN"
    end
    ret = sff.vpd_raid_ssd_form_get_info(sff)
    lu.assertEquals(ret.Manufacturer, "NNN")
    lu.assertEquals(ret.ManufacturerId, 1)
    sff.update_manufacture_id = prefunc
    sff.update_manufacture = prefunc2
end

function TEST_SSD_FORM_FACTOR:test_vpd_raid_ssd_form_get_info_error()
    sff.VPDChip = false
    ret = sff.vpd_raid_ssd_form_get_info(sff)
    lu.assertNil(ret)
end

return TEST_SSD_FORM_FACTOR