-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local sml = require 'sml'
local sml_core = require 'sml.core'

TestSml = {}

function TestSml:setupClass()
    sml.mctp_infos.set_bmc_mctp_info(3, 4)
end

function TestSml:teardownClass()
    sml.mctp_infos.clean_mctp_info()
    sml.mctp_infos.set_bmc_mctp_info(0, 0)
end

function TestSml.test_sml_register_controller()
    local ctrl = sml.register_ctrl_oob.new()
    pcall(function ()
        ctrl.i_controller_index = 1
        ctrl.i_oob_operate = sml.SML_REGISTER_CTRL
        ctrl.i_oob_interface_type = sml.OOB_TYPE_OVER_PCIE
        ctrl:register_controller()
    end)
    if ctrl then
        ctrl:__close()
    end
end

function TestSml.test_set_bmc_mctp_info()
    sml.mctp_infos.set_bmc_mctp_info(1, 2)
    lu.assertEquals({ sml.mctp_infos.get_bmc_mctp_info() }, { 1, 2 })

    sml.mctp_infos.set_bmc_mctp_info(3, 4)
    lu.assertEquals({ sml.mctp_infos.get_bmc_mctp_info() }, { 3, 4 })
end

function TestSml.test_add_mctp_info()
    local info = { id = 1, eid = 2, phy_addr = 3, vendor_id = 0x1E81 }
    sml.mctp_infos.add_mctp_info(info.id, info.eid, info.phy_addr, info.vendor_id)
    lu.assertEquals({ sml.mctp_infos.get_mctp_info(info.id) },
        { info.phy_addr, info.vendor_id })
end

function TestSml.test_register_controller()
    local ctrl = sml_core.register_ctrl_oob.new()
    ctrl.i_controller_index = 1
    ctrl.i_oob_operate = 1
    ctrl.i_controller_typeid = 99
    local ret = ctrl:register_sml_adapter_function()
    lu.assertEquals(ret, nil)
end