-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local drive_collection = require 'drive.drive_collection'
local rpc_service_drive = require 'rpc_services.rpc_service_drive'

TESTRPCService = {}

-- 测试根据硬盘名称获取硬盘私有信息
function TESTRPCService:test_get_drive_infos()
    drive_collection.new().get_presence_on_drives = function ()
        return {
            {
                Name = "Disk0",
                ActivationLed = 1,
                HddBackplaneStartSlot = 0,
                RelativeSlot = 0,
                LinkFault = 0,
                CommandTimeoutTimes = 10,
                UnexpectedSenseTimes = 20,
            },
            {
                Name = "Disk1",
                ActivationLed = 0,
                HddBackplaneStartSlot = 0,
                RelativeSlot = 1,
                LinkFault = 1,
                CommandTimeoutTimes = 20,
                UnexpectedSenseTimes = 30
            },
        }
    end
    rsp = rpc_service_drive.get_drive_info_by_name("test", "*")
    -- 检查信息
    lu.assertEquals(#rsp, 2)
    lu.assertNotEquals(rsp[1].DriveInfo, nil)
    lu.assertEquals(rsp[2].DriveInfo["LinkFault"], "1")
    lu.assertEquals(rsp[2].DriveInfo["UnexpectedSenseTimes"], "30")
end

function TESTRPCService:test_drive_collection_get_presence_on_drives()
    local ok, rsp = pcall(drive_collection.new().get_presence_on_drives)
    lu.assertEquals(ok, true)
    lu.assertEquals(#rsp, 0)
end
