-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local common_def = require 'common_def'
local c_drive = require 'drive.drive_object'
local nvme = require 'nvme.nvme_object'
local sff = require 'nvme.sff_protocol.ssd_form_factor'

TEST_NVME_RAID = {}

function TEST_NVME_RAID:test_update_raid_nvme_info_error()
    -- prepare
    nvme.protocol = common_def.INVALID_U8
    nvme.pcie_nvme_get_protocol_type = function() return common_def.INVALID_U8 end
    ret = nvme:update_raid_nvme_info()
    lu.assertNil(ret)
end

function TEST_NVME_RAID:test_update_raid_nvme_info()
    -- case 1
    local prefunc = nvme.vpd_raid_nvme_mi_get_info
    nvme.protocol = common_def.NVME_VPD_PROTOCOL_NVME_MI
    nvme.vpd_raid_nvme_mi_get_info = function() return { Manufacturer = 'NNN' } end
    info = nvme:update_raid_nvme_info()
    lu.assertEquals(info.Manufacturer, 'NNN')
    nvme.vpd_raid_nvme_mi_get_info = prefunc
    
    -- case 2
    local prefunc2 = sff.vpd_raid_ssd_form_get_info
    nvme.protocol = 100
    nvme.ssd_form_factor = sff
    sff.vpd_raid_ssd_form_get_info = function() return { Manufacturer = 'NNN' } end
    info = nvme:update_raid_nvme_info()
    lu.assertEquals(info.Manufacturer, 'NNN')
    sff.vpd_raid_ssd_form_get_info = prefunc2
end

function TEST_NVME_RAID:test_update_drive_manufacturer_by_specific_obj_variants()
    -- case: nil obj -> no error
    ret = c_drive.update_drive_manufacturer_by_specific_obj(nil)
    lu.assertNil(ret)

    -- case: obj.update_raid_nvme_info returns nil
    local obj1 = {
        update_raid_nvme_info = function() return nil end
    }
    ret = c_drive.update_drive_manufacturer_by_specific_obj(obj1)
    lu.assertNil(ret)

    -- case: returns info with Manufacturer
    local obj2 = {
        update_raid_nvme_info = function()
            return { Manufacturer = 'MYMANU' }
        end
    }
    c_drive.update_drive_manufacturer_by_specific_obj(c_drive, obj2)
    lu.assertEquals(c_drive.Manufacturer, 'MYMANU')
end

return TEST_NVME_RAID
