-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local nvme_mi_mctp = require 'nvme.nvme_mi_protocol.nvme_mi_mctp'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'
local project_dir = os.getenv('PROJECT_DIR')

TEST_nvme_mi_mctp = {}

-- 测试dump日志
function TEST_nvme_mi_mctp:test_collect_nvme_dump_smart_log()
    local obj = {
        nvme = {
            Slot                     = 1
        },
        smart_log = {
            host_reads               = 69889,
            critical_warning         = 0,
            endu_grp_crit_warn_sumry = 0,
            critical_comp_time       = 0,
            avail_spare              = 100,
            thm_temp1_trans_count    = 0,
            power_on_hours           = 17,
            unsafe_shutdowns         = 1,
            temperature              = 307,
            warning_temp_time        = 2,
            ctrl_busy_time           = 0,
            power_cycles             = 52,
            data_units_read          = 2918,
            percent_used             = 1,
            thm_temp1_total_time     = 0,
            thm_temp2_total_time     = 308,
            thm_temp2_trans_count    = 0,
            num_err_log_entries      = 0,
            media_errors             = 0,
            temp_sensor1             = 0,
            temp_sensor2             = 0,
            temp_sensor3             = 0,
            temp_sensor4             = 0,
            temp_sensor5             = 0,
            temp_sensor6             = 0,
            temp_sensor7             = 0,
            temp_sensor8             = 0,
            host_writes              = 3286,
            data_units_written       = 51,
            spare_thresh             = 10
        }
    }
    nvme_mi_mctp.collect_nvme_smart_log(obj)
    local file_path = "/data/var/log/storage/drivelog/Disk1/nvme_smart.log"

    local file = file_sec.open_s(file_path, "r")
    lu.assertNotIsNil(file)
    local content = utils.close(file, pcall(file.read, file, "*a"))
    lu.assertNotIsNil(content)
    -- 检查信息
    lu.assertNotEquals(string.find(content, 'critical_warning'), nil)
    lu.assertNotEquals(string.find(content, 'temperature'), nil)
    lu.assertNotEquals(string.find(content, 'available_spare'), nil)

    utils.remove_file(file_path)
end