-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local method_misc = require 'method_misc'
local common_def = require 'common_def'

TestMethodMisc = {}

function TestMethodMisc:test_check_read_policy()
    local ret
    local read_policy, type_id = 3, common_def.PMC_3152_8I_SMART_RAID -1
    ret = method_misc:check_read_policy(read_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    read_policy, type_id = 3, common_def.PMC_3152_8I_SMART_RAID
    ret = method_misc:check_read_policy(read_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    read_policy, type_id = 3, common_def.HI1880_SP186_M_16i
    ret = method_misc:check_read_policy(read_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    read_policy, type_id = 1, common_def.PMC_3152_8I_SMART_RAID - 1
    ret = method_misc:check_read_policy(read_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_SUCCESS)
end

function TestMethodMisc:test_check_recheck_io_policyad_policy()
    local ret
    local io_policy, type_id = 3, common_def.PMC_3152_8I_SMART_RAID -1
    ret = method_misc:check_io_policy(io_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    io_policy, type_id = 3, common_def.PMC_3152_8I_SMART_RAID
    ret = method_misc:check_io_policy(io_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    io_policy, type_id = 3, common_def.HI1880_SP186_M_16i
    ret = method_misc:check_io_policy(io_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    io_policy, type_id = 1, common_def.PMC_3152_8I_SMART_RAID - 1
    ret = method_misc:check_io_policy(io_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_SUCCESS)
end

function TestMethodMisc:test_check_access_policy()
    local ret
    local access_policy, type_id = 3, common_def.PMC_3152_8I_SMART_RAID -1
    ret = method_misc:check_access_policy(access_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    access_policy, type_id = 3, common_def.PMC_3152_8I_SMART_RAID
    ret = method_misc:check_access_policy(access_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    access_policy, type_id = 3, common_def.HI1880_SP186_M_16i
    ret = method_misc:check_access_policy(access_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    access_policy, type_id = 1, common_def.PMC_3152_8I_SMART_RAID - 1
    ret = method_misc:check_access_policy(access_policy, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_SUCCESS)
end

function TestMethodMisc:test_check_BGI()
    local ret
    local BGI_enable, type_id = 3, common_def.PMC_3152_8I_SMART_RAID -1
    ret = method_misc:check_BGI(BGI_enable, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    BGI_enable, type_id = 3, common_def.PMC_3152_8I_SMART_RAID
    ret = method_misc:check_BGI(BGI_enable, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    BGI_enable, type_id = 3, common_def.HI1880_SP186_M_16i
    ret = method_misc:check_BGI(BGI_enable, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_PARA_DATA_ILLEGAL)

    BGI_enable, type_id = 1, common_def.PMC_3152_8I_SMART_RAID - 1
    ret = method_misc:check_BGI(BGI_enable, type_id)
    lu.assertEquals(ret, common_def.SM_CODE_SUCCESS)
end

function TestMethodMisc:test_get_manufacturer_name_by_oui()
    local ret
    local unknown_oui = 'XXXXXX'
    ret = method_misc:get_manufacturer_name_by_oui(unknown_oui)
    lu.assertEquals(ret, 'ATA')

    local ym_oui = 'A428B7'
    ret = method_misc:get_manufacturer_name_by_oui(ym_oui)
    lu.assertEquals(ret, 'YANGTZE MEMORY')
end