-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_drive = require 'drive.drive_object'
local c_drives_object = require 'drives.drives_object'
local c_storage_service = require 'storage.service'
local class = require 'mc.class'
local lu = require 'luaunit'
local sml = require 'sml'


TestDriveSlowDiskInfo = class(c_storage_service)

function TestDriveSlowDiskInfo:test_update_drive_slow_disk_info()
    self.CreateDrives = function()
        return {
            property_changed = {
                on = function()
                end
            }
        }
    end
    self.db = {
        DrivesTableInfo = function()
        end
    }
    c_drives_object.new(self)

    local drive = {
        SlotNumber = 1,
        new_task = function()
            return {
                loop = function(obj, cb)
                    cb({is_exit = false})
                    return {
                        set_timeout_ms = function()
                        end
                    }
                end
            }
        end,
        on_pd_update = {
            emit = function()
            end
        },
        RefControllerId = 0,
        CommandTimeoutTimes = 1,
        UnexpectedSenseTimes = 1,
        MediaType = 0,
        Protocol = 2,
        RefControllerTypeId = 14
    }

    local origin_func = sml.get_pd_slow_disk_info
    sml.get_ctrl_init_state = function()
        return 2
    end
    sml.get_pd_info = function()
        return {
            slot_num = 3,
            device_id = 4
        }
    end
    sml.get_pd_slow_disk_info = function()
        return {
            cmd_timeout_times = 1,
            unexpected_sense_times = 2
        }
    end
    local ok = pcall(c_drive.update_drive_common_info, drive)
    lu.assertEquals(ok, true)
    lu.assertEquals(drive.CommandTimeoutTimes, 1)
    lu.assertEquals(drive.UnexpectedSenseTimes, 1)
    sml.get_pd_info = function()
        return {
            slot_num = 1,
            device_id = 4
        }
    end
    ok = pcall(c_drive.update_drive_common_info, drive)
    lu.assertEquals(ok, true)
    lu.assertEquals(drive.CommandTimeoutTimes, 2)
    lu.assertEquals(drive.UnexpectedSenseTimes, 3)
    sml.get_pd_slow_disk_info = origin_func
end